/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import slick.Texture;

public class Drant
extends EntityLiving {
    public Drant(World w) {
        super(w);
        this.maxrenderdist = 50;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "OreSpawn:Drant";
        this.moveSpeed = 0.15f;
        this.setMaxHealth(1.0f);
        this.setHealth(2.0f);
        this.setDefense(0.75f);
        this.setAttackDamage(0.35f);
        this.searchDistance = 10.0f;
        this.attackRange = 0.75f;
        this.movefrequency = 20;
        this.setExperience(1);
        this.canSwim = false;
        this.isImmuneToFire = true;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = true;
        this.canridemaglevcart = true;
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(1000) == 1 && this.getCanDespawn()) {
            this.deadflag = true;
        }
        super.update(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (ic != null && ic.count != 0) {
            return false;
        }
        if (this.world.isServer && p != null) {
            int id = p.dimension;
            id = id == OreSpawnMain.dragonslairdimension.dimensionID ? Dimensions.overworlddimension.dimensionID : OreSpawnMain.dragonslairdimension.dimensionID;
            Utils.doTeleport(p, id, p.posx, p.posy, p.posz);
            this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            this.world.playSound("DangerZone:big_splat", id, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            Utils.spawnParticlesFromServer(p.world, "DangerZone:ParticleHurt", 10, this.dimension, this.posx, this.posy, this.posz);
            Utils.spawnParticlesFromServer(p.world, "DangerZone:ParticleHurt", 10, id, this.posx, this.posy, this.posz);
        }
        return false;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophydrant.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        return !(e instanceof Drant) && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Drant.png");
        }
        return this.texture;
    }
}

