/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class CrystalCow
extends EntityLiving {
    public CrystalCow(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 1.45f;
        this.width = 0.9f;
        this.uniquename = "OreSpawn:CrystalCow";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(30.0f);
        this.setHealth(30.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        this.movefrequency = 55;
        this.setExperience(45);
        this.canSwim = true;
        this.setCanDespawn(false);
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 5;
        this.enableBreeding(10);
        this.isMilkable = true;
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 5;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.enable_buddy_nearest = this.isBaby();
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof CrystalCow && !e.isBaby();
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.grass.blockID || bid == Blocks.grassblock.blockID) {
            return true;
        }
        return bid == OreSpawnMain.crystalgrass.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
        int bid;
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp();
        }
        if ((bid = this.world.getblock(d, x, y, z)) == Blocks.grass.blockID) {
            this.world.setblockandmetaWithPerm(this, d, x, y, z, 0, 0);
        } else if (bid == OreSpawnMain.crystalgrass.blockID) {
            this.world.setblockandmetaWithPerm(this, d, x, y, z, OreSpawnMain.crystalstone.blockID, 0);
        } else {
            this.world.setblockandmetaWithPerm(this, d, x, y, z, Blocks.dirt.blockID, 0);
        }
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "OreSpawn:cowmoo1";
        }
        if (which == 1) {
            return "OreSpawn:cowmoo2";
        }
        if (which == 2) {
            return "OreSpawn:cowmoo3";
        }
        if (which == 3) {
            return "OreSpawn:cowmoo4";
        }
        if (which == 4) {
            return "OreSpawn:cowmoo5";
        }
        if (which == 5) {
            return "OreSpawn:cowmoo6";
        }
        if (which == 6) {
            return "OreSpawn:cowmoo7";
        }
        if (which == 7) {
            return "OreSpawn:cowmoo8";
        }
        which = this.world.rand.nextInt(5);
        if (which == 1) {
            return "OreSpawn:cowmoo99";
        }
        return "OreSpawn:cowmoo9";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crystalapple.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycrystalcow.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/CrystalCowtexture.png");
        }
        return this.texture;
    }
}

