/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Cryolophosaurus
extends EntityLiving {
    public Cryolophosaurus(World w) {
        super(w);
        this.maxrenderdist = 90;
        this.height = 1.9f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Cryolophosaurus";
        this.moveSpeed = 0.38f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(3.0f);
        this.searchDistance = 9.0f;
        this.attackRange = 1.5f;
        this.movefrequency = 35;
        this.setExperience(19);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return "OreSpawn:cryo_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:cryo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(2);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycryolophosaurus.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Cryolophosaurus) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Cryolophosaurustexture.png");
        }
        return this.texture;
    }
}

