/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Cricket
extends EntityLiving {
    private int singing = 0;
    private int jumpcount = 0;

    public Cricket(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.33f;
        this.width = 0.33f;
        this.uniquename = "OreSpawn:Cricket";
        this.moveSpeed = 0.18f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.15f);
        this.movefrequency = 40;
        this.setExperience(1);
        this.canSwim = false;
        this.daytimespawn = false;
        this.nighttimespawn = true;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.takesFallDamage = false;
        this.canridemaglevcart = true;
        this.canridemaglevcart = true;
    }

    @Override
    public void init() {
        super.init();
        this.setSinging(false);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            if (this.singing > 0) {
                --this.singing;
                if (this.singing <= 0) {
                    this.setSinging(false);
                }
            }
            if (this.jumpcount > 0) {
                --this.jumpcount;
            }
            if (this.jumpcount == 0 && this.world.rand.nextInt(50) == 1) {
                this.jumpAround();
                this.jumpcount = 50;
            }
            if (this.world.rand.nextInt(1000) == 1 && this.getCanDespawn()) {
                this.deadflag = true;
            }
        }
        super.update(deltaT);
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) == 1) {
            return null;
        }
        this.setSinging(true);
        this.singing = 30;
        return "OreSpawn:Cricket";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycricket.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    private void jumpAround() {
        this.target = null;
        this.motiony += 0.55f + Math.abs(this.world.rand.nextFloat() * 0.55f);
        this.posy += 0.25;
        float f = 0.5f + Math.abs(this.world.rand.nextFloat() * 0.65f);
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        this.motionx = (float)((double)this.motionx + (double)f * Math.sin(cdir));
        this.motionz = (float)((double)this.motionz + (double)f * Math.cos(cdir));
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Crickettexture.png");
        }
        return this.texture;
    }
}

