/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Nightmare;
import OreSpawn.entities.TerribleTerror;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class CreepingHorror
extends EntityLiving {
    public CreepingHorror(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 1.0f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:CreepingHorror";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(3.0f);
        this.searchDistance = 20.0f;
        this.attackRange = 2.0f;
        this.movefrequency = 35;
        this.setExperience(19);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return "OreSpawn:creepinghorror_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:creepinghorror_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:creepinghorror_dead";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.string.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycreepinghorror.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Nightmare) {
            return false;
        }
        if (e instanceof CreepingHorror) {
            return false;
        }
        if (e instanceof TerribleTerror) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/CreepingHorrortexture.png");
        }
        return this.texture;
    }
}

