/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Crab
extends EntityLiving {
    public Crab(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.uniquename = "OreSpawn:Crab";
        this.moveSpeed = 0.31f;
        this.movefrequency = 65;
        this.setExperience(199);
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.swimoffset = 0.25f;
        float t = 0.25f;
        if (DangerZone.rand.nextInt(4) == 1) {
            t = 0.5f;
        }
        if (DangerZone.rand.nextInt(8) == 2) {
            t = 1.0f;
        }
        this.setVarFloat(21, t);
        this.setExperience((int)(200.0f * t));
        this.height = 2.75f * t;
        this.width = 6.75f * t;
        this.setMaxHealth(200.0f * t);
        this.setHealth(200.0f * t);
        this.setDefense(2.0f + t);
        this.setAttackDamage(30.0f * t);
        this.searchDistance = 16.0f + 8.0f * t;
        this.attackRange = 3.0f + t * 2.0f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 10;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockdisteat = 0;
        this.foodblockheal = 0;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = true;
    }

    @Override
    public void init() {
        super.init();
        float t = this.getCrabScale();
        this.setExperience((int)(200.0f * t));
        this.height = 2.75f * t;
        this.width = 6.75f * t;
        this.setMaxHealth(200.0f * t);
        this.setHealth(200.0f * t);
        this.setDefense(2.0f + t);
        this.setAttackDamage(30.0f * t);
        this.searchDistance = 16.0f + 8.0f * t;
        this.attackRange = 3.0f + t * 2.0f;
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.getInLiquid()) {
            this.moveSpeed = 0.96f * this.getCrabScale();
            this.enable_findfoodblock = false;
        } else {
            this.moveSpeed = 0.66f * this.getCrabScale();
            this.enable_findfoodblock = true;
        }
        super.doEntityAction(deltaT);
    }

    public float getCrabScale() {
        float t = this.getVarFloat(21);
        if (t == 0.0f) {
            t = 0.25f;
        }
        return t;
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.getInLiquid()) {
            return "DangerZone:little_splash";
        }
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:leaves_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:crunch";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        howmany = (int)((float)howmany * (4.0f * this.getCrabScale()));
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crabmeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycrab.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Crab) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Crabtexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        if (this.getCrabScale() > 0.75f) {
            return "Very Large Crab!";
        }
        return "Crab";
    }
}

