/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Coin
extends EntityLiving {
    public Coin(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 2.0f;
        this.width = 2.0f;
        this.uniquename = "OreSpawn:Coin";
        this.moveSpeed = 0.0f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 4000;
        this.setExperience(1);
        this.canSwim = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            this.rotation_yaw_motion = 1.0f;
        }
        super.update(deltaT);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.world.rand.nextInt(1200) == 1) {
            this.doDropEggs();
        }
        super.doEntityAction(deltaT);
    }

    private void doDropEggs() {
        int howmany = 1 + this.world.rand.nextInt(5);
        int which = this.world.rand.nextInt(3);
        int iid = Items.coinsilver.itemID;
        if (which == 0) {
            iid = Items.coinsilver.itemID;
        } else if (which == 1) {
            iid = Items.coingold.itemID;
        } else if (which == 2) {
            iid = Items.coinplatinum.itemID;
        }
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, iid, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.15f, 1.0f);
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doDeathDrops() {
        int which = this.world.rand.nextInt(10);
        if (which == 0) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.eggcoin.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.ruby.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 2) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.amethyst.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 3) {
            Utils.doDropRand(this.world, 0, Items.emerald.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 4) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.nuggeturanium.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 5) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.nuggettitanium.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 6) {
            Utils.doDropRand(this.world, 0, Items.coingold.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 7) {
            Utils.doDropRand(this.world, 0, Items.coinsilver.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 8) {
            Utils.doDropRand(this.world, 0, Items.coinplatinum.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (which == 9) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycoin.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Cointexture.png");
        }
        return this.texture;
    }
}

