/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Cicada
extends EntityLiving {
    float myspeed = 0.0f;
    public float attackRange = 1.5f;
    public Entity targetentity = null;
    public Texture texture2 = null;

    public Cicada(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.uniquename = "OreSpawn:Cicada";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(1);
        this.height = 0.45f;
        this.width = 0.45f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.searchDistance = 16.0f;
        this.canFly = true;
        this.setFlying(true);
        if (DangerZone.rand.nextInt(100) == 1) {
            this.setBID(1);
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        int keep_trying = 25;
        if (this.isFlying()) {
            int bid;
            this.do_swarm_despawn();
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.world.rand.nextInt(30) == 1) {
                    this.targetentity = null;
                }
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + 1.0, this.targetentity.posz);
                }
            }
            if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(300) == 1) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                bid = 1;
            }
            if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                int updown = 5;
                int k = 1;
                while (k < 8) {
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                    if (bid != 0) {
                        updown = -1;
                        break;
                    }
                    ++k;
                }
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    if (this.isSwarming()) {
                        this.target.setTarget(this.posx + (double)this.world.rand.nextInt(15), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(15));
                    } else {
                        this.target.setTarget(this.posx + (double)this.world.rand.nextInt(10) - (double)this.world.rand.nextInt(10), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(10) - (double)this.world.rand.nextInt(10));
                    }
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                        bid = 1;
                    }
                    --keep_trying;
                    this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.1f;
                }
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            float dy = (float)(this.target.targety - this.posy);
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0f) > 0.2f) {
                dy = 0.2f;
            }
            if (dy < -0.2f) {
                dy = -0.2f;
            }
            this.motiony += dy;
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath(this);
            if (!this.isSwarming() && this.world.rand.nextInt(300) == 1) {
                this.setFlying(false);
                this.make_short_sound();
            }
        } else {
            super.doEntityAction(deltaT);
            if (this.world.rand.nextInt(100) == 1) {
                this.setFlying(true);
                this.make_short_sound();
            } else if (this.world.rand.nextInt(80) == 1) {
                this.make_short_sound();
            }
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (!(e instanceof EntityLiving)) {
            return false;
        }
        if (e.getHeight() * e.getWidth() < 1.0f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycicada.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Cicadatexture.png");
            this.texture2 = TextureMapper.getTexture("orespawnres/skins/Cicadatexture2.png");
        }
        if (this.getBID() == 1) {
            return this.texture2;
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:cicada_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:cicada_death";
    }

    @Override
    public String getLivingSound() {
        if (DangerZone.rand.nextBoolean()) {
            return "OreSpawn:cicada_long_1";
        }
        return "OreSpawn:cicada_long_2";
    }

    public void make_short_sound() {
        String whichsound = null;
        int which = DangerZone.rand.nextInt(10) + 1;
        if (which == 1) {
            whichsound = "OreSpawn:cicada_short_1";
        }
        if (which == 2) {
            whichsound = "OreSpawn:cicada_short_2";
        }
        if (which == 3) {
            whichsound = "OreSpawn:cicada_short_3";
        }
        if (which == 4) {
            whichsound = "OreSpawn:cicada_short_4";
        }
        if (which == 5) {
            whichsound = "OreSpawn:cicada_short_5";
        }
        if (which == 6) {
            whichsound = "OreSpawn:cicada_short_6";
        }
        if (which == 7) {
            whichsound = "OreSpawn:cicada_short_7";
        }
        if (which == 8) {
            whichsound = "OreSpawn:cicada_short_8";
        }
        if (which == 9) {
            whichsound = "OreSpawn:cicada_short_9";
        }
        if (which == 10) {
            whichsound = "OreSpawn:cicada_short_10";
        }
        if (whichsound != null && !this.isHurt() && !this.deadflag) {
            this.world.playSound(whichsound, this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }
}

