/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.DelayedBabySitter;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import OreSpawn.entities.ThePrincessYoungAdult;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.BlockInstability;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class ChaosDemon
extends EntityLiving {
    float[] facepos = new float[6];
    int curbody = 0;
    int curtail = 0;
    int curfeet = 0;

    public ChaosDemon(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 3.2f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:ChaosDemon";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(800.0f);
        this.setHealth(800.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(65.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 65;
        this.setExperience(1999);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.tower_defense_enable = false;
        this.facepos[0] = 10.0f;
        this.facepos[1] = 20.0f;
        this.facepos[2] = 30.0f;
        this.facepos[3] = 40.0f;
        this.facepos[4] = 50.0f;
        this.facepos[5] = 60.0f;
        this.enable_buddy = true;
        this.findbuddydistance = 64;
        this.findbuddyfrequency = 20;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof ThePrincessYoungAdult;
    }

    @Override
    public void doEntityAction(float deltaT) {
        int dz;
        int dx;
        if (this.world.rand.nextInt(125) == 1) {
            dx = this.world.rand.nextInt(10) + 5;
            dz = this.world.rand.nextInt(10) + 5;
            if (this.world.rand.nextBoolean()) {
                dx = -dx;
            }
            if (this.world.rand.nextBoolean()) {
                dz = -dz;
            }
            int i = -5;
            while (i < 6) {
                if (this.world.getblock(this.dimension, (int)this.posx + dx, (int)this.posy + i, (int)this.posz + dz) != 0 && this.world.getblock(this.dimension, (int)this.posx + dx, (int)this.posy + i + 1, (int)this.posz + dz) == 0) {
                    this.world.setblock(this.dimension, (int)this.posx + dx, (int)this.posy + i + 1, (int)this.posz + dz, Blocks.blockinstability.blockID);
                    BlockInstability b = (BlockInstability)Blocks.BlockArray[Blocks.blockinstability.blockID];
                    b.trigger(this.world, this.dimension, (int)this.posx + dx, (int)this.posy + i + 1, (int)this.posz + dz);
                    break;
                }
                ++i;
            }
        }
        if (this.world.rand.nextInt(100) == 1) {
            dx = this.world.rand.nextInt(10) + 5;
            dz = this.world.rand.nextInt(10) + 5;
            if (this.world.rand.nextBoolean()) {
                dx = -dx;
            }
            if (this.world.rand.nextBoolean()) {
                dz = -dz;
            }
            int i = -5;
            while (i < 6) {
                if (this.world.getblock(this.dimension, (int)this.posx + dx, (int)this.posy + i, (int)this.posz + dz) != 0 && this.world.getblock(this.dimension, (int)this.posx + dx, (int)this.posy + i + 1, (int)this.posz + dz) == 0) {
                    int bid = this.world.rand.nextInt(2048);
                    Block bl = Blocks.getBlock(bid);
                    if (bl == null || !bl.showInInventory) break;
                    this.world.setblock(this.dimension, (int)this.posx + dx, (int)this.posy + i + 1, (int)this.posz + dz, bid);
                    break;
                }
                ++i;
            }
        }
        if (this.world.rand.nextInt(25) == 1) {
            this.heal(1.0f);
        }
        super.doEntityAction(deltaT);
        if (this.world.rand.nextInt(200) == 1) {
            this.jumpAround();
        }
    }

    private void jumpAround() {
        this.motiony += 0.95f + Math.abs(this.world.rand.nextFloat() * 0.95f);
        this.posy += (double)0.33f;
        float f = 0.9f + Math.abs(this.world.rand.nextFloat() * 0.95f);
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        this.motionx = (float)((double)this.motionx + (double)f * Math.sin(cdir));
        this.motionz = (float)((double)this.motionz + (double)f * Math.cos(cdir));
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int i = this.world.rand.nextInt(5);
        if (i == 0) {
            return "OreSpawn:alo_living";
        }
        if (i == 1) {
            return "OreSpawn:beebuzz";
        }
        if (i == 2) {
            return "OreSpawn:Annoyance_living";
        }
        if (i == 3) {
            return "OreSpawn:Varmint_living";
        }
        return "OreSpawn:trex_living";
    }

    @Override
    public String getHurtSound() {
        int i = this.world.rand.nextInt(12);
        if (i == 0) {
            return "OreSpawn:squid_hurt1";
        }
        if (i == 1) {
            return "OreSpawn:squid_hurt2";
        }
        if (i == 2) {
            return "OreSpawn:squid_hurt3";
        }
        if (i == 3) {
            return "OreSpawn:alo_hurt";
        }
        if (i == 4) {
            return "OreSpawn:waterdragon_hurt1";
        }
        if (i == 5) {
            return "OreSpawn:waterdragon_hurt2";
        }
        if (i == 6) {
            return "OreSpawn:waterdragon_hurt3";
        }
        if (i == 7) {
            return "OreSpawn:duck_hurt";
        }
        if (i == 8) {
            return "OreSpawn:gurglehit1";
        }
        if (i == 9) {
            return "OreSpawn:gurglehit2";
        }
        if (i == 10) {
            return "OreSpawn:squeeky";
        }
        return "OreSpawn:gurglehit3";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 25 + this.world.rand.nextInt(25);
        i = 0;
        while (i < howmany) {
            int iid = this.world.rand.nextInt(2048);
            Item it = Items.getItem(iid);
            if (it == null || !it.showInInventory) continue;
            iid = it.itemID;
            ++i;
            Utils.doDropRand(this.world, 0, iid, 5.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        i = 0;
        while (i < howmany) {
            int bid = this.world.rand.nextInt(2048);
            Block bl = Blocks.getBlock(bid);
            if (bl == null || !bl.showInInventory) continue;
            bid = bl.blockID;
            ++i;
            Utils.doDropRand(this.world, bid, 0, 5.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophychaosdemon.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public void update(float deltaT) {
        float f;
        float faster = 0.0f;
        if (this.getAttacking()) {
            faster = 3.5f;
        }
        this.facepos[0] = this.facepos[0] + (faster + 1.0f);
        this.facepos[1] = this.facepos[1] + (faster + 2.0f);
        this.facepos[2] = this.facepos[2] + (faster + 3.0f);
        this.facepos[3] = this.facepos[3] + (faster + 1.5f);
        this.facepos[4] = this.facepos[4] + (faster + 2.5f);
        this.facepos[5] = this.facepos[5] + (faster + 3.5f);
        super.update(deltaT);
        if (!this.world.isServer && this.world.rand.nextInt(15) == 1) {
            f = 0.75f + Math.abs(this.world.rand.nextFloat() * 1.15f);
            Utils.spawnParticles(this.world, "DangerZone:ParticleRain", 1, this.dimension, (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.55f) + this.posx + (double)(f * (float)Math.sin(Math.toRadians(this.rotation_yaw))), this.posy + 1.5, (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.55f) + this.posz + (double)(f * (float)Math.cos(Math.toRadians(this.rotation_yaw))), false);
        }
        if (!this.world.isServer && this.world.rand.nextInt(20) == 1) {
            f = 0.25f + Math.abs(this.world.rand.nextFloat() * 1.65f);
            Utils.spawnParticles(this.world, "DangerZone:ParticleSmoke", 5, this.dimension, (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.75f) + this.posx + (double)(f * (float)Math.sin(Math.toRadians(this.rotation_yaw))), this.posy + 1.5 + (double)(this.world.rand.nextFloat() * 1.25f), (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.75f) + this.posz + (double)(f * (float)Math.cos(Math.toRadians(this.rotation_yaw))), false);
        }
    }

    public float getFacePos(int which) {
        if (which < 0 || which > 5) {
            return 0.0f;
        }
        return (float)Math.sin(Math.toRadians(this.facepos[which]));
    }

    public int getbody() {
        if (DangerZone.world.rand.nextInt(150) == 1) {
            this.curbody = DangerZone.rand.nextInt(3);
        }
        return this.curbody;
    }

    public int getfeet() {
        if (DangerZone.world.rand.nextInt(150) == 1) {
            this.curfeet = DangerZone.rand.nextInt(3);
        }
        return this.curfeet;
    }

    public int gettail() {
        if (DangerZone.world.rand.nextInt(150) == 1) {
            this.curtail = DangerZone.rand.nextInt(2);
        }
        return this.curtail;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (e instanceof Squid) {
            return false;
        }
        if (e instanceof SquidGuard) {
            return false;
        }
        if (e instanceof Kraken) {
            return false;
        }
        if (e instanceof KrakenKing) {
            return false;
        }
        if (e instanceof ThePrincessYoungAdult) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        DelayedBabySitter sc;
        if (e != null) {
            this.teleportnearby(e, 10);
        }
        super.doAttackFrom(e, dt, pain);
        if (this.deadflag && e instanceof EntityLiving && (sc = (DelayedBabySitter)this.world.createEntityByName("OreSpawn:DelayedBabySitter", this.dimension, this.posx, this.posy, this.posz)) != null) {
            sc.init();
            sc.killed_baby = e;
            this.world.spawnEntityInWorld(sc);
            return;
        }
    }

    private void teleportnearby(Entity e, int dist) {
        int tries = 10;
        while (tries > 0) {
            --tries;
            int py = (int)e.posy;
            int px = (int)(e.posx + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
            int pz = (int)(e.posz + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
            int i = -7;
            while (i <= 9) {
                int bid = this.world.getblock(this.dimension, px, py + i, pz);
                if (bid == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 1, pz)) == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 2, pz)) == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 3, pz)) != 0) {
                    int j = 0;
                    while (j < 3) {
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 12, this.dimension, this.posx, this.posy + (double)j, this.posz);
                        ++j;
                    }
                    this.posx = 0.5f + (float)px;
                    this.posz = 0.5f + (float)pz;
                    this.posy = py + i - 2;
                    tries = 0;
                    int which = this.world.rand.nextInt(3);
                    if (which == 0) {
                        this.world.playSound("DangerZone:teleport1", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    if (which == 1) {
                        this.world.playSound("DangerZone:teleport2", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    if (which == 2) {
                        this.world.playSound("DangerZone:teleport3", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
                    this.rotation_yaw = this.rotation_yaw_head = (float)Math.toDegrees(tdir);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/ChaosDemontexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Baby Chaos Demon";
    }
}

