/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class CaterKiller
extends EntityLiving {
    public CaterKiller(World w) {
        super(w);
        this.maxrenderdist = 260;
        this.height = 6.33f;
        this.width = 3.75f;
        this.uniquename = "OreSpawn:CaterKiller";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(300.0f);
        this.setHealth(300.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(40.0f);
        this.searchDistance = 28.0f;
        this.attackRange = 5.0f;
        this.movefrequency = 65;
        this.setExperience(499);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 50;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 7;
        this.foodblockdisteat = 75;
        this.foodblockheal = 5;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = true;
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        this.foodblockfreq = 50;
        if (this.getHealth() + 1.0f < this.getMaxHealth()) {
            this.foodblockfreq = 30;
        }
        if (this.getHealth() < this.getMaxHealth() / 2.0f) {
            this.foodblockfreq = 10;
        }
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        int m = 0;
        while (m < 3) {
            int px = (int)victim.posx + (this.world.rand.nextInt(3) - this.world.rand.nextInt(3));
            int py = (int)victim.posy;
            int pz = (int)victim.posz + (this.world.rand.nextInt(3) - this.world.rand.nextInt(3));
            int i = -5;
            while (i < 4) {
                int bid = this.world.getblock(this.dimension, px, py + i, pz);
                if (bid != 0 && (bid = this.world.getblock(this.dimension, px, py + i + 1, pz)) == 0) {
                    this.world.setblockWithPerm(this, this.dimension, px, py + i + 1, pz, Blocks.stickyblock.blockID);
                    break;
                }
                ++i;
            }
            ++m;
        }
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.log.blockID || bid == Blocks.willowlog.blockID || bid == Blocks.redwoodlog.blockID) {
            return true;
        }
        if (bid == OreSpawnMain.MySkyTreeLog.blockID || bid == OreSpawnMain.MyDT.blockID) {
            return true;
        }
        if (bid == Blocks.leaves.blockID || bid == Blocks.willowleaves.blockID || bid == Blocks.redwoodleaves.blockID) {
            return true;
        }
        return bid == Blocks.appleleaves.blockID || bid == Blocks.cherryleaves.blockID || bid == Blocks.peachleaves.blockID;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:caterkiller_living1";
        }
        if (which == 1) {
            return "OreSpawn:caterkiller_living2";
        }
        if (which == 2) {
            return "OreSpawn:caterkiller_living3";
        }
        return "OreSpawn:caterkiller_living4";
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:caterkiller_hit1";
        }
        if (which == 1) {
            return "OreSpawn:caterkiller_hit2";
        }
        if (which == 2) {
            return "OreSpawn:caterkiller_hit3";
        }
        return "OreSpawn:caterkiller_hit4";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:caterkiller_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.lumptin.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.blocktin.blockID, 0, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinboots.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinleggings.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinchestplate.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinhelmet.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinpickaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinshovel.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinsword.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinhoe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycaterkiller.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.caterkillerjaw.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof CaterKiller) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/CaterKillertexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Caterkiller!";
    }
}

