/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Cassowary
extends EntityLiving {
    public Cassowary(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:Cassowary";
        this.moveSpeed = 0.32f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = true;
        this.enable_avoid = true;
        this.avoiddistance = 25;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.enable_buddy_nearest = this.isBaby();
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Cassowary && !e.isBaby();
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.eggcassowary.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.ostrichmeat.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycassowary.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Cassowarytexture.png");
        }
        return this.texture;
    }
}

