/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Camarasaurus
extends EntityLiving {
    public Camarasaurus(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.9f;
        this.uniquename = "OreSpawn:Camarasaurus";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(5);
        this.canSwim = true;
        this.setCanDespawn(false);
        this.enable_avoid = true;
        this.avoiddistance = 16;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 4;
        this.foodblockdisteat = 12;
        this.foodblockheal = 2;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 18.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Camarasaurus;
    }

    @Override
    public boolean shouldAvoidEntity(Entity e) {
        return e.temperament == 1;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.leaves.blockID || bid == Blocks.willowleaves.blockID || bid == Blocks.redwoodleaves.blockID) {
            return true;
        }
        if (bid == Blocks.appleleaves.blockID || bid == Blocks.cherryleaves.blockID || bid == Blocks.peachleaves.blockID) {
            return true;
        }
        return bid == Blocks.grass.blockID;
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:cryo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, Blocks.flower_red.blockID, 0, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophycamarasaurus.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Camarasaurustexture.png");
        }
        return this.texture;
    }
}

