/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.AntQueen;
import OreSpawn.entities.AntRobot;
import OreSpawn.entities.RedAnt;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class BloodlustAnt
extends EntityLiving {
    public BloodlustAnt(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 2.13f;
        this.width = 2.25f;
        this.uniquename = "OreSpawn:Bloodlust Ant";
        this.moveSpeed = 0.21f;
        this.setMaxHealth(120.0f);
        this.setHealth(120.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(15.0f);
        this.searchDistance = 40.0f;
        this.attackRange = 2.5f;
        this.movefrequency = 65;
        this.setExperience(-240);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
        this.enable_buddy = true;
        this.enable_buddy_nearest = true;
        this.findbuddydistance = 64;
        this.findbuddyfrequency = 15;
    }

    @Override
    public boolean isBuddy(Entity e) {
        if (e instanceof AntQueen) {
            if (((EntityLiving)e).hurtMe != null) {
                this.hurtMe = ((EntityLiving)e).hurtMe;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:clatter1";
        }
        return "OreSpawn:clatter2";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:crunch";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:emperorscorpion_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.lumpcopper.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophybloodlustant.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof BloodlustAnt) {
            return false;
        }
        if (e instanceof AntQueen) {
            return false;
        }
        if (e instanceof AntRobot) {
            return false;
        }
        if (e instanceof RedAnt) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            Player p = (Player)e;
            InventoryContainer ic = p.getHotbar(p.gethotbarindex());
            if (ic != null) {
                Item it = ic.getItem();
                if (it.itemID == OreSpawnMain.antqueenscent.itemID) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/BloodlustAnttexture.png");
        }
        return this.texture;
    }
}

