/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Bird
extends EntityLiving {
    float myspeed = 0.0f;
    public Texture texture2 = null;
    public Texture texture3 = null;
    public Texture texture4 = null;
    public Texture texture5 = null;
    public Texture texture6 = null;

    public Bird(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 0.45f;
        this.width = 0.45f;
        this.uniquename = "OreSpawn:Bird";
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        if (w != null) {
            this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
        }
        this.takesFallDamage = false;
        if (w != null) {
            this.setBID(w.rand.nextInt(6) + 1);
        } else {
            this.setBID(DangerZone.rand.nextInt(6) + 1);
        }
        this.setExperience(3);
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.canFly = true;
        this.setFlying(true);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 25;
            if (!this.world.isDaytime() && this.getCanDespawn() && this.world.rand.nextInt(100) == 1) {
                this.deadflag = true;
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                bid = 1;
            }
            if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                int dirz;
                int dirx;
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    dirx = this.world.rand.nextInt(64) + 10;
                    if (this.world.rand.nextBoolean()) {
                        dirx = -dirx;
                    }
                    dirz = this.world.rand.nextInt(64) + 10;
                    if (this.world.rand.nextBoolean()) {
                        dirz = -dirz;
                    }
                    this.target.setTarget(this.posx + (double)dirx, this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)dirz);
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posy - this.target.targety) * (this.posy - this.target.targety) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz)))) {
                        bid = 1;
                    }
                    --keep_trying;
                }
                if (bid != 0) {
                    keep_trying = 25;
                    while (bid != 0 && keep_trying != 0) {
                        dirx = this.world.rand.nextInt(16);
                        if (this.world.rand.nextBoolean()) {
                            dirx = -dirx;
                        }
                        dirz = this.world.rand.nextInt(16);
                        if (this.world.rand.nextBoolean()) {
                            dirz = -dirz;
                        }
                        this.target.setTarget(this.posx + (double)dirx, this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)dirz);
                        bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                        if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posy - this.target.targety) * (this.posy - this.target.targety) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz)))) {
                            bid = 1;
                        }
                        --keep_trying;
                    }
                }
                this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath(this);
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophybird.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.getBID() == 5) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.ruby.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Bird1.png");
            this.texture2 = TextureMapper.getTexture("orespawnres/skins/Bird2.png");
            this.texture3 = TextureMapper.getTexture("orespawnres/skins/Bird3.png");
            this.texture4 = TextureMapper.getTexture("orespawnres/skins/Bird4.png");
            this.texture5 = TextureMapper.getTexture("orespawnres/skins/Bird5.png");
            this.texture6 = TextureMapper.getTexture("orespawnres/skins/Bird6.png");
        }
        if (this.getBID() == 1) {
            return this.texture2;
        }
        if (this.getBID() == 2) {
            return this.texture3;
        }
        if (this.getBID() == 3) {
            return this.texture4;
        }
        if (this.getBID() == 4) {
            return this.texture5;
        }
        if (this.getBID() == 5) {
            return this.texture6;
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        int which = this.world.rand.nextInt(23) + 1;
        if (which == 1) {
            return "OreSpawn:bird1";
        }
        if (which == 2) {
            return "OreSpawn:bird2";
        }
        if (which == 3) {
            return "OreSpawn:bird3";
        }
        if (which == 4) {
            return "OreSpawn:bird4";
        }
        if (which == 5) {
            return "OreSpawn:bird5";
        }
        if (which == 6) {
            return "OreSpawn:bird6";
        }
        if (which == 7) {
            return "OreSpawn:bird7";
        }
        if (which == 8) {
            return "OreSpawn:bird8";
        }
        if (which == 9) {
            return "OreSpawn:bird9";
        }
        if (which == 10) {
            return "OreSpawn:bird10";
        }
        if (which == 11) {
            return "OreSpawn:bird11";
        }
        if (which == 12) {
            return "OreSpawn:bird12";
        }
        if (which == 13) {
            return "OreSpawn:bird13";
        }
        if (which == 14) {
            return "OreSpawn:bird14";
        }
        if (which == 15) {
            return "OreSpawn:bird15";
        }
        if (which == 16) {
            return "OreSpawn:bird16";
        }
        if (which == 17) {
            return "OreSpawn:bird17";
        }
        if (which == 18) {
            return "OreSpawn:bird18";
        }
        if (which == 19) {
            return "OreSpawn:bird19";
        }
        if (which == 20) {
            return "OreSpawn:bird20";
        }
        if (which == 21) {
            return "OreSpawn:bird21";
        }
        if (which == 22) {
            return "OreSpawn:bird22";
        }
        if (which == 23) {
            return "OreSpawn:bird23";
        }
        return null;
    }
}

