/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Beetle
extends EntityLiving {
    public Beetle(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 3.33f;
        this.width = 3.75f;
        this.uniquename = "OreSpawn:Beetle";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(5.0f);
        this.setAttackDamage(50.0f);
        this.searchDistance = 25.0f;
        this.attackRange = 5.0f;
        this.movefrequency = 65;
        this.setExperience(299);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:hercules_death";
    }

    @Override
    public void doAttack(Entity victim) {
        super.doAttack(victim);
        victim.addKnockback(this, 0.0f, 1.25f + this.world.rand.nextFloat() * 2.5f);
        if (this.world.rand.nextInt(3) == 1) {
            this.world.playSound("OreSpawn:scorpion_living", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
        } else {
            this.world.playSound("OreSpawn:scorpion_attack", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
        }
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.lumpsilver.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.blocksilver.blockID, 0, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silverboots.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silverleggings.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silverchestplate.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silverhelmet.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silveraxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silverpickaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silvershovel.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silversword.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.silverhoe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.bighammer.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophybeetle.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Beetle) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Beetletexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Hercules Beetle";
    }
}

