/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Basilisk
extends EntityLiving {
    public Basilisk(World w) {
        super(w);
        this.maxrenderdist = 190;
        this.height = 3.5f;
        this.width = 1.5f;
        this.uniquename = "OreSpawn:Basilisk";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(150.0f);
        this.setHealth(150.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 22.0f;
        this.attackRange = 5.5f;
        this.movefrequency = 65;
        this.setExperience(169);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public void doAttack(Entity victim) {
        Effects ef = new Effects(2, 2.0f, 100);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:basilisk_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:emperorscorpion_death";
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(200) == 0) {
            this.heal(1.0f);
        }
        super.doEntityAction(deltaT);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 8 + this.world.rand.nextInt(8);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, 0, Items.emerald.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.blockemerald.blockID, 0, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldboots.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldleggings.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldchestplate.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldhelmet.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldpickaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldshovel.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldsword.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.emeraldhoe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophybasilisk.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.basiliskscale.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Basilisk) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Basilisktexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

