/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.entities.AntQueen;
import OreSpawn.entities.BloodlustAnt;
import OreSpawn.entities.Jeffery;
import OreSpawn.entities.RenderSpiderRobotInfo;
import OreSpawn.entities.RoboBomb;
import OreSpawn.entities.RoboGunner;
import OreSpawn.entities.RoboPounder;
import OreSpawn.entities.RoboSniper;
import OreSpawn.entities.RoboWarrior;
import OreSpawn.entities.SpiderRobot;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class AntRobot
extends EntityLiving {
    public RenderSpiderRobotInfo renderdata = new RenderSpiderRobotInfo();
    private int toggledup = 0;

    public AntRobot(World w) {
        super(w);
        this.maxrenderdist = 220;
        this.height = 4.25f;
        this.width = 3.75f;
        this.uniquename = "OreSpawn:Ant Robot";
        this.moveSpeed = 0.15f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(20.15f);
        this.movefrequency = 55;
        this.setExperience(199);
        this.canSwim = false;
        this.sit_when_riding = false;
        this.takesFallDamage = false;
        this.setCanDespawn(false);
        this.searchDistance = 30.0f;
        this.attackRange = 6.5f;
        this.setGroundFactor(0.75f);
        this.setAirFactor(0.75f);
    }

    @Override
    public void init() {
        super.init();
        this.initLegData();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/AntRobottexture.png");
        }
        return this.texture;
    }

    @Override
    public void update(float deltaT) {
        this.updateLegs();
        if (this.world.isServer) {
            if (this.world.rand.nextInt(100) == 1) {
                this.playliving();
            }
        } else {
            double dz;
            double dx;
            int i;
            Entity rider = this.getRiderEntity();
            float velocity = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
            float gh = 0.75f;
            if (rider != null) {
                this.moveSpeed = 0.2f;
                rider.motiony += 0.1f * (deltaT /= 6.0f);
                gh = 1.25f;
                int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)gh), (int)this.posz);
                if (bid != 0 && !Blocks.isLiquid(bid)) {
                    rider.motiony += 0.08f * deltaT;
                }
                float obstruction_factor = 0.0f;
                float dist = 2.0f;
                dist += (float)((int)(velocity * 6.0f));
                int k = 0;
                while ((float)k < dist) {
                    i = 1;
                    while ((float)i < dist * 3.0f) {
                        int j = -60;
                        while (j <= 60) {
                            dx = (double)i * Math.sin(Math.toRadians(this.rotation_yaw + (float)j));
                            bid = this.world.getblock(this.dimension, (int)(this.posx + dx), (int)this.posy + k, (int)(this.posz + (dz = (double)i * Math.cos(Math.toRadians(this.rotation_yaw + (float)j)))));
                            if (bid != 0 && !Blocks.isLiquid(bid)) {
                                obstruction_factor += 0.02f;
                            }
                            j += 20;
                        }
                        ++i;
                    }
                    ++k;
                }
                rider.motiony += obstruction_factor * 0.05f * deltaT;
            }
            int howmany = 1 + this.world.rand.nextInt(3);
            i = 0;
            while (i < howmany) {
                int which = this.world.rand.nextInt(3);
                Particle eb = null;
                dx = (float)(3.0 * Math.sin(Math.toRadians(this.rotation_yaw + 193.0f)));
                dz = (float)(3.0 * Math.cos(Math.toRadians(this.rotation_yaw + 193.0f)));
                if (this.world.rand.nextBoolean()) {
                    dx = (float)(3.0 * Math.sin(Math.toRadians(this.rotation_yaw + 167.0f)));
                    dz = (float)(3.0 * Math.cos(Math.toRadians(this.rotation_yaw + 167.0f)));
                }
                dx += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
                dz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
                if (which == 0) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSparkle", this.dimension, this.posx + dx, this.posy + 2.0, this.posz + dz);
                }
                if (which == 1) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, this.posx + dx, this.posy + 2.0, this.posz + dz);
                }
                if (which == 2) {
                    eb = this.world.createParticleByName("DangerZone:ParticleFire", this.dimension, this.posx + dx, this.posy + 2.0, this.posz + dz);
                }
                if (eb != null) {
                    eb.motiony = 0.0f;
                    dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                    dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                    eb.motionx = (float)(dx * (double)0.18f);
                    eb.motionz = (float)(dz * (double)0.18f);
                    eb.maxlifetime = 10 + this.world.rand.nextInt(10);
                    this.world.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        super.update(deltaT);
    }

    private void playliving() {
        int which = this.world.rand.nextInt(11);
        if (which == 0) {
            this.world.playSound("OreSpawn:robotspider1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 1) {
            this.world.playSound("OreSpawn:robotspider2", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 2) {
            this.world.playSound("OreSpawn:robotspider3", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 3) {
            this.world.playSound("OreSpawn:robotspider4", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 4) {
            this.world.playSound("OreSpawn:robotspider5", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 5) {
            this.world.playSound("OreSpawn:robotspider6", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 6) {
            this.world.playSound("OreSpawn:robotspider7", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 7) {
            this.world.playSound("OreSpawn:robotspider8", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 8) {
            this.world.playSound("OreSpawn:robotspider9", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 9) {
            this.world.playSound("OreSpawn:robotspider10", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 10) {
            this.world.playSound("OreSpawn:robotspider11", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "OreSpawn:robot_hurt1";
        }
        if (which == 1) {
            return "OreSpawn:robot_hurt2";
        }
        if (which == 2) {
            return "OreSpawn:robot_hurt3";
        }
        if (which == 3) {
            return "OreSpawn:robot_hurt4";
        }
        if (which == 4) {
            return "OreSpawn:robot_hurt5";
        }
        if (which == 5) {
            return "OreSpawn:robot_hurt6";
        }
        if (which == 6) {
            return "OreSpawn:robot_hurt7";
        }
        return null;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null && (this.getOwnerName() == null || this.getOwnerName() != null && p.myname.equals(this.getOwnerName()))) {
                if (this.isMountedBy(p)) {
                    this.unMount(p);
                } else {
                    this.Mount(p);
                    this.world.playSound("OreSpawn:robotspidermount", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
                }
                return false;
            }
            if (ic != null && ic.iid == Items.lumpplatinum.itemID) {
                this.heal(50.0f);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                return true;
            }
            if (ic != null && ic.iid == Items.vampireteeth.itemID) {
                this.setOwnerName(null);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                return true;
            }
        }
        return super.rightClickedByPlayer(p, ic);
    }

    @Override
    public float getRiderYoffset() {
        return 1.35f;
    }

    @Override
    public float getRiderXZoffset() {
        return -0.75f;
    }

    @Override
    public void setBaby(boolean tf) {
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof AntRobot) {
            return false;
        }
        if (e instanceof AntQueen) {
            return false;
        }
        if (e instanceof BloodlustAnt) {
            return false;
        }
        if (e instanceof SpiderRobot) {
            return false;
        }
        if (e instanceof Jeffery) {
            return false;
        }
        if (e instanceof RoboBomb) {
            return false;
        }
        if (e instanceof RoboGunner) {
            return false;
        }
        if (e instanceof RoboPounder) {
            return false;
        }
        if (e instanceof RoboWarrior) {
            return false;
        }
        if (e instanceof RoboSniper) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        float gh = 0.75f;
        if (rider == null) {
            this.moveSpeed = 0.15f;
            this.motiony += 0.1f * deltaT;
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)gh + 1.0), (int)this.posz);
            if (bid == 0) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)gh), (int)this.posz);
            }
            if (bid != 0 && !Blocks.isLiquid(bid)) {
                this.motiony += 0.14f * deltaT;
            }
        }
        if (rider == null && this.getOwnerName() != null) {
            return;
        }
        this.doFeettAttack();
        this.doNormalAttack();
        if (rider == null) {
            this.rotation_yaw_motion *= 0.75f;
            this.jumpstrength = 0.15f * this.getHeight();
            super.doEntityAction(deltaT);
            return;
        }
        if (!(rider instanceof Player)) {
            this.jumpstrength = 0.15f * this.getHeight();
            super.doEntityAction(deltaT);
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        this.jumpstrength = 0.65f * this.getHeight();
        if (!rider.getUp()) {
            this.toggledup = 0;
        }
        if (this.toggledup == 0 && rider.getUp() && this.getNearGround()) {
            this.toggledup = 1;
            rider.jump(this.jumpstrength);
        }
    }

    private boolean getNearGround() {
        int solidcount = 0;
        int k = 0;
        while (k < 5 && solidcount < 5) {
            int j = 0;
            while (j >= -5 && solidcount < 5) {
                int bid = this.world.getblock(this.dimension, (int)(this.posx + (double)k), (int)this.posy + j, (int)(this.posz + (double)k));
                if (bid != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx - (double)k), (int)this.posy + j, (int)(this.posz + (double)k))) != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx + (double)k), (int)this.posy + j, (int)(this.posz - (double)k))) != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx - (double)k), (int)this.posy + j, (int)(this.posz - (double)k))) != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                --j;
            }
            ++k;
        }
        return solidcount >= 5;
    }

    private void initLegData() {
        if (this.renderdata == null) {
            this.renderdata = new RenderSpiderRobotInfo();
        }
        int i = 0;
        while (i < 6) {
            this.renderdata.ycurrentangle[i] = 0.0f;
            this.renderdata.ywantedangle[i] = 0.0f;
            this.renderdata.ydisplayangle[i] = 0.0f;
            this.renderdata.yvelocity[i] = 0.0f;
            this.renderdata.ymid[i] = 0.0f;
            this.renderdata.yoff[i] = 0.0f;
            this.renderdata.yrange[i] = 0.0f;
            this.renderdata.udcurrentangle[i] = 0.0f;
            this.renderdata.udwantedangle[i] = 0.0f;
            this.renderdata.uddisplayangle[i] = 0.0f;
            this.renderdata.udvelocity[i] = 0.0f;
            this.renderdata.p1xangle[i] = 0.7853981633974483;
            this.renderdata.p2xangle[i] = 0.0;
            this.renderdata.p3xangle[i] = -0.7853981633974483;
            this.renderdata.pxvelocity[i] = 0.0f;
            this.renderdata.foot_xpos[i] = this.posx;
            this.renderdata.foot_ypos[i] = this.posy;
            this.renderdata.foot_zpos[i] = this.posz;
            this.renderdata.realposx[i] = 0.0;
            this.renderdata.realposy[i] = 0.0;
            this.renderdata.realposz[i] = 0.0;
            this.renderdata.legoff[i] = 0.0f;
            this.renderdata.footup[i] = 1;
            this.renderdata.uppoint[i] = 0.0;
            this.renderdata.footingticker[i] = DangerZone.rand.nextInt(10);
            this.renderdata.gpcounter = 0;
            if (i == 0) {
                this.renderdata.legoff[i] = 0.75f;
                this.renderdata.ymid[i] = -1.5707964f;
                this.renderdata.yrange[i] = 0.2617994f;
                this.renderdata.pairedwith[i] = 1;
                this.renderdata.yoff[i] = -0.75f;
            }
            if (i == 1) {
                this.renderdata.legoff[i] = 0.75f;
                this.renderdata.ymid[i] = 1.5707964f;
                this.renderdata.yrange[i] = -0.2617994f;
                this.renderdata.pairedwith[i] = 0;
                this.renderdata.yoff[i] = -0.75f;
            }
            if (i == 2) {
                this.renderdata.legoff[i] = 1.0f;
                this.renderdata.ymid[i] = -0.7853982f;
                this.renderdata.yrange[i] = 0.2617994f;
                this.renderdata.pairedwith[i] = 3;
                this.renderdata.yoff[i] = -0.75f;
            }
            if (i == 3) {
                this.renderdata.legoff[i] = 1.0f;
                this.renderdata.ymid[i] = 0.7853982f;
                this.renderdata.yrange[i] = -0.2617994f;
                this.renderdata.pairedwith[i] = 2;
                this.renderdata.yoff[i] = -0.75f;
            }
            if (i == 4) {
                this.renderdata.legoff[i] = 1.15f;
                this.renderdata.ymid[i] = -2.3561945f;
                this.renderdata.yrange[i] = 0.2617994f;
                this.renderdata.pairedwith[i] = 5;
                this.renderdata.yoff[i] = -0.75f;
            }
            if (i == 5) {
                this.renderdata.legoff[i] = 1.15f;
                this.renderdata.ymid[i] = 2.3561945f;
                this.renderdata.yrange[i] = -0.2617994f;
                this.renderdata.pairedwith[i] = 4;
                this.renderdata.yoff[i] = -0.75f;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateLegs() {
        if (!this.world.isServer) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.rotation_yaw += 360.0f;
lbl4:
            // 2 sources

            ** while (this.rotation_yaw < 0.0f)
        }
lbl5:
        // 2 sources

        while (this.rotation_yaw > 360.0f) {
            this.rotation_yaw -= 360.0f;
        }
        ++this.renderdata.gpcounter;
        d1 = (float)(this.prevposx - this.posx);
        d2 = (float)(this.prevposy - this.posy);
        d3 = (float)(this.prevposz - this.posz);
        realv = (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
        realv *= 2.0f;
        i = 0;
        i = 0;
        while (i < 6) {
            fcount = 0;
            v0 = i;
            this.renderdata.footingticker[v0] = this.renderdata.footingticker[v0] + 1;
            this.renderdata.realposx[i] = this.posx + (double)this.renderdata.legoff[i] * Math.sin(Math.toRadians(this.rotation_yaw) + (double)this.renderdata.ymid[i]);
            this.renderdata.realposz[i] = this.posz + (double)this.renderdata.legoff[i] * Math.cos(Math.toRadians(this.rotation_yaw) + (double)this.renderdata.ymid[i]);
            this.renderdata.realposy[i] = this.posy + (double)this.renderdata.yoff[i];
            it = this.renderdata.footingticker[i] + this.renderdata.footingticker[this.renderdata.pairedwith[i]];
            if (it > 75 && this.renderdata.footingticker[i] > this.renderdata.footingticker[this.renderdata.pairedwith[i]]) {
                this.renderdata.footingticker[i] = 0;
            }
            d1 = this.renderdata.realposx[i] - this.renderdata.foot_xpos[i];
            d2 = this.renderdata.realposy[i] - this.renderdata.foot_ypos[i];
            d3 = this.renderdata.realposz[i] - this.renderdata.foot_zpos[i];
            dd = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
            dd *= 16.0;
            da = (double)this.renderdata.ywantedangle[i] - Math.toRadians(this.rotation_yaw + 180.0f);
            da -= (double)this.renderdata.ymid[i];
            while (da > 3.141592653589793) {
                da -= 6.283185307179586;
            }
            while (da < -3.141592653589793) {
                da += 6.283185307179586;
            }
            da = Math.abs(da);
            if (dd > 144.0 || dd < 22.0 || da > (double)(Math.abs(this.renderdata.yrange[i]) * 8.0f / 6.0f) || (double)Math.abs(this.renderdata.udcurrentangle[i]) > 1.25 || this.renderdata.footingticker[i] == 0) {
                this.findNewFooting(i);
                d1 = this.renderdata.realposx[i] - this.renderdata.foot_xpos[i];
                d2 = this.renderdata.realposy[i] - this.renderdata.foot_ypos[i];
                d3 = this.renderdata.realposz[i] - this.renderdata.foot_zpos[i];
                dd = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
                dd *= 16.0;
            }
            c1 = (float)(49.0 * Math.cos(this.renderdata.p2xangle[i] - this.renderdata.p1xangle[i]));
            c2 = 49.0f;
            c3 = (float)(49.0 * Math.cos(this.renderdata.p2xangle[i] - this.renderdata.p3xangle[i]));
            cc = c1 + c2 + c3;
            diff = (float)((double)cc - dd);
            this.renderdata.pxvelocity[i] = this.getNewVelocity(realv, (float)((double)diff * 3.141592653589793 / 360.0), this.renderdata.pxvelocity[i]);
            if (this.renderdata.pxvelocity[i] == 0.0f || Math.abs(diff) < 8.0f) {
                ++fcount;
            }
            v1 = i;
            this.renderdata.p1xangle[v1] = this.renderdata.p1xangle[v1] + (double)this.renderdata.pxvelocity[i];
            this.renderdata.p2xangle[i] = 0.0;
            this.renderdata.p3xangle[i] = -this.renderdata.p1xangle[i];
            if (this.renderdata.footup[i] != 0) {
                dd = this.renderdata.uppoint[i] != 0.0 ? (double)((float)Math.atan2(dd, (this.renderdata.realposy[i] - this.renderdata.uppoint[i]) * 16.0)) : (double)((float)Math.atan2(dd, (this.renderdata.realposy[i] - this.renderdata.foot_ypos[i]) * 16.0));
                this.renderdata.udwantedangle[i] = (float)(dd - 1.5707963267948966);
                while ((double)this.renderdata.udwantedangle[i] > 3.141592653589793) {
                    v2 = i;
                    this.renderdata.udwantedangle[v2] = (float)((double)this.renderdata.udwantedangle[v2] - 6.283185307179586);
                }
                while ((double)this.renderdata.udwantedangle[i] < -3.141592653589793) {
                    v3 = i;
                    this.renderdata.udwantedangle[v3] = (float)((double)this.renderdata.udwantedangle[v3] + 6.283185307179586);
                }
                rhm = this.renderdata.udwantedangle[i];
                rhdir = this.renderdata.udcurrentangle[i];
                rdv = (rhm - rhdir) % 6.283185307179586;
                while (rdv > 3.141592653589793) {
                    rdv -= 6.283185307179586;
                }
                while (rdv < -3.141592653589793) {
                    rdv += 6.283185307179586;
                }
                diff = (float)rdv;
                this.renderdata.udvelocity[i] = this.getNewVelocity(realv * 2.0f, diff, this.renderdata.udvelocity[i]);
                if (this.renderdata.udvelocity[i] == 0.0f || (double)Math.abs(diff) < 0.03490658503988659) {
                    this.renderdata.uppoint[i] = 0.0;
                    ++fcount;
                }
                rhdir += (double)this.renderdata.udvelocity[i];
                while (rhdir > 3.141592653589793) {
                    rhdir -= 6.283185307179586;
                }
                while (rhdir < -3.141592653589793) {
                    rhdir += 6.283185307179586;
                }
                this.renderdata.udcurrentangle[i] = (float)rhdir;
                dd = this.renderdata.udcurrentangle[i];
                this.renderdata.uddisplayangle[i] = (float)dd;
            } else {
                dd = (float)Math.atan2(dd, (this.renderdata.realposy[i] - this.renderdata.foot_ypos[i]) * 16.0);
                this.renderdata.udwantedangle[i] = (float)(dd - 1.5707963267948966);
                this.renderdata.uddisplayangle[i] = this.renderdata.udcurrentangle[i] = this.renderdata.udwantedangle[i];
            }
            d1 = this.renderdata.realposx[i] - this.renderdata.foot_xpos[i];
            d3 = this.renderdata.realposz[i] - this.renderdata.foot_zpos[i];
            dd = Math.atan2(d1, d3);
            this.renderdata.ywantedangle[i] = (float)dd;
            rhm = this.renderdata.ywantedangle[i];
            if (this.renderdata.footup[i] != 0) {
                rhdir = this.renderdata.ycurrentangle[i];
                rdv = (rhm - rhdir) % 6.283185307179586;
                if (rdv > 3.141592653589793) {
                    rdv -= 6.283185307179586;
                }
                if (rdv < -3.141592653589793) {
                    rdv += 6.283185307179586;
                }
                diff = (float)rdv;
                this.renderdata.yvelocity[i] = this.getNewVelocity(realv, diff, this.renderdata.yvelocity[i]);
                if (this.renderdata.yvelocity[i] == 0.0f || (double)Math.abs(diff) < 0.03490658503988659) {
                    ++fcount;
                }
                v4 = i;
                this.renderdata.ycurrentangle[v4] = this.renderdata.ycurrentangle[v4] + this.renderdata.yvelocity[i];
                while ((double)this.renderdata.ycurrentangle[i] > 3.141592653589793) {
                    v5 = i;
                    this.renderdata.ycurrentangle[v5] = (float)((double)this.renderdata.ycurrentangle[v5] - 6.283185307179586);
                }
                while ((double)this.renderdata.ycurrentangle[i] < -3.141592653589793) {
                    v6 = i;
                    this.renderdata.ycurrentangle[v6] = (float)((double)this.renderdata.ycurrentangle[v6] + 6.283185307179586);
                }
                dd = (float)Math.toRadians(this.rotation_yaw) - this.renderdata.ycurrentangle[i];
                while (dd > 3.141592653589793) {
                    dd -= 6.283185307179586;
                }
                while (dd < -3.141592653589793) {
                    dd += 6.283185307179586;
                }
                this.renderdata.ydisplayangle[i] = (float)dd;
            } else {
                this.renderdata.ydisplayangle[i] = (float)Math.toRadians(this.rotation_yaw) - this.renderdata.ywantedangle[i];
                this.renderdata.ycurrentangle[i] = this.renderdata.ywantedangle[i];
            }
            if (fcount == 3) {
                this.renderdata.footup[i] = 0;
            }
            ++i;
        }
    }

    private float getNewVelocity(float v, float diff, float curval) {
        float tv = v;
        if ((tv *= 18.0f) < 2.0f) {
            tv = 2.0f;
        }
        if (tv > 8.0f) {
            tv = 8.0f;
        }
        if (diff > 0.0f) {
            if ((double)diff < Math.PI / 360 * (double)tv) {
                curval = 0.0f;
            } else {
                curval = (float)((double)curval + 0.004363323129985824 * (double)tv);
                if ((double)diff < 0.06981317007977318 * (double)tv) {
                    curval = (float)(Math.PI / 180 * (double)tv);
                }
                if ((double)diff < Math.PI / 90 * (double)tv) {
                    curval = (float)(Math.PI / 360 * (double)tv);
                }
                if ((double)curval > 0.06981317007977318 * (double)tv) {
                    curval = (float)(0.06981317007977318 * (double)tv);
                }
            }
        } else if ((double)diff > -Math.PI / 360 * (double)tv) {
            curval = 0.0f;
        } else {
            curval = (float)((double)curval - 0.004363323129985824 * (double)tv);
            if ((double)diff > -0.06981317007977318 * (double)tv) {
                curval = -((float)(Math.PI / 180 * (double)tv));
            }
            if ((double)diff > -Math.PI / 90 * (double)tv) {
                curval = -((float)(Math.PI / 360 * (double)tv));
            }
            if ((double)curval < -0.06981317007977318 * (double)tv) {
                curval = -((float)(0.06981317007977318 * (double)tv));
            }
        }
        return curval;
    }

    private void findNewFooting(int i) {
        double dd;
        double d2;
        double fy;
        double fz;
        double fx;
        float f = 9.0f;
        boolean found = false;
        float range = 0.0f;
        double rhdir = Math.toRadians(this.rotation_yaw % 360.0f);
        double pi = 3.1415926545;
        this.renderdata.footingticker[i] = DangerZone.rand.nextInt(10);
        double d1 = this.posx - this.prevposx;
        double d3 = this.posz - this.prevposz;
        double rhm = Math.atan2(d1, d3);
        while (rhm < 0.0) {
            rhm += Math.PI * 2;
        }
        double velocity = Math.sqrt(d1 * d1 + d3 * d3);
        while (rhdir < 0.0) {
            rhdir += Math.PI * 2;
        }
        double rdv = Math.abs(rhm - rhdir) % (pi * 2.0);
        if (rdv > pi) {
            rdv -= pi * 2.0;
        }
        rdv = Math.abs(rdv);
        if (Math.abs(velocity) < 0.01) {
            rdv = 0.0;
        }
        range = this.renderdata.yrange[i];
        if (Math.abs((this.prevrotation_yaw - this.rotation_yaw) % 360.0f) > 0.75f) {
            range = 0.0f;
        }
        if (i >= 4) {
            f = 4.0f;
        }
        if (rdv > 1.5) {
            range = -range;
            f = 4.0f;
            if (i >= 4) {
                f = 9.0f;
            }
        }
        if (i == 0 || i == 1) {
            f = 6.0f;
        }
        double deffx = fx = this.renderdata.realposx[i] + (double)(f / 2.0f) * Math.sin(Math.toRadians(this.rotation_yaw) + (double)this.renderdata.ymid[i]);
        double deffz = fz = this.renderdata.realposz[i] + (double)(f / 2.0f) * Math.cos(Math.toRadians(this.rotation_yaw) + (double)this.renderdata.ymid[i]);
        double deffy = fy = this.renderdata.realposy[i] - 1.0;
        float oldf = f;
        int span = 1;
        while (!found && f > 2.5f) {
            fx = this.renderdata.realposx[i] + (double)f * Math.sin(Math.toRadians(this.rotation_yaw) + (double)this.renderdata.ymid[i] + (double)range);
            fz = this.renderdata.realposz[i] + (double)f * Math.cos(Math.toRadians(this.rotation_yaw) + (double)this.renderdata.ymid[i] + (double)range);
            fy = this.renderdata.realposy[i];
            int j = 8;
            while (!found && j > -8) {
                int m = -span;
                while (!found && m <= span) {
                    int n = -span;
                    while (!found && n <= span) {
                        int blk = this.world.getblock(this.dimension, (int)fx + m, (int)fy + j, (int)fz + n);
                        if (blk != 0 && Blocks.isSolid(blk)) {
                            d1 = this.renderdata.realposx[i] - (fx + (double)m);
                            d2 = this.renderdata.realposy[i] - (fy + (double)j);
                            d3 = this.renderdata.realposz[i] - (fz + (double)n);
                            dd = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
                            if (!((dd *= 16.0) > 144.0)) {
                                d1 = this.renderdata.realposx[i] - (fx + (double)m);
                                d3 = this.renderdata.realposz[i] - (fz + (double)n);
                                dd = Math.atan2(d1, d3);
                                float da = (float)(dd - Math.toRadians(this.rotation_yaw + 180.0f));
                                da -= this.renderdata.ymid[i];
                                while ((double)da > Math.PI) {
                                    da = (float)((double)da - Math.PI * 2);
                                }
                                while ((double)da < -Math.PI) {
                                    da = (float)((double)da + Math.PI * 2);
                                }
                                if (!((da = Math.abs(da)) > Math.abs(this.renderdata.yrange[i]))) {
                                    fy += (double)j;
                                    fx += (double)m;
                                    fz += (double)n;
                                    found = true;
                                    break;
                                }
                            }
                        }
                        ++n;
                    }
                    ++m;
                }
                --j;
            }
            if (!((f -= 1.0f) < 2.5f) || range == 0.0f) continue;
            range = 0.0f;
            span = 3;
            f = oldf;
        }
        if (!found) {
            fx = deffx;
            fy = deffy;
            fz = deffz;
        }
        double sfx = this.renderdata.foot_xpos[i];
        double sfy = this.renderdata.foot_ypos[i];
        double sfz = this.renderdata.foot_zpos[i];
        this.renderdata.foot_xpos[i] = fx;
        this.renderdata.foot_ypos[i] = fy - (double)0.4f;
        this.renderdata.foot_zpos[i] = fz;
        if (this.renderdata.footup[i] == 0) {
            this.renderdata.footup[i] = 1;
            d1 = sfx - fx;
            d2 = sfy - fy;
            d3 = sfz - fz;
            dd = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
            dd *= 16.0;
            d1 = (sfy + fy) / 2.0;
            if (dd > 3.0) {
                d1 += (double)0.3f;
            }
            if (dd > 24.0) {
                d1 += (double)0.6f;
            }
            if (dd > 50.0) {
                d1 += (double)0.6f;
            }
            this.renderdata.uppoint[i] = d1;
        }
    }

    private void doFeettAttack() {
        if (this.world.rand.nextInt(10) != 1) {
            return;
        }
        List<Entity> critters = this.findSomethingToAttackFoot();
        if (critters != null) {
            Entity e = null;
            ListIterator<Entity> li = critters.listIterator();
            while (li.hasNext()) {
                if (this.world.rand.nextInt(3) != 1) continue;
                e = li.next();
                e.doAttackFrom(this, 0, 3.0f);
            }
        }
    }

    public List<Entity> findSomethingToAttackFoot() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(9.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                double dist = this.getDistanceFromEntityCenter(e);
                if (!(dist < 5.0) && this.isSuitableTargetFoot(e)) continue;
                li.remove();
            }
        }
        return nearby_list;
    }

    public boolean isSuitableTargetFoot(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof AntRobot) {
            return false;
        }
        if (e instanceof AntQueen) {
            return false;
        }
        if (e instanceof BloodlustAnt) {
            return false;
        }
        if (e instanceof SpiderRobot) {
            return false;
        }
        if (e instanceof RoboBomb) {
            return false;
        }
        if (e instanceof RoboGunner) {
            return false;
        }
        if (e instanceof RoboPounder) {
            return false;
        }
        if (e instanceof RoboWarrior) {
            return false;
        }
        if (e instanceof RoboSniper) {
            return false;
        }
        return !(e instanceof Jeffery);
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Giant Ant Robot";
    }
}

