/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Alosaurus
extends EntityLiving {
    public Alosaurus(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 3.33f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:Alosaurus";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(30.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 65;
        this.setExperience(199);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:alo_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.lumpcopper.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.blockcopper.blockID, 0, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperboots.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperleggings.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperchestplate.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperhelmet.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperpickaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.coppershovel.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.coppersword.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.copperhoe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyalosaurus.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Alosaurus) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Alosaurustexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

