/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Alien
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public Alien(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 2.33f;
        this.width = 1.35f;
        this.uniquename = "OreSpawn:Alien";
        this.moveSpeed = 0.96f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 22.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 35;
        this.setExperience(199);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 11;
        this.foodblockdisty = 4;
        this.foodblockdisteat = 27;
        this.foodblockheal = 2;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = true;
    }

    @Override
    public void update(float deltaT) {
        super.update(deltaT);
        if (!this.world.isServer && this.world.rand.nextInt(3) == 1) {
            float f = 0.75f + Math.abs(this.world.rand.nextFloat() * 1.15f);
            Utils.spawnParticles(this.world, "DangerZone:ParticleRain", 1, this.dimension, this.posx + (double)(f * (float)Math.sin(Math.toRadians(this.rotation_yaw))), this.posy + 1.5, this.posz + (double)(f * (float)Math.cos(Math.toRadians(this.rotation_yaw))), false);
        }
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
        this.world.setblockandmetaWithPerm(this, d, x, y, z, 0, 0);
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.lightstick.blockID) {
            return true;
        }
        return bid == OreSpawnMain.extremetorch.blockID;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        return "OreSpawn:alien_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alien_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alien_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.sunstone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, 0, Items.bloodstone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyalien.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Alien) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Alientexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Alien!";
    }
}

