/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ButterflyPlant;
import dangerzone.entities.EntityBlockItem;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;

public class ShrinkberryPlant
extends ButterflyPlant {
    public ShrinkberryPlant(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
        this.isLeaves = true;
        this.maxdamage = 1;
        this.burntime = 10;
        this.showInInventory = false;
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        if (this.blockID == OreSpawnMain.shrinkberry_plant3.blockID) {
            int howmany = 2 + w.rand.nextInt(5);
            int i = 0;
            while (i < howmany) {
                Utils.doDropRand(w, 0, OreSpawnMain.shrinkberries.itemID, 1.0f, dimension, x, y + 1, z);
                Utils.spawnExperience(3, w, dimension, x, y + 1, z);
                ++i;
            }
        }
        return 0;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID) {
            EntityBlockItem e;
            w.setblock(d, x, y, z, 0);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(OreSpawnMain.shrinkberry_plant, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y + 1, z) != 0) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (w.isDaytime() && w.rand.nextInt(45) == 1) {
            int growto = 0;
            if (this.blockID == OreSpawnMain.shrinkberry_plant.blockID) {
                growto = OreSpawnMain.shrinkberry_plant1.blockID;
            }
            if (this.blockID == OreSpawnMain.shrinkberry_plant1.blockID) {
                growto = OreSpawnMain.shrinkberry_plant2.blockID;
            }
            if (this.blockID == OreSpawnMain.shrinkberry_plant2.blockID) {
                growto = OreSpawnMain.shrinkberry_plant3.blockID;
            }
            if (growto != 0) {
                if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                    return;
                }
                w.setblock(d, x, y, z, growto);
            }
        }
    }
}

