/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class QuinoaPlant
extends Block {
    private boolean compiled = false;
    private int squareid3D = 0;
    private float blockrenderwidth = 16.0f;

    public QuinoaPlant(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isLeaves = true;
        this.randomtick = true;
        this.maxdamage = 5;
        this.showInInventory = false;
        this.hasOwnRenderer = true;
        this.burntime = 15;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID && bid != OreSpawnMain.crystalgrass.blockID && bid != OreSpawnMain.quinoa_plant.blockID && bid != OreSpawnMain.quinoa_plant1.blockID && bid != OreSpawnMain.quinoa_plant2.blockID && bid != OreSpawnMain.quinoa_plant3.blockID) {
            w.setblock(d, x, y, z, 0);
            if (this.blockID == OreSpawnMain.quinoa_plant3.blockID) {
                int i = w.rand.nextInt(3) + 1;
                int j = 0;
                while (j < i) {
                    EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (e != null) {
                        e.fill(OreSpawnMain.quinoa, 1);
                        w.spawnEntityInWorld(e);
                    }
                    Utils.spawnExperience(1, w, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    ++j;
                }
            }
        }
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int d, int x, int y, int z) {
        if (this.blockID == OreSpawnMain.quinoa_plant3.blockID) {
            Utils.spawnExperience(1, w, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            return OreSpawnMain.quinoa.itemID;
        }
        return 0;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (this.blockID == OreSpawnMain.quinoa_plant3.blockID) {
            return;
        }
        int Height = 1;
        boolean dontGrow = false;
        if (w.rand.nextInt(12) != 1) {
            return;
        }
        int myMaxHeight = w.getblockmeta(d, x, y, z);
        if ((myMaxHeight &= 0xF) == 0) {
            myMaxHeight = 2 + w.rand.nextInt(3);
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        int bid = w.getblock(d, x, y + 1, z);
        if (bid == 0) {
            int var6 = 1;
            while (var6 < 10) {
                bid = w.getblock(d, x, y - var6, z);
                if (bid != OreSpawnMain.quinoa_plant.blockID && bid != OreSpawnMain.quinoa_plant1.blockID && bid != OreSpawnMain.quinoa_plant2.blockID && bid != OreSpawnMain.quinoa_plant3.blockID) break;
                ++Height;
                if (bid == OreSpawnMain.quinoa_plant2.blockID || bid == OreSpawnMain.quinoa_plant3.blockID) {
                    dontGrow = true;
                }
                ++var6;
            }
            if (dontGrow) {
                myMaxHeight = Height;
            }
            if (Height < myMaxHeight) {
                w.setblockandmeta(d, x, y + 1, z, OreSpawnMain.quinoa_plant.blockID, myMaxHeight);
                w.setblockandmeta(d, x, y, z, OreSpawnMain.quinoa_plant1.blockID, myMaxHeight);
            } else {
                bid = w.getblock(d, x, y, z);
                if (bid == OreSpawnMain.quinoa_plant1.blockID && w.rand.nextInt(2) == 0) {
                    w.setblockandmeta(d, x, y, z, OreSpawnMain.quinoa_plant2.blockID, myMaxHeight);
                } else if (bid == OreSpawnMain.quinoa_plant2.blockID && w.rand.nextInt(2) == 0) {
                    w.setblockandmeta(d, x, y, z, OreSpawnMain.quinoa_plant3.blockID, myMaxHeight);
                } else if (bid == OreSpawnMain.quinoa_plant.blockID && w.rand.nextInt(2) == 0) {
                    w.setblockandmeta(d, x, y, z, OreSpawnMain.quinoa_plant1.blockID, myMaxHeight);
                }
            }
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = builder.findVBOtextureforblockside(0, bid);
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            this.squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(8 * stride);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            QuinoaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)8);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

