/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.blocks.KingSpawnerBlock;
import OreSpawn.entities.KrakenKing;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.world.World;

public class KrakenKingSpawnerBlock
extends KingSpawnerBlock {
    public KrakenKingSpawnerBlock(String n, String txt, int maxd, int mind) {
        super(n, txt, maxd, mind);
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 15, d, (float)x + 0.5f, (float)y + 0.25f, (float)z + 0.5f);
        if (w.rand.nextInt(5) != 1) {
            return;
        }
        this.spawnCreature(w, "OreSpawn:KrakenKing", d, x, y + 1, z);
        w.setblock(d, x, y, z, 0);
    }

    private void spawnCreature(World w, String what, int d, int x, int y, int z) {
        KrakenKing e = (KrakenKing)w.createEntityByName(what, d, x, y, z);
        if (e != null) {
            e.init();
            e.setGuardMode();
            w.spawnEntityInWorld(e);
        }
    }

    @Override
    public void onBlockBroken(Player p, int d, int x, int y, int z, int s) {
        this.spawnCreature(p.world, "OreSpawn:KrakenKing", d, x, y + 1, z);
    }
}

