/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.entities.Entity;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class IslandBlock
extends Block {
    private boolean compiled = false;
    private int squareid3D = 0;
    private float blockrenderwidth = 16.0f;

    public IslandBlock(String n, String txt, int maxd, int mind) {
        super(n, txt);
        this.isStone = true;
        this.maxdamage = maxd;
        this.mindamage = mind;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        boolean isok = true;
        if (!w.isServer) {
            return;
        }
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 15, d, (float)x + 0.5f, (float)y + 0.25f, (float)z + 0.5f);
        if (w.rand.nextInt(4) != 1) {
            return;
        }
        int n = 1 + w.rand.nextInt(3);
        int m = 90;
        int i = 0;
        while (i < n) {
            int height = 30 + w.rand.nextInt(m);
            while (height + y > 250) {
                height -= 16;
            }
            isok = true;
            int k = -10;
            while (k <= 10) {
                int j = -10;
                while (j <= 10) {
                    int bid = w.getblock(d, x + j, y + height, z + k);
                    if (bid != 0) {
                        isok = false;
                        break;
                    }
                    ++j;
                }
                ++k;
            }
            if (isok) {
                if (w.rand.nextInt(20) == 1) {
                    this.spawnCreature(w, "OreSpawn:Island", d, x, y + height, z);
                } else {
                    this.spawnCreature(w, "OreSpawn:IslandToo", d, x, y + height, z);
                }
            }
            ++i;
        }
        w.setblock(d, x, y, z, 0);
    }

    private void spawnCreature(World w, String what, int d, int x, int y, int z) {
        Entity e = w.createEntityByName(what, d, x, y, z);
        if (e != null) {
            e.init();
            w.spawnEntityInWorld(e);
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = builder.findVBOtextureforblockside(0, bid);
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            this.squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(8 * stride);
            IslandBlock.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            IslandBlock.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)8);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

