/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.blocks.ModelTable;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import slick.Texture;

public class BlockTable
extends Block {
    public static ModelTable mdl = null;
    private String fulltexturestring = null;
    private Texture fulltexture = null;

    public BlockTable(String n, String flattxt, String txt) {
        super(n, flattxt);
        this.isSolidForRendering = false;
        this.isSolid = true;
        this.hasOwnRenderer = true;
        this.alwaysRender = true;
        this.maxdamage = 5;
        this.burntime = 90;
        this.friction = 0.65f;
        this.fulltexturestring = txt;
        this.breaksound = "DangerZone:woodbreak";
        this.placesound = "DangerZone:woodplace";
        this.hitsound = "DangerZone:woodhit";
        if (mdl == null) {
            mdl = new ModelTable();
        }
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:wood1";
        }
        if (i == 1) {
            return "DangerZone:wood2";
        }
        if (i == 2) {
            return "DangerZone:wood3";
        }
        return "DangerZone:wood4";
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        int meta = w.getblockmeta(d, x, y, z);
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y, z) != this.blockID) {
            return;
        }
        switch (meta >> 8) {
            case 1: {
                bid = w.getblock(d, x, y, z - 1);
                break;
            }
            case 2: {
                bid = w.getblock(d, x, y, z + 1);
                break;
            }
            case 3: {
                bid = w.getblock(d, x + 1, y, z);
                break;
            }
            case 4: {
                bid = w.getblock(d, x - 1, y, z);
                break;
            }
            case 5: {
                bid = w.getblock(d, x, y + 1, z);
                break;
            }
            default: {
                bid = w.getblock(d, x, y - 1, z);
            }
        }
        if (!Blocks.isSolid(bid)) {
            if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                return;
            }
            w.setblock(d, x, y, z, 0);
            EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            if (e != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public boolean isSolidThisSide(World w, int d, int x, int y, int z, int side) {
        int meta = w.getblockmeta(d, x, y, z);
        switch (meta >> 8) {
            case 0: 
            case 5: {
                if (side == 0 || side == 5) break;
                return false;
            }
            case 1: 
            case 2: {
                if (side == 1 || side == 2) break;
                return false;
            }
            case 3: 
            case 4: {
                if (side == 3 || side == 4) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        if (!Blocks.isSolid(focusbid)) {
            return false;
        }
        if (Blocks.isLeaves(focusbid)) {
            return false;
        }
        if (!Blocks.isSolidThisSide(focusbid, w, dimension, x, y, z, side)) {
            return false;
        }
        if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, 0)) {
            return false;
        }
        switch (side) {
            case 0: {
                w.setblockandmeta(dimension, x, y + 1, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y + 1, z);
                break;
            }
            case 1: {
                w.setblockandmeta(dimension, x, y, z + 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z + 1);
                break;
            }
            case 2: {
                w.setblockandmeta(dimension, x, y, z - 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z - 1);
                break;
            }
            case 3: {
                w.setblockandmeta(dimension, x - 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x - 1, y, z);
                break;
            }
            case 4: {
                w.setblockandmeta(dimension, x + 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x + 1, y, z);
                break;
            }
            case 5: {
                w.setblockandmeta(dimension, x, y - 1, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y - 1, z);
            }
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);
        return true;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.texture == null || this.fulltexture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
            this.fulltexture = this.initBlockTexture(this.fulltexturestring);
        }
        if (side == 5) {
            return this.fulltexture;
        }
        return this.texture;
    }

    @Override
    public String getStitchedTextureName(int side) {
        return this.fulltexturestring;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = builder.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        switch (meta >> 8) {
            case 0: {
                BlockTable.mdl.stem.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.xbase1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.xbase2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        BlockTable.mdl.top.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo + i * 4, yo, zo - j * 4, 0);
                        ++j;
                    }
                    ++i;
                }
                BlockTable.mdl.zbase1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.zbase2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.xbase1a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.xbase2a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.zbase1a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BlockTable.mdl.zbase2a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                break;
            }
            case 1: {
                BlockTable.mdl.stem.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.xbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.xbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        BlockTable.mdl.top.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo + i * 4, yo - j * 4, zo, -90, 0, 0);
                        ++j;
                    }
                    ++i;
                }
                BlockTable.mdl.zbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.zbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.xbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.xbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.zbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                BlockTable.mdl.zbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90, 0, 0);
                break;
            }
            case 2: {
                BlockTable.mdl.stem.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.xbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.xbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        BlockTable.mdl.top.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo + i * 4, yo + j * 4, zo, 90, 0, 0);
                        ++j;
                    }
                    ++i;
                }
                BlockTable.mdl.zbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.zbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.xbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.xbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.zbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                BlockTable.mdl.zbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90, 0, 0);
                break;
            }
            case 3: {
                BlockTable.mdl.stem.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.xbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.xbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        BlockTable.mdl.top.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo + i * 4, zo + j * 4, 0, 0, -90);
                        ++j;
                    }
                    ++i;
                }
                BlockTable.mdl.zbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.zbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.xbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.xbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.zbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                BlockTable.mdl.zbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, -90);
                break;
            }
            case 4: {
                BlockTable.mdl.stem.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.xbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.xbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        BlockTable.mdl.top.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo - j * 4, zo + i * 4, 0, 0, 90);
                        ++j;
                    }
                    ++i;
                }
                BlockTable.mdl.zbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.zbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.xbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.xbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.zbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                BlockTable.mdl.zbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0, 0, 90);
                break;
            }
            case 5: {
                BlockTable.mdl.stem.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.xbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.xbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        BlockTable.mdl.top.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo + i * 4, yo, zo - j * 4, 180, 0, 0);
                        ++j;
                    }
                    ++i;
                }
                BlockTable.mdl.zbase1.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.zbase2.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.xbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.xbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.zbase1a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
                BlockTable.mdl.zbase2a.renderRotatedToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180, 0, 0);
            }
        }
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        MatrixStack.pushMatrix();
        MatrixStack.scale(2.0f, 2.0f, 2.0f);
        MatrixStack.rotate(45.0f, 0.0f, 1.0f, 0.0f);
        MatrixStack.sendCurrentStack();
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 0, 0, false);
        MatrixStack.popMatrix();
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        switch (meta >> 8) {
            case 0: {
                MatrixStack.pushMatrix();
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BlockTable.mdl.stem.render(1.0f);
                BlockTable.mdl.xbase1.render(1.0f);
                BlockTable.mdl.xbase2.render(1.0f);
                BlockTable.mdl.zbase1.render(1.0f);
                BlockTable.mdl.zbase2.render(1.0f);
                BlockTable.mdl.xbase1a.render(1.0f);
                BlockTable.mdl.xbase2a.render(1.0f);
                BlockTable.mdl.zbase1a.render(1.0f);
                BlockTable.mdl.zbase2a.render(1.0f);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        MatrixStack.sendCurrentStack();
                        BlockTable.mdl.top.render(1.0f);
                        MatrixStack.translate(0.0f, 0.0f, -4.0f);
                        ++j;
                    }
                    MatrixStack.translate(0.0f, 0.0f, 16.0f);
                    MatrixStack.translate(4.0f, 0.0f, 0.0f);
                    ++i;
                }
                MatrixStack.popMatrix();
                break;
            }
            case 1: {
                MatrixStack.pushMatrix();
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BlockTable.mdl.stem.render(1.0f);
                BlockTable.mdl.xbase1.render(1.0f);
                BlockTable.mdl.xbase2.render(1.0f);
                BlockTable.mdl.zbase1.render(1.0f);
                BlockTable.mdl.zbase2.render(1.0f);
                BlockTable.mdl.xbase1a.render(1.0f);
                BlockTable.mdl.xbase2a.render(1.0f);
                BlockTable.mdl.zbase1a.render(1.0f);
                BlockTable.mdl.zbase2a.render(1.0f);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        MatrixStack.sendCurrentStack();
                        BlockTable.mdl.top.render(1.0f);
                        MatrixStack.translate(0.0f, 0.0f, -4.0f);
                        ++j;
                    }
                    MatrixStack.translate(0.0f, 0.0f, 16.0f);
                    MatrixStack.translate(4.0f, 0.0f, 0.0f);
                    ++i;
                }
                MatrixStack.popMatrix();
                break;
            }
            case 3: {
                MatrixStack.pushMatrix();
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(-90.0f, 0.0f, 0.0f, 1.0f);
                MatrixStack.sendCurrentStack();
                BlockTable.mdl.stem.render(1.0f);
                BlockTable.mdl.xbase1.render(1.0f);
                BlockTable.mdl.xbase2.render(1.0f);
                BlockTable.mdl.zbase1.render(1.0f);
                BlockTable.mdl.zbase2.render(1.0f);
                BlockTable.mdl.xbase1a.render(1.0f);
                BlockTable.mdl.xbase2a.render(1.0f);
                BlockTable.mdl.zbase1a.render(1.0f);
                BlockTable.mdl.zbase2a.render(1.0f);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        MatrixStack.sendCurrentStack();
                        BlockTable.mdl.top.render(1.0f);
                        MatrixStack.translate(0.0f, 0.0f, -4.0f);
                        ++j;
                    }
                    MatrixStack.translate(0.0f, 0.0f, 16.0f);
                    MatrixStack.translate(4.0f, 0.0f, 0.0f);
                    ++i;
                }
                MatrixStack.popMatrix();
                break;
            }
            case 2: {
                MatrixStack.pushMatrix();
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BlockTable.mdl.stem.render(1.0f);
                BlockTable.mdl.xbase1.render(1.0f);
                BlockTable.mdl.xbase2.render(1.0f);
                BlockTable.mdl.zbase1.render(1.0f);
                BlockTable.mdl.zbase2.render(1.0f);
                BlockTable.mdl.xbase1a.render(1.0f);
                BlockTable.mdl.xbase2a.render(1.0f);
                BlockTable.mdl.zbase1a.render(1.0f);
                BlockTable.mdl.zbase2a.render(1.0f);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        MatrixStack.sendCurrentStack();
                        BlockTable.mdl.top.render(1.0f);
                        MatrixStack.translate(0.0f, 0.0f, -4.0f);
                        ++j;
                    }
                    MatrixStack.translate(0.0f, 0.0f, 16.0f);
                    MatrixStack.translate(4.0f, 0.0f, 0.0f);
                    ++i;
                }
                MatrixStack.popMatrix();
                break;
            }
            case 4: {
                MatrixStack.pushMatrix();
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                MatrixStack.sendCurrentStack();
                BlockTable.mdl.stem.render(1.0f);
                BlockTable.mdl.xbase1.render(1.0f);
                BlockTable.mdl.xbase2.render(1.0f);
                BlockTable.mdl.zbase1.render(1.0f);
                BlockTable.mdl.zbase2.render(1.0f);
                BlockTable.mdl.xbase1a.render(1.0f);
                BlockTable.mdl.xbase2a.render(1.0f);
                BlockTable.mdl.zbase1a.render(1.0f);
                BlockTable.mdl.zbase2a.render(1.0f);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        MatrixStack.sendCurrentStack();
                        BlockTable.mdl.top.render(1.0f);
                        MatrixStack.translate(0.0f, 0.0f, -4.0f);
                        ++j;
                    }
                    MatrixStack.translate(0.0f, 0.0f, 16.0f);
                    MatrixStack.translate(4.0f, 0.0f, 0.0f);
                    ++i;
                }
                MatrixStack.popMatrix();
                break;
            }
            case 5: {
                MatrixStack.pushMatrix();
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(180.0f, 1.0f, 0.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BlockTable.mdl.stem.render(1.0f);
                BlockTable.mdl.xbase1.render(1.0f);
                BlockTable.mdl.xbase2.render(1.0f);
                BlockTable.mdl.zbase1.render(1.0f);
                BlockTable.mdl.zbase2.render(1.0f);
                BlockTable.mdl.xbase1a.render(1.0f);
                BlockTable.mdl.xbase2a.render(1.0f);
                BlockTable.mdl.zbase1a.render(1.0f);
                BlockTable.mdl.zbase2a.render(1.0f);
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        MatrixStack.sendCurrentStack();
                        BlockTable.mdl.top.render(1.0f);
                        MatrixStack.translate(0.0f, 0.0f, -4.0f);
                        ++j;
                    }
                    MatrixStack.translate(0.0f, 0.0f, 16.0f);
                    MatrixStack.translate(4.0f, 0.0f, 0.0f);
                    ++i;
                }
                MatrixStack.popMatrix();
            }
        }
    }
}

