/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.entities.Basilisk;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.BlockStone;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.world.World;

public class BlockRandomTeleport
extends BlockStone {
    public BlockRandomTeleport(String n, String txt, int hardness) {
        super(n, txt, hardness);
    }

    @Override
    public void doSteppedOn(Entity e, World w, int d, int x, int y, int z) {
        if (e != null) {
            if (e instanceof Player) {
                Player pl = (Player)e;
                double py = pl.posy;
                double px = pl.posx + (double)(DangerZone.rand.nextInt(32) - DangerZone.rand.nextInt(32));
                double pz = pl.posz + (double)(DangerZone.rand.nextInt(32) - DangerZone.rand.nextInt(32));
                Utils.doTeleport(pl, pl.dimension, px, py, pz);
            } else if (!(e instanceof Basilisk)) {
                this.teleportnearby(e, 32);
            }
        }
    }

    private void teleportnearby(Entity entity, int dist) {
        int tries = 10;
        while (tries > 0) {
            --tries;
            int py = (int)entity.posy;
            int px = (int)(entity.posx + (double)(entity.world.rand.nextInt(dist) - entity.world.rand.nextInt(dist)));
            int pz = (int)(entity.posz + (double)(entity.world.rand.nextInt(dist) - entity.world.rand.nextInt(dist)));
            int i = -4;
            while (i <= 5) {
                if (!this.isSolidAtLevel(entity.world, entity.dimension, px, py + i, pz, entity.getWidth()) && this.isSolidAtLevel(entity.world, entity.dimension, px, py + i - 1, pz, entity.getWidth())) {
                    int j;
                    boolean fits = true;
                    int ih = (int)entity.getHeight() + 1;
                    if (ih > 1) {
                        j = 1;
                        while (j < ih && fits) {
                            if (this.isSolidAtLevel(entity.world, entity.dimension, px, py + i + j, pz, entity.getWidth())) {
                                fits = false;
                            }
                            ++j;
                        }
                    }
                    if (fits) {
                        j = 0;
                        while (j < (int)entity.getHeight() + 1) {
                            Utils.spawnParticlesFromServer(entity.world, "DangerZone:ParticleSmoke", 12, entity.dimension, entity.posx, entity.posy + (double)j, entity.posz);
                            ++j;
                        }
                        entity.posx = 0.5f + (float)px;
                        entity.posz = 0.5f + (float)pz;
                        entity.posy = py + i;
                        entity.motionx = 0.0f;
                        entity.motiony = 0.0f;
                        entity.motionz = 0.0f;
                        tries = 0;
                        int which = entity.world.rand.nextInt(3);
                        if (which == 0) {
                            entity.world.playSound("DangerZone:teleport1", entity.dimension, entity.posx, entity.posy, entity.posz, 0.75f, 1.0f);
                        }
                        if (which == 1) {
                            entity.world.playSound("DangerZone:teleport2", entity.dimension, entity.posx, entity.posy, entity.posz, 0.75f, 1.0f);
                        }
                        if (which == 2) {
                            entity.world.playSound("DangerZone:teleport3", entity.dimension, entity.posx, entity.posy, entity.posz, 0.75f, 1.0f);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public boolean isSolidAtLevel(World world, int d, double x, double y, double z, float wdth) {
        int intwidth = (int)(wdth / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(world.getblock(d, (int)x + i, (int)y, (int)z + j), world, d, (int)x + i, (int)y, (int)z + j)) {
                    int itemp = (int)x + i;
                    double dx = x - ((double)itemp + 0.5);
                    if ((dx = Math.abs(dx)) < (double)(0.49f + wdth / 2.0f)) {
                        itemp = (int)z + j;
                        double dz = z - ((double)itemp + 0.5);
                        if ((dz = Math.abs(dz)) < (double)(0.49f + wdth / 2.0f)) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

