/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.entities.Ant;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.PowerOrb;
import OreSpawn.entities.RainbowAnt;
import OreSpawn.entities.RedAnt;
import OreSpawn.entities.RobotAnt;
import OreSpawn.entities.Termite;
import OreSpawn.entities.UnstableAnt;
import dangerzone.DangerZone;
import dangerzone.blocks.LightStick;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.threads.FastBlockTicker;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;

public class BlockKrakenRepellent
extends LightStick {
    public BlockKrakenRepellent(String n, String txt) {
        super(n, txt);
        this.brightness = 0.95f;
        this.maxdamage = 1;
        this.alwaystick = true;
        this.burntime = 45;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        FastBlockTicker.addFastTick(d, x, y, z, 2);
        super.tickMe(w, d, x, y, z);
    }

    @Override
    public void tickMeFast(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        FastBlockTicker.addFastTick(d, x, y, z, 2);
        boolean repel = false;
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(24.0f, d, x, y, z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                repel = false;
                if (e instanceof Kraken) {
                    repel = true;
                }
                if (e instanceof Cockroach) {
                    repel = true;
                }
                if (e instanceof Ant) {
                    repel = true;
                }
                if (e instanceof RobotAnt) {
                    repel = true;
                }
                if (e instanceof RedAnt) {
                    repel = true;
                }
                if (e instanceof Termite) {
                    repel = true;
                }
                if (e instanceof UnstableAnt) {
                    repel = true;
                }
                if (e instanceof RainbowAnt) {
                    repel = true;
                }
                if (e instanceof PowerOrb) {
                    repel = true;
                }
                if (!repel) continue;
                float dir = (float)Math.atan2(e.posz - (double)z, e.posx - (double)x);
                float hdist = (float)Math.sqrt((e.posx - (double)x) * (e.posx - (double)x) + (e.posz - (double)z) * (e.posz - (double)z));
                float ydir = (float)Math.atan2(e.posy - (double)y, hdist);
                float knockback = (float)(24.0 - e.getDistanceFromEntityCenter(x, y, z));
                if ((knockback /= 6.0f) < 0.0f) {
                    knockback = 0.0f;
                }
                if (knockback > 4.0f) {
                    knockback = 4.0f;
                }
                e.motionx = (float)((double)e.motionx + Math.cos(dir) * (double)knockback * Math.cos(ydir));
                e.motionz = (float)((double)e.motionz + Math.sin(dir) * (double)knockback * Math.cos(ydir));
                e.motiony = (float)((double)e.motiony + (double)(0.5f * knockback) * Math.sin(ydir));
            }
        }
    }
}

