/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.BetterTorch;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;

public class BlockExtremeTorch
extends BetterTorch {
    public BlockExtremeTorch(String n, String txt, String txt2) {
        super(n, txt, txt2);
        this.brightness = 0.95f;
        this.maxdamage = 1;
        this.burntime = 45;
        this.randomtick = false;
        this.alwaystick = true;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.rand.nextInt(5) == 0) {
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSmoke", w.rand.nextInt(5) + 5, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
        if (w.rand.nextInt(4) == 0) {
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", w.rand.nextInt(3) + 3, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        }
    }

    @Override
    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(dimension, x, y - 1, z);
            if (!BreakChecks.canChangeBlock(w, dimension, x, y, z, dimension, x, y, z, 0, 0)) {
                return;
            }
            if (bid == Blocks.blockbloodstone.blockID) {
                Entity e = w.createEntityByName("OreSpawn:Cephadrome", dimension, (double)x + (double)w.rand.nextInt(10) - (double)w.rand.nextInt(10), (double)y + 2.0, (double)z + (double)w.rand.nextInt(10) - (double)w.rand.nextInt(10));
                if (e != null) {
                    e.init();
                    w.spawnEntityInWorld(e);
                }
                w.setblock(dimension, x, y, z, 0);
                Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 20, dimension, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5);
                Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSmoke", 20, dimension, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5);
                Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", 10, dimension, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5);
                w.playSound("DangerZone:small_explosion4", dimension, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5, 0.25f, 1.0f + (w.rand.nextFloat() - w.rand.nextFloat()) * 0.3f);
            }
            if (dimension == OreSpawnMain.dragonslairdimension.dimensionID) {
                boolean ok = true;
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        bid = w.getblock(dimension, x + i, y - 1, z + j);
                        if (bid != OreSpawnMain.dragoneyestone.blockID) {
                            ok = false;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (ok) {
                    w.setblock(dimension, x, y, z, 0);
                    Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 40, dimension, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5);
                    Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSmoke", 30, dimension, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5);
                    Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", 20, dimension, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5);
                    w.playSound("DangerZone:small_explosion4", dimension, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5, 0.25f, 1.0f + (w.rand.nextFloat() - w.rand.nextFloat()) * 0.3f);
                    OreSpawnMain.MyDungeons.makeDargonsLair(w, dimension, x, y - 1, z);
                }
            }
        }
    }
}

