/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.OreSpawnDungeons;
import OreSpawn.OreSpawnMain;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.TheKing;
import OreSpawn.entities.TheQueen;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.StuffList;
import dangerzone.Utils;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityChest;
import dangerzone.items.Items;
import dangerzone.rendering.Fastmath;
import dangerzone.world.Chunk;
import dangerzone.world.World;
import java.util.Random;

public class OreSpawnTrees {
    Random rand = DangerZone.rand;

    public void ScragglyTreeWithBranches(World world, int d, int x, int y, int z) {
        int bid;
        int leafid = OreSpawnMain.blocknonscaryleaves.blockID;
        if (!world.isDaytime()) {
            leafid = OreSpawnMain.blockscaryleaves.blockID;
        }
        int i = 1 + Fastmath.nextInt(2);
        int j = i + Fastmath.nextInt(10);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.log.blockID && bid != OreSpawnMain.blocknonscaryleaves.blockID && bid != OreSpawnMain.blockscaryleaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, Blocks.log.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            int ix = Fastmath.nextInt(2) - Fastmath.nextInt(2);
            int iz = Fastmath.nextInt(2) - Fastmath.nextInt(2);
            int iy = Fastmath.nextInt(4) > 0 ? 1 : 0;
            bid = world.getblock(d, x += ix, y += iy, z += iz);
            if (bid != 0 && bid != Blocks.log.blockID && bid != OreSpawnMain.blocknonscaryleaves.blockID && bid != OreSpawnMain.blockscaryleaves.blockID) break;
            world.setblocknonotify(d, x, y, z, Blocks.log.blockID);
            if (Fastmath.nextInt(4) == 1) {
                this.makeScragglyBranch(world, d, x, y, z, Fastmath.nextInt(1 + j - k), Fastmath.nextInt(2) - Fastmath.nextInt(2), Fastmath.nextInt(2) - Fastmath.nextInt(2));
            }
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, leafid);
                    }
                    ++n;
                }
                ++m;
            }
            if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, leafid);
            }
            ++k;
        }
    }

    public void makeScragglyBranch(World world, int d, int x, int y, int z, int len, int biasx, int biasz) {
        int leafid = OreSpawnMain.blocknonscaryleaves.blockID;
        if (!world.isDaytime()) {
            leafid = OreSpawnMain.blockscaryleaves.blockID;
        }
        int k = 0;
        while (k < len) {
            int iy;
            int bid;
            int ix = Fastmath.nextInt(2) - Fastmath.nextInt(2) + biasx;
            int iz = Fastmath.nextInt(2) - Fastmath.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.getblock(d, x += ix, y += (iy = Fastmath.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != Blocks.log.blockID && bid != OreSpawnMain.blocknonscaryleaves.blockID && bid != OreSpawnMain.blockscaryleaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y, z, Blocks.log.blockID);
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, leafid);
                    }
                    ++n;
                }
                ++m;
            }
            if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, leafid);
            }
            ++k;
        }
    }

    public static void ScragglyCrystalTreeWithBranches(World world, int d, int x, int y, int z) {
        int bid;
        int leafid = OreSpawnMain.blockcrystalleavesgreen.blockID;
        int i = 1 + Fastmath.nextInt(2);
        int j = i + Fastmath.nextInt(10);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesgreen.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, OreSpawnMain.crystallog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            int ix = Fastmath.nextInt(2) - Fastmath.nextInt(2);
            int iz = Fastmath.nextInt(2) - Fastmath.nextInt(2);
            int iy = Fastmath.nextInt(4) > 0 ? 1 : 0;
            bid = world.getblock(d, x += ix, y += iy, z += iz);
            if (bid != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesgreen.blockID) break;
            world.setblocknonotify(d, x, y, z, OreSpawnMain.crystallog.blockID);
            if (Fastmath.nextInt(4) == 1) {
                OreSpawnTrees.makeScragglyCrystalBranch(world, d, x, y, z, Fastmath.nextInt(1 + j - k), Fastmath.nextInt(2) - Fastmath.nextInt(2), Fastmath.nextInt(2) - Fastmath.nextInt(2));
            }
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, leafid);
                    }
                    ++n;
                }
                ++m;
            }
            if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, leafid);
            }
            ++k;
        }
    }

    public static void makeScragglyCrystalBranch(World world, int d, int x, int y, int z, int len, int biasx, int biasz) {
        int leafid = OreSpawnMain.blockcrystalleavesgreen.blockID;
        int k = 0;
        while (k < len) {
            int iy;
            int bid;
            int ix = Fastmath.nextInt(2) - Fastmath.nextInt(2) + biasx;
            int iz = Fastmath.nextInt(2) - Fastmath.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.getblock(d, x += ix, y += (iy = Fastmath.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesgreen.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y, z, OreSpawnMain.crystallog.blockID);
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, leafid);
                    }
                    ++n;
                }
                ++m;
            }
            if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, leafid);
            }
            ++k;
        }
    }

    public static void TallCrystalBlueTree(World world, int d, int x, int y, int z) {
        int n;
        int m;
        int bid;
        int i = 5 + Fastmath.nextInt(6);
        int j = 2 + i + Fastmath.nextInt(12);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesblue.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, OreSpawnMain.crystallog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            if ((bid = world.getblock(d, x, ++y, z)) != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesblue.blockID) break;
            world.setblocknonotify(d, x, y, z, OreSpawnMain.crystallog.blockID);
            if (k % 4 == 0) {
                m = -1;
                while (m < 2) {
                    n = -1;
                    while (n < 2) {
                        if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                            world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.blockcrystalleavesblue.blockID);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++k;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.crystallog.blockID);
                }
                ++n;
            }
            ++m;
        }
        m = -3;
        while (m < 4) {
            n = -3;
            while (n < 4) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.blockcrystalleavesblue.blockID);
                }
                ++n;
            }
            ++m;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.blockcrystalleavesblue.blockID);
                }
                ++n;
            }
            ++m;
        }
    }

    public static void TallCrystalRedTree(World world, int d, int x, int y, int z) {
        int n;
        int m;
        int bid;
        int i = 10 + Fastmath.nextInt(12);
        int j = i + Fastmath.nextInt(18);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesred.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, OreSpawnMain.crystallog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            if ((bid = world.getblock(d, x, ++y, z)) != 0 && bid != OreSpawnMain.crystallog.blockID && bid != OreSpawnMain.blockcrystalleavesred.blockID) break;
            world.setblocknonotify(d, x, y, z, OreSpawnMain.crystallog.blockID);
            if (k % 4 == 0) {
                m = -1;
                while (m < 2) {
                    n = -1;
                    while (n < 2) {
                        if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                            world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.blockcrystalleavesred.blockID);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++k;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                if (Fastmath.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.crystallog.blockID);
                }
                ++n;
            }
            ++m;
        }
        m = -3;
        while (m < 4) {
            n = -3;
            while (n < 4) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.blockcrystalleavesred.blockID);
                }
                ++n;
            }
            ++m;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, OreSpawnMain.blockcrystalleavesred.blockID);
                }
                ++n;
            }
            ++m;
        }
    }

    public void addCrystalTrees(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        if (Fastmath.nextInt(8) != 0) {
            return;
        }
        int howmany = 0;
        int what = Fastmath.nextInt(6);
        howmany = Fastmath.nextInt(5);
        if (howmany == 0) {
            return;
        }
        if (what < 2) {
            howmany *= 2;
        }
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + Fastmath.nextInt(16);
            int posZ = chunkZ + Fastmath.nextInt(16);
            int posY = 128;
            while (posY > 60) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                    if (what == 0 || what == 1 || what == 2) {
                        OreSpawnTrees.ScragglyCrystalTreeWithBranches(world, d, posX, posY, posZ);
                        break;
                    }
                    if (what == 3 || what == 4) {
                        OreSpawnTrees.TallCrystalBlueTree(world, d, posX, posY, posZ);
                        break;
                    }
                    OreSpawnTrees.TallCrystalRedTree(world, d, posX, posY, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    private Boolean isBoringBlock(World world, int d, int x, int y, int z) {
        int var1 = world.getblock(d, x, y, z);
        if (var1 == 0) {
            return true;
        }
        if (var1 == Blocks.grass.blockID) {
            return true;
        }
        if (var1 == Blocks.flower_red.blockID) {
            return true;
        }
        if (var1 == Blocks.flower_yellow.blockID) {
            return true;
        }
        if (var1 == Blocks.flower_blue.blockID) {
            return true;
        }
        if (var1 == Blocks.flower_purple.blockID) {
            return true;
        }
        if (var1 == Blocks.leaves.blockID) {
            return true;
        }
        if (var1 == Blocks.redwoodleaves.blockID) {
            return true;
        }
        if (var1 == Blocks.willowleaves.blockID) {
            return true;
        }
        if (var1 == Blocks.appleleaves.blockID) {
            return true;
        }
        return false;
    }

    private Boolean isBoringBaseBlock(World world, int d, int x, int y, int z) {
        int var1 = world.getblock(d, x, y, z);
        if (var1 == Blocks.stone.blockID) {
            return false;
        }
        if (var1 == Blocks.greystone.blockID) {
            return false;
        }
        if (var1 == Blocks.stopblock.blockID) {
            return false;
        }
        return true;
    }

    private void make_branch(World world, int d, int x, int y, int z, int this_width, int dirx, int dirz, int ID, int leafID, int t_radius, boolean bad_critters) {
        int current_width = this_width;
        int last_branch = 0;
        int branch_side = 1;
        int leaf_depth = 0;
        int leaf_width = 0;
        int xaccum = dirx;
        int zaccum = dirz;
        if (this.rand.nextInt(2) == 0) {
            branch_side = -1;
        }
        while (current_width >= 0) {
            int length = this_width * 3 + this.rand.nextInt(this_width + 3);
            int i = 0;
            while (i < length) {
                int realz;
                int realx;
                int j = -current_width;
                while (j <= current_width) {
                    realx = x + j * dirz + xaccum;
                    realz = z + j * dirx + zaccum;
                    if (this.isBoringBlock(world, d, realx, y, realz).booleanValue()) {
                        OreSpawnTrees.FastSetBlock(world, d, realx, y, realz, ID, 0);
                    }
                    if (i > 0 && j == 0 && current_width >= 3 && this.rand.nextInt(75) == 0 && world.getblock(d, realx, y + 1, realz) == 0) {
                        this.add_chest(world, d, realx, y + 1, realz);
                    }
                    ++j;
                }
                if (current_width < 3 || this_width <= 1) {
                    leaf_depth = 2 + this.rand.nextInt(2);
                    leaf_width = 2 + this.rand.nextInt(3);
                    int n = 0;
                    while (n < leaf_depth) {
                        int lw = current_width + leaf_width - n;
                        if (current_width == 0 && length - i <= 2 && lw >= length - i) {
                            lw = length - i - 1;
                        }
                        if (lw < 0) {
                            lw = 0;
                        }
                        j = -lw;
                        while (j <= lw) {
                            realx = x + j * Math.abs(dirz) + xaccum + dirx;
                            if (this.isBoringBlock(world, d, realx, y + n, realz = z + j * Math.abs(dirx) + zaccum + dirz).booleanValue()) {
                                if (leafID == Blocks.blockplatinum.blockID || leafID == Blocks.blockemerald.blockID) {
                                    int local_leaf_type = leafID;
                                    if (this.rand.nextInt(20) == 1) {
                                        local_leaf_type = this.rand.nextInt(10);
                                        if (local_leaf_type == 0) {
                                            local_leaf_type = OreSpawnMain.blockuranium.blockID;
                                        }
                                        if (local_leaf_type == 1) {
                                            local_leaf_type = OreSpawnMain.blocktitanium.blockID;
                                        }
                                        if (local_leaf_type == 2) {
                                            local_leaf_type = OreSpawnMain.blockruby.blockID;
                                        }
                                        if (local_leaf_type == 3) {
                                            local_leaf_type = OreSpawnMain.blockamethyst.blockID;
                                        }
                                        if (local_leaf_type == 4) {
                                            local_leaf_type = Blocks.blockdiamond.blockID;
                                        }
                                        if (local_leaf_type == 5) {
                                            local_leaf_type = Blocks.blockemerald.blockID;
                                        }
                                        if (local_leaf_type == 6) {
                                            local_leaf_type = Blocks.blocksunstone.blockID;
                                        }
                                        if (local_leaf_type == 7) {
                                            local_leaf_type = Blocks.blockbloodstone.blockID;
                                        }
                                        if (local_leaf_type == 8) {
                                            local_leaf_type = Blocks.blocksilver.blockID;
                                        }
                                        if (local_leaf_type == 9) {
                                            local_leaf_type = Blocks.blockplatinum.blockID;
                                        }
                                    }
                                    OreSpawnTrees.FastSetBlock(world, d, realx, y + n, realz, local_leaf_type, 0);
                                } else {
                                    OreSpawnTrees.FastSetBlock(world, d, realx, y + n, realz, leafID, 0);
                                }
                            }
                            ++j;
                        }
                        ++n;
                    }
                }
                if (current_width > 0 && last_branch > current_width && current_width != this_width && this.rand.nextInt(current_width + 1) == 0) {
                    int subdirx = branch_side;
                    int subdirz = 0;
                    if (dirx != 0) {
                        subdirx = 0;
                        subdirz = branch_side;
                    }
                    this.make_branch(world, d, x + xaccum + current_width * subdirx, y, z + zaccum + current_width * subdirz, current_width - 1, subdirx, subdirz, ID, leafID, t_radius, bad_critters);
                    last_branch = 0;
                    branch_side = branch_side < 0 ? 1 : -1;
                }
                xaccum += dirx;
                zaccum += dirz;
                ++last_branch;
                ++i;
            }
            --current_width;
        }
    }

    public void MakeBigSquareTree(World world, int d, int x, int y, int z, int ID, int leafID, int stepID, int t_radius, boolean bad_critters) {
        int j;
        int this_height = t_radius + this.rand.nextInt(t_radius);
        int this_width = t_radius;
        int base_height = t_radius * 3;
        int spiral = 0;
        int current_y = 0;
        boolean do_floor = false;
        int platform_looper = 1;
        int last = -1;
        int last_last = -1;
        int i = -t_radius;
        while (i <= t_radius) {
            if (this.isBoringBaseBlock(world, d, x + i, y, z - t_radius).booleanValue()) {
                j = 0;
                while (j < 20) {
                    if (y - j > 0) {
                        if (!this.isBoringBaseBlock(world, d, x + i, y - j, z - t_radius).booleanValue()) break;
                        OreSpawnTrees.FastSetBlock(world, d, x + i, y - j, z - t_radius, ID, 0);
                    }
                    ++j;
                }
            }
            if (this.isBoringBaseBlock(world, d, x + i, y, z + t_radius).booleanValue()) {
                j = 0;
                while (j < 20) {
                    if (y - j > 0) {
                        if (!this.isBoringBaseBlock(world, d, x + i, y - j, z + t_radius).booleanValue()) break;
                        OreSpawnTrees.FastSetBlock(world, d, x + i, y - j, z + t_radius, ID, 0);
                    }
                    ++j;
                }
            }
            if (this.isBoringBaseBlock(world, d, x - t_radius, y, z + i).booleanValue()) {
                j = 0;
                while (j < 20) {
                    if (y - j > 0) {
                        if (!this.isBoringBaseBlock(world, d, x - t_radius, y - j, z + i).booleanValue()) break;
                        OreSpawnTrees.FastSetBlock(world, d, x - t_radius, y - j, z + i, ID, 0);
                    }
                    ++j;
                }
            }
            if (this.isBoringBaseBlock(world, d, x + t_radius, y, z + i).booleanValue()) {
                j = 0;
                while (j < 20) {
                    if (y - j > 0) {
                        if (!this.isBoringBaseBlock(world, d, x + t_radius, y - j, z + i).booleanValue()) break;
                        OreSpawnTrees.FastSetBlock(world, d, x + t_radius, y - j, z + i, ID, 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
        current_y = y;
        do_floor = false;
        spiral = -this_width;
        while (this_width >= 0) {
            if (this_width != t_radius) {
                base_height = 0;
            }
            j = 0;
            while (j < this_height + base_height) {
                do_floor = false;
                i = -this_width;
                while (i <= this_width) {
                    if (this.isBoringBaseBlock(world, d, x + i, current_y, z - this_width).booleanValue()) {
                        OreSpawnTrees.FastSetBlock(world, d, x + i, current_y, z - this_width, ID, 0);
                    }
                    if (this.isBoringBaseBlock(world, d, x + i, current_y, z + this_width).booleanValue()) {
                        OreSpawnTrees.FastSetBlock(world, d, x + i, current_y, z + this_width, ID, 0);
                    }
                    if (this.isBoringBaseBlock(world, d, x - this_width, current_y, z + i).booleanValue()) {
                        OreSpawnTrees.FastSetBlock(world, d, x - this_width, current_y, z + i, ID, 0);
                    }
                    if (this.isBoringBaseBlock(world, d, x + this_width, current_y, z + i).booleanValue()) {
                        OreSpawnTrees.FastSetBlock(world, d, x + this_width, current_y, z + i, ID, 0);
                    }
                    ++i;
                }
                if (this_width != 0 || j < this_height / 2) {
                    platform_looper = 1;
                    if (spiral == 0 && this_width >= 2 || spiral == this_width || spiral == this_width - 1 && j == this_height + base_height - 1) {
                        ++platform_looper;
                        if (spiral != 0 && this_width >= 3) {
                            ++platform_looper;
                        }
                        if (spiral == 0) {
                            do_floor = true;
                        }
                    }
                    int k = 0;
                    while (k < platform_looper) {
                        if (this.isBoringBlock(world, d, x - spiral, current_y, z - this_width - 1).booleanValue()) {
                            OreSpawnTrees.FastSetBlock(world, d, x - spiral, current_y, z - this_width - 1, stepID, 0);
                        }
                        if (this.isBoringBlock(world, d, x + spiral, current_y, z + this_width + 1).booleanValue()) {
                            OreSpawnTrees.FastSetBlock(world, d, x + spiral, current_y, z + this_width + 1, stepID, 0);
                        }
                        if (this.isBoringBlock(world, d, x - this_width - 1, current_y, z + spiral).booleanValue()) {
                            OreSpawnTrees.FastSetBlock(world, d, x - this_width - 1, current_y, z + spiral, stepID, 0);
                        }
                        if (this.isBoringBlock(world, d, x + this_width + 1, current_y, z - spiral).booleanValue()) {
                            OreSpawnTrees.FastSetBlock(world, d, x + this_width + 1, current_y, z - spiral, stepID, 0);
                        }
                        if (this_width >= 3) {
                            if (this.isBoringBlock(world, d, x - spiral, current_y, z - this_width - 2).booleanValue()) {
                                OreSpawnTrees.FastSetBlock(world, d, x - spiral, current_y, z - this_width - 2, stepID, 0);
                            }
                            if (this.isBoringBlock(world, d, x + spiral, current_y, z + this_width + 2).booleanValue()) {
                                OreSpawnTrees.FastSetBlock(world, d, x + spiral, current_y, z + this_width + 2, stepID, 0);
                            }
                            if (this.isBoringBlock(world, d, x - this_width - 2, current_y, z + spiral).booleanValue()) {
                                OreSpawnTrees.FastSetBlock(world, d, x - this_width - 2, current_y, z + spiral, stepID, 0);
                            }
                            if (this.isBoringBlock(world, d, x + this_width + 2, current_y, z - spiral).booleanValue()) {
                                OreSpawnTrees.FastSetBlock(world, d, x + this_width + 2, current_y, z - spiral, stepID, 0);
                            }
                        }
                        if (platform_looper != 1) {
                            ++spiral;
                        }
                        ++k;
                    }
                    if (do_floor) {
                        int m = -this_width;
                        while (m <= this_width) {
                            int n = -this_width;
                            while (n <= this_width) {
                                if (this.isBoringBlock(world, d, x + m, current_y, z + n).booleanValue()) {
                                    OreSpawnTrees.FastSetBlock(world, d, x + m, current_y, z + n, ID, 0);
                                    if (m == 0 && n == 0 && this.rand.nextInt(2) == 0 && world.getblock(d, x, current_y + 1, z) == 0) {
                                        this.add_chest(world, d, x, current_y + 1, z);
                                    }
                                }
                                ++n;
                            }
                            ++m;
                        }
                    }
                }
                if (this_width != t_radius) {
                    int next = this.rand.nextInt(4 + this_width);
                    while (next == last || next == last_last) {
                        next = this.rand.nextInt(4 + this_width);
                    }
                    if (next < 4) {
                        last_last = last;
                        last = next;
                    }
                    switch (next) {
                        case 0: {
                            this.make_branch(world, d, x + this_width, current_y, z, this_width, 1, 0, ID, leafID, t_radius, bad_critters);
                            break;
                        }
                        case 1: {
                            this.make_branch(world, d, x - this_width, current_y, z, this_width, -1, 0, ID, leafID, t_radius, bad_critters);
                            break;
                        }
                        case 2: {
                            this.make_branch(world, d, x, current_y, z + this_width, this_width, 0, 1, ID, leafID, t_radius, bad_critters);
                            break;
                        }
                        case 3: {
                            this.make_branch(world, d, x, current_y, z - this_width, this_width, 0, -1, ID, leafID, t_radius, bad_critters);
                            break;
                        }
                    }
                }
                ++current_y;
                if (!do_floor) {
                    ++spiral;
                }
                if (spiral > this_width) {
                    spiral = -this_width;
                }
                ++j;
            }
            if (Math.abs(spiral) > --this_width) {
                spiral = -this_width;
            }
            this_height += this.rand.nextInt(t_radius);
        }
        if (this.isBoringBaseBlock(world, d, x, current_y, z).booleanValue()) {
            EntityLivingDragon e;
            OreSpawnTrees.FastSetBlock(world, d, x, current_y, z, Blocks.blocksilver.blockID, 0);
            if (stepID == Blocks.blocklight.blockID) {
                OreSpawnTrees.FastSetBlock(world, d, x, current_y + 1, z, Blocks.blockplatinum.blockID, 0);
                e = (TheKing)world.createEntityByName("OreSpawn:TheKing", d, x, current_y + 2, z);
                if (e != null) {
                    e.init();
                    ((TheKing)e).setGuardMode();
                    world.spawnEntityInWorld(e);
                }
            }
            if (stepID == Blocks.blockdiamond.blockID) {
                OreSpawnTrees.FastSetBlock(world, d, x, current_y + 1, z, Blocks.blockplatinum.blockID, 0);
                e = (TheQueen)world.createEntityByName("OreSpawn:TheQueen", d, x, current_y + 2, z);
                if (e != null) {
                    e.init();
                    ((TheQueen)e).setGuardMode();
                    world.spawnEntityInWorld(e);
                }
            }
        }
    }

    private void MakeCirclularBranch(World world, int d, int iangle, int branchlen, int width, int startx, int starty, int startz, int twist, int ID, int leafID) {
        double curlen = 0.0;
        int curangle = iangle;
        double curx = startx;
        double curz = startz;
        curlen = 0.0;
        while (curlen < (double)branchlen) {
            curx += 0.5 * Fastmath.sin(Math.toRadians(curangle));
            curz += 0.5 * Fastmath.cos(Math.toRadians(curangle));
            double tw = (double)width - (double)width * curlen / (double)branchlen;
            double wd = 0.0;
            while (wd <= tw) {
                double wz;
                double wx;
                int ta;
                int id = leafID;
                if (wd < tw / 2.0) {
                    id = ID;
                }
                if (tw < 0.9) {
                    id = leafID;
                }
                if ((ta = curangle + 90) > 360) {
                    ta -= 360;
                }
                if (this.isBoringBlock(world, d, (int)(wx = curx + wd * Fastmath.sin(Math.toRadians(ta))), starty, (int)(wz = curz + wd * Fastmath.cos(Math.toRadians(ta)))).booleanValue()) {
                    OreSpawnTrees.FastSetBlock(world, d, (int)wx, starty, (int)wz, id, 0);
                }
                if (id == ID && this.isBoringBlock(world, d, (int)wx, starty + 1, (int)wz).booleanValue()) {
                    OreSpawnTrees.FastSetBlock(world, d, (int)wx, starty + 1, (int)wz, leafID, 0);
                }
                if ((ta = curangle - 90) < 0) {
                    ta += 360;
                }
                if (this.isBoringBlock(world, d, (int)(wx = curx + wd * Fastmath.sin(Math.toRadians(ta))), starty, (int)(wz = curz + wd * Fastmath.cos(Math.toRadians(ta)))).booleanValue()) {
                    OreSpawnTrees.FastSetBlock(world, d, (int)wx, starty, (int)wz, id, 0);
                }
                if (id == ID && this.isBoringBlock(world, d, (int)wx, starty + 1, (int)wz).booleanValue()) {
                    OreSpawnTrees.FastSetBlock(world, d, (int)wx, starty + 1, (int)wz, leafID, 0);
                }
                wd += 0.5;
            }
            if ((curangle += twist) < 0) {
                curangle += 360;
            }
            if (curangle >= 360) {
                curangle -= 360;
            }
            curlen += 0.5;
        }
    }

    public void MakeBigCircularTree(World world, int d, int x, int y, int z, int ID, int leafID, int stepID, int t_radius, boolean bad_critters) {
        double dt;
        double rad = t_radius;
        int curx = 0;
        int cury = 0;
        int curz = 0;
        int stepindex = this.rand.nextInt(360);
        int ibranch = 0;
        cury = y;
        int i = 0;
        while (i < 360) {
            dt = rad * Fastmath.sin(Math.toRadians(i)) + 0.5;
            curx = (int)dt;
            curz = (int)(dt = rad * Fastmath.cos(Math.toRadians(i)) + 0.5);
            if (this.isBoringBaseBlock(world, d, x + curx, cury, z + curz).booleanValue()) {
                int j = 0;
                while (j < 20) {
                    if (cury - j > 0) {
                        if (!this.isBoringBaseBlock(world, d, x + curx, cury - j, z + curz).booleanValue()) break;
                        OreSpawnTrees.FastSetBlock(world, d, x + curx, cury - j, z + curz, ID, 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
        cury = 1;
        while (rad > 0.0) {
            i = 0;
            while (i < 360) {
                dt = rad * Fastmath.sin(Math.toRadians(i)) + 0.5;
                curx = (int)dt;
                curz = (int)(dt = rad * Fastmath.cos(Math.toRadians(i)) + 0.5);
                if (this.isBoringBaseBlock(world, d, x + curx, y + cury, z + curz).booleanValue()) {
                    OreSpawnTrees.FastSetBlock(world, d, x + curx, y + cury, z + curz, ID, 0);
                }
                if (i >= stepindex - 1 && i <= stepindex + 1 && rad > 1.0) {
                    dt = (rad + 1.9) * Fastmath.sin(Math.toRadians(i)) + 0.5;
                    curx = (int)dt;
                    dt = (rad + 1.9) * Fastmath.cos(Math.toRadians(i)) + 0.5;
                    curz = (int)dt;
                    int m = -1;
                    while (m <= 1) {
                        int n = -1;
                        while (n <= 1) {
                            if (this.isBoringBaseBlock(world, d, x + curx + m, y + cury, z + curz + n).booleanValue()) {
                                OreSpawnTrees.FastSetBlock(world, d, x + curx + m, y + cury, z + curz + n, stepID, 0);
                            }
                            ++n;
                        }
                        ++m;
                    }
                }
                ++i;
            }
            if (cury > (int)rad) {
                if ((ibranch += 80 + this.rand.nextInt(80)) > 360) {
                    ibranch -= 360;
                }
                int ibranchlen = (int)(rad * 5.0) + this.rand.nextInt((int)rad + 2);
                dt = rad * Fastmath.sin(Math.toRadians(ibranch)) + 0.5;
                curx = (int)dt;
                dt = rad * Fastmath.cos(Math.toRadians(ibranch)) + 0.5;
                curz = (int)dt;
                this.MakeCirclularBranch(world, d, ibranch, ibranchlen, (int)rad + 1, x + curx, y + cury, z + curz, this.rand.nextInt(2) * (this.rand.nextInt(2) == 0 ? -1 : 1), ID, leafID);
            }
            if (cury % 6 == 0 && rad > 3.0) {
                double dr = rad - 0.25;
                while (dr > 0.0) {
                    i = 0;
                    while (i < 360) {
                        dt = dr * Fastmath.sin(Math.toRadians(i)) + 0.5;
                        curx = (int)dt;
                        curz = (int)(dt = dr * Fastmath.cos(Math.toRadians(i)) + 0.5);
                        if (this.isBoringBaseBlock(world, d, x + curx, y + cury, z + curz).booleanValue()) {
                            OreSpawnTrees.FastSetBlock(world, d, x + curx, y + cury, z + curz, ID, 0);
                        }
                        ++i;
                    }
                    dr -= 0.25;
                }
            }
            if ((stepindex += 15 + (int)(((double)t_radius - rad) * 3.0)) > 360) {
                stepindex -= 360;
            }
            if (!((rad -= 0.01 * (double)this.rand.nextInt(15)) <= 0.0) || !this.isBoringBaseBlock(world, d, x, y + ++cury, z).booleanValue()) continue;
            OreSpawnTrees.FastSetBlock(world, d, x, y + cury, z, Blocks.blockplatinum.blockID, 0);
        }
    }

    public void MakeBigRoundTree(World world, int dimension, int inx, int y, int inz, int ID, int leafID, int t_radius) {
        double fcurz;
        double fcurx;
        double dt;
        double rad = t_radius;
        int cury = 0;
        int ibranch = 0;
        double fx = inx;
        fx += 0.5;
        double fz = inz;
        fz += 0.5;
        cury = y;
        int i = 0;
        while (i < 360) {
            fcurx = dt = rad * Fastmath.sin(Math.toRadians(i));
            dt = rad * Fastmath.cos(Math.toRadians(i));
            fcurz = dt;
            if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), cury, (int)(fz + fcurz)).booleanValue()) {
                int j = 0;
                while (j < 20) {
                    if (cury - j > 0) {
                        if (!this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), cury - j, (int)(fz + fcurz)).booleanValue()) break;
                        world.setblocknonotify(dimension, (int)(fx + fcurx), cury - j, (int)(fz + fcurz), ID);
                    }
                    ++j;
                }
            }
            ++i;
        }
        cury = 1;
        while (rad > 0.0) {
            i = 0;
            while (i < 360) {
                fcurx = dt = rad * Fastmath.sin(Math.toRadians(i));
                dt = rad * Fastmath.cos(Math.toRadians(i));
                fcurz = dt;
                if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz)).booleanValue()) {
                    world.setblocknonotify(dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), ID);
                }
                ++i;
            }
            if (cury > (int)rad) {
                if ((ibranch += 80 + Fastmath.nextInt(80)) > 360) {
                    ibranch -= 360;
                }
                int ibranchlen = (int)(rad * 5.0) + Fastmath.nextInt((int)rad + 2);
                fcurx = dt = rad * Fastmath.sin(Math.toRadians(ibranch));
                fcurz = dt = rad * Fastmath.cos(Math.toRadians(ibranch));
                this.MakeRoundBranch(world, dimension, ibranch, ibranchlen, (int)rad + 1, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), Blocks.redwoodlog.blockID, leafID);
            }
            if (cury % 6 == 0 && rad > 3.0) {
                double dr = rad - 0.25;
                while (dr > 0.0) {
                    i = 0;
                    while (i < 360) {
                        fcurx = dt = dr * Fastmath.sin(Math.toRadians(i));
                        dt = dr * Fastmath.cos(Math.toRadians(i));
                        fcurz = dt;
                        if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz)).booleanValue()) {
                            world.setblocknonotify(dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), ID);
                        }
                        ++i;
                    }
                    dr -= 0.25;
                }
            }
            ++cury;
            rad -= 0.01 * (double)Fastmath.nextInt(15);
        }
    }

    private void MakeRoundBranch(World world, int dimension, int iangle, int branchlen, int width, float startx, int starty, float startz, int ID, int leafID) {
        double deltadir = 0.06283185200000001;
        double deltamag = 0.35f;
        int ixlast = 0;
        int izlast = 0;
        int radius = branchlen / 2;
        double centerx = (double)startx + (double)radius * Fastmath.sin(Math.toRadians(iangle));
        double centerz = (double)startz + (double)radius * Fastmath.cos(Math.toRadians(iangle));
        izlast = 0;
        ixlast = 0;
        double curdir = -3.1415926;
        while (curdir < 3.1415926) {
            double h = 0.75;
            while (h < (double)radius) {
                int ix = (int)(centerx + Fastmath.cos(curdir) * h);
                int iz = (int)(centerz + Fastmath.sin(curdir) * h);
                if (ix != ixlast || iz != izlast) {
                    ixlast = ix;
                    izlast = iz;
                    int id = ID;
                    if ((double)radius - h < 2.0) {
                        id = leafID;
                    }
                    if (this.isBoringBlock(world, dimension, ix, starty, iz).booleanValue()) {
                        world.setblocknonotify(dimension, ix, starty, iz, id);
                    }
                }
                h += deltamag;
            }
            curdir += deltadir;
        }
    }

    public static void FastSetBlock(World world, int d, int ix, int iy, int iz, int id, int im) {
        world.setblockandmetanonotify(d, ix, iy, iz, id, im);
    }

    public void add_chest(World world, int dimension, int x, int y, int z) {
        if (!world.isServer) {
            return;
        }
        world.setblock(dimension, x, y, z, Blocks.chest.blockID);
        Entity eb = world.createEntityByName("DangerZone:EntityChest", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5);
        if (eb != null) {
            EntityChest ec = (EntityChest)eb;
            int nthings = Fastmath.nextInt(25) + 20;
            StuffList[] things = OreSpawnDungeons.AllTheStuff;
            int i = 0;
            while (i < nthings) {
                int where = Fastmath.nextInt(50);
                int val = Fastmath.nextInt(100);
                int which = Fastmath.nextInt(things.length);
                if (val <= things[which].chance) {
                    int iid;
                    int bid;
                    int howmany = things[which].min;
                    if (things[which].max - things[which].min > 0) {
                        howmany += Fastmath.nextInt(things[which].max - things[which].min + 1);
                    }
                    if ((bid = things[which].getbid()) != 0 && howmany > Blocks.getMaxStack(bid)) {
                        howmany = Blocks.getMaxStack(bid);
                    }
                    if ((iid = things[which].getiid()) != 0 && howmany > Items.getMaxStack(iid)) {
                        howmany = Items.getMaxStack(iid);
                    }
                    ec.setInventory(where, new InventoryContainer(bid, iid, howmany, 0));
                }
                ++i;
            }
            ec.init();
            world.spawnEntityInWorld(eb);
        }
    }

    private void WindTreeBranch(World world, int d, int x, int y, int z, int length, int dirx, int dirz) {
        int i = 1;
        while (i <= length) {
            OreSpawnTrees.FastSetBlock(world, d, x + i * dirx, y, z + i * dirz, Blocks.log.blockID, 0);
            if (world.getblock(d, x + i * dirx, y + 1, z + i * dirz) == 0) {
                OreSpawnTrees.FastSetBlock(world, d, x + i * dirx, y + 1, z + i * dirz, Blocks.leaves.blockID, 0);
            }
            if (i < length / 3 && world.getblock(d, x + i * dirx, y + 2, z + i * dirz) == 0) {
                OreSpawnTrees.FastSetBlock(world, d, x + i * dirx, y + 2, z + i * dirz, Blocks.leaves.blockID, 0);
            }
            if (i > length / 3) {
                if (world.getblock(d, x + i * dirx + dirz, y, z + i * dirz + dirx) == 0) {
                    OreSpawnTrees.FastSetBlock(world, d, x + i * dirx + dirz, y, z + i * dirz + dirx, Blocks.leaves.blockID, 0);
                }
                if (world.getblock(d, x + i * dirx - dirz, y, z + i * dirz - dirx) == 0) {
                    OreSpawnTrees.FastSetBlock(world, d, x + i * dirx - dirz, y, z + i * dirz - dirx, Blocks.leaves.blockID, 0);
                }
            }
            ++i;
        }
        if (world.getblock(d, x + (length + 1) * dirx, y, z + (length + 1) * dirz) == 0) {
            OreSpawnTrees.FastSetBlock(world, d, x + (length + 1) * dirx, y, z + (length + 1) * dirz, Blocks.leaves.blockID, 0);
        }
        if (world.getblock(d, x + (length + 2) * dirx, y, z + (length + 2) * dirz) == 0) {
            OreSpawnTrees.FastSetBlock(world, d, x + (length + 2) * dirx, y, z + (length + 2) * dirz, Blocks.leaves.blockID, 0);
        }
    }

    public void WindTree(World world, int d, int x, int y, int z, int dir) {
        int bid;
        if (dir < 0 || dir > 3) {
            return;
        }
        int dirx = 1;
        int dirz = 0;
        if (dir == 1) {
            dirx = -1;
            dirz = 0;
        }
        if (dir == 2) {
            dirx = 0;
            dirz = 1;
        }
        if (dir == 3) {
            dirx = 0;
            dirz = -1;
        }
        if ((bid = world.getblock(d, x, y, z)) != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int height = Fastmath.nextInt(8) + 40;
        int j = 0;
        while (j < height) {
            OreSpawnTrees.FastSetBlock(world, d, x, j + y, z, Blocks.log.blockID, 0);
            if (j > height / 5) {
                OreSpawnTrees.FastSetBlock(world, d, x + dirx, j + y, z + dirz, Blocks.leaves.blockID, 0);
                if (j > height / 4 && j % 4 == 0) {
                    this.WindTreeBranch(world, d, x, j + y, z, height - j, dirx, dirz);
                }
            }
            ++j;
        }
        OreSpawnTrees.FastSetBlock(world, d, x, y + height, z, Blocks.leaves.blockID, 0);
    }

    private void SkyTreeBranch(World world, int d, int x, int y, int z, int length, int dirx, int dirz) {
        int i = 1;
        while (i < length) {
            OreSpawnTrees.FastSetBlock(world, d, x + i * dirx, y, z + i * dirz, OreSpawnMain.MySkyTreeLog.blockID, 0);
            if (world.getblock(d, x + i * dirx, y + 1, z + i * dirz) == 0) {
                OreSpawnTrees.FastSetBlock(world, d, x + i * dirx, y + 1, z + i * dirz, Blocks.leaves.blockID, 0);
            }
            if (world.getblock(d, x + i * dirx + dirz, y, z + i * dirz + dirx) == 0) {
                OreSpawnTrees.FastSetBlock(world, d, x + i * dirx + dirz, y, z + i * dirz + dirx, Blocks.leaves.blockID, 0);
            }
            if (world.getblock(d, x + i * dirx - dirz, y, z + i * dirz - dirx) == 0) {
                OreSpawnTrees.FastSetBlock(world, d, x + i * dirx - dirz, y, z + i * dirz - dirx, Blocks.leaves.blockID, 0);
            }
            ++i;
        }
        if (world.getblock(d, x + length * dirx, y, z + length * dirz) == 0) {
            OreSpawnTrees.FastSetBlock(world, d, x + length * dirx, y, z + length * dirz, Blocks.leaves.blockID, 0);
        }
    }

    public void SkyTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int height = Fastmath.nextInt(15) + 210;
        if (height - y < 20) {
            return;
        }
        int width = Fastmath.nextInt(10) + 25;
        int j = y;
        while (j <= height) {
            OreSpawnTrees.FastSetBlock(world, d, x, j, z, OreSpawnMain.MySkyTreeLog.blockID, 0);
            ++j;
        }
        OreSpawnTrees.FastSetBlock(world, d, x, height + 1, z, Blocks.leaves.blockID, 0);
        this.SkyTreeBranch(world, d, x, height, z, width, 1, 0);
        this.SkyTreeBranch(world, d, x, height, z, width, -1, 0);
        this.SkyTreeBranch(world, d, x, height, z, width, 0, 1);
        this.SkyTreeBranch(world, d, x, height, z, width, 0, -1);
        height -= 5;
        this.SkyTreeBranch(world, d, x, height -= Fastmath.nextInt(4), z, width /= 3, 1, 0);
        this.SkyTreeBranch(world, d, x, height, z, width, -1, 0);
        this.SkyTreeBranch(world, d, x, height, z, width, 0, 1);
        this.SkyTreeBranch(world, d, x, height, z, width, 0, -1);
    }

    public static void SmallTree(World world, int d, int x, int y, int z) {
        int bid;
        int realy = y;
        int leafid = OreSpawnMain.blocknonscaryleaves.blockID;
        if (!world.isDaytime()) {
            leafid = OreSpawnMain.blockscaryleaves.blockID;
        }
        if ((bid = world.getblock(d, x, y - 1, z)) != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        realy = y - 1;
        bid = world.getblock(d, x, realy + 1, z);
        if (bid == 0) {
            world.setblock(d, x, realy + 1, z, OreSpawnMain.MySkyTreeLog.blockID);
        }
        if (Fastmath.nextInt(2) == 1) {
            bid = world.getblock(d, x, realy + 2, z);
            if (bid == 0) {
                world.setblock(d, x, realy + 2, z, OreSpawnMain.MySkyTreeLog.blockID);
            }
            if (Fastmath.nextInt(2) == 1) {
                bid = world.getblock(d, x, realy + 3, z);
                if (bid == 0) {
                    world.setblock(d, x, realy + 3, z, OreSpawnMain.MySkyTreeLog.blockID);
                }
            } else {
                --realy;
            }
        } else {
            realy -= 2;
        }
        if ((bid = world.getblock(d, x, realy + 4, z)) == 0) {
            world.setblock(d, x, realy + 4, z, leafid);
        }
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                bid = world.getblock(d, x + i, realy + 3, z + j);
                if (bid == 0) {
                    world.setblock(d, x + i, realy + 3, z + j, leafid);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void DuplicatorTree(World world, int d, int x, int y, int z) {
        int j;
        int realy = y;
        int bid = world.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            bid = world.getblock(d, x, y - 2, z);
            if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
                bid = world.getblock(d, x, y - 3, z);
                if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
                    world.setblock(d, x, y, z, 0);
                    return;
                }
                realy = y - 3;
            } else {
                realy = y - 2;
            }
            return;
        }
        realy = y - 1;
        bid = world.getblock(d, x, realy + 1, z);
        if (bid != OreSpawnMain.MyDT.blockID) {
            world.setblock(d, x, realy + 1, z, OreSpawnMain.MyDT.blockID);
            return;
        }
        bid = world.getblock(d, x, realy + 2, z);
        if (bid != OreSpawnMain.MyDT.blockID) {
            world.setblock(d, x, realy + 2, z, OreSpawnMain.MyDT.blockID);
            return;
        }
        bid = world.getblock(d, x, realy + 3, z);
        if (bid != OreSpawnMain.MyDT.blockID) {
            world.setblock(d, x, realy + 3, z, OreSpawnMain.MyDT.blockID);
            return;
        }
        bid = world.getblock(d, x, realy + 4, z);
        if (bid != Blocks.appleleaves.blockID) {
            world.setblock(d, x, realy + 4, z, Blocks.appleleaves.blockID);
            return;
        }
        int i = -1;
        while (i <= 1) {
            j = -1;
            while (j <= 1) {
                if ((j != 0 || i != 0) && (bid = world.getblock(d, x + i, realy + 3, z + j)) != Blocks.appleleaves.blockID) {
                    world.setblock(d, x + i, realy + 3, z + j, Blocks.appleleaves.blockID);
                    return;
                }
                ++j;
            }
            ++i;
        }
        int bidm = 0;
        int tries = 0;
        while (tries < 20 && (bidm == 0 || bidm == OreSpawnMain.MyDT.blockID)) {
            i = Fastmath.nextInt(5) - 2;
            j = Fastmath.nextInt(5) - 2;
            bidm = world.getblock(d, x + i, realy + 1, z + j);
            int meta = world.getblockmeta(d, x + i, realy + 1, z + j);
            if (bidm != 0 && bidm != OreSpawnMain.MyDT.blockID) {
                int k = 0;
                while (k < 20) {
                    i = Fastmath.nextInt(5) - 2;
                    bid = world.getblock(d, x + i, realy + 1, z + (j = Fastmath.nextInt(5) - 2));
                    if (bid == 0) {
                        world.setblockandmeta(d, x + i, realy + 1, z + j, bidm, meta);
                        return;
                    }
                    ++k;
                }
            }
            ++tries;
        }
    }

    public static void dtdie(World world, int d, int x, int y, int z) {
        int i = -1;
        while (i <= 1) {
            int k = -1;
            while (k <= 1) {
                int j = -1;
                while (j <= 5) {
                    int bid = world.getblock(d, x + i, y + j, z + k);
                    if (bid == OreSpawnMain.doomtreelog.blockID) {
                        world.setblock(d, x + i, y + j, z + k, 0);
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    public static void DoomTree(World world, int d, int x, int y, int z) {
        int bid;
        int realy = y;
        int i = 1;
        while (i <= 4) {
            bid = world.getblock(d, x, y - i, z);
            if (bid == Blocks.sand.blockID || bid == OreSpawnMain.nofallsand.blockID) {
                realy = y - i;
                break;
            }
            if (bid != OreSpawnMain.doomtreelog.blockID) {
                OreSpawnTrees.dtdie(world, d, x, y - i, z);
                return;
            }
            ++i;
        }
        bid = world.getblock(d, x, realy + 1, z);
        if (bid == 0) {
            world.setblock(d, x, realy + 1, z, OreSpawnMain.doomtreelog.blockID);
            return;
        }
        if (bid != OreSpawnMain.doomtreelog.blockID) {
            OreSpawnTrees.dtdie(world, d, x, realy, z);
        }
        if ((bid = world.getblock(d, x, realy + 2, z)) == 0) {
            world.setblock(d, x, realy + 2, z, OreSpawnMain.doomtreelog.blockID);
            return;
        }
        if (bid != OreSpawnMain.doomtreelog.blockID) {
            OreSpawnTrees.dtdie(world, d, x, realy, z);
        }
        if ((bid = world.getblock(d, x, realy + 3, z)) == 0) {
            world.setblock(d, x, realy + 3, z, OreSpawnMain.doomtreelog.blockID);
            return;
        }
        if (bid != OreSpawnMain.doomtreelog.blockID) {
            OreSpawnTrees.dtdie(world, d, x, realy, z);
        }
        if ((bid = world.getblock(d, x, realy + 4, z)) != OreSpawnMain.doomtree_leaves.blockID) {
            if (bid != 0) {
                OreSpawnTrees.dtdie(world, d, x, realy, z);
                return;
            }
            world.setblock(d, x, realy + 4, z, OreSpawnMain.doomtree_leaves.blockID);
            return;
        }
        bid = world.getblock(d, x, realy + 5, z);
        if (bid != 0) {
            OreSpawnTrees.dtdie(world, d, x, realy, z);
            return;
        }
        i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (j != 0 || i != 0) {
                    bid = world.getblock(d, x + i, realy + 3, z + j);
                    if (bid != OreSpawnMain.doomtree_leaves.blockID) {
                        if (bid != 0) {
                            OreSpawnTrees.dtdie(world, d, x, realy, z);
                            return;
                        }
                        world.setblock(d, x + i, realy + 3, z + j, OreSpawnMain.doomtree_leaves.blockID);
                        return;
                    }
                    bid = world.getblock(d, x + i, realy + 4, z + j);
                    if (bid != 0) {
                        OreSpawnTrees.dtdie(world, d, x, realy, z);
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void FairyTree(World world, int dim, int x, int y, int z) {
        int k;
        int i;
        int j = 1;
        while (j < 6) {
            i = 0;
            while (i < 2) {
                k = 0;
                while (k < 2) {
                    world.setblock(dim, x + i, y + j, z + k, OreSpawnMain.crystallog.blockID);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        OreSpawnTrees.grow_crystal_branch(world, dim, x, y + 5, z, 0, 1, 1, 1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x + 1, y + 5, z, 1, 0, 1, -1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x, y + 5, z + 1, -1, 0, -1, 1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x + 1, y + 5, z + 1, 0, -1, -1, -1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x, y + 6, z, 0, 1, -1, 1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x + 1, y + 6, z, 1, 0, 1, 1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x, y + 6, z + 1, -1, 0, -1, -1, -1);
        OreSpawnTrees.grow_crystal_branch(world, dim, x + 1, y + 6, z + 1, 0, -1, 1, -1, -1);
        int grow = 5 + Fastmath.nextInt(5);
        j = 6;
        while (j < 6 + grow) {
            i = 0;
            while (i < 2) {
                k = 0;
                while (k < 2) {
                    world.setblock(dim, x + i, y + j, z + k, OreSpawnMain.crystallog.blockID);
                    OreSpawnTrees.make_crystal_leaves(world, dim, x + i, y + j, z + k);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        world.setblock(dim, x - 1, y + 1, z, OreSpawnMain.fairyspawner.blockID);
        Utils.add_chest(world, dim, x + 2, y + 1, z, OreSpawnDungeons.AllTheCrystalStuff);
    }

    private static void make_crystal_leaves(World world, int dim, int x, int y, int z) {
        int l1 = -2;
        while (l1 <= 2) {
            int l2 = -2;
            while (l2 <= 2) {
                int l3 = 0;
                while (l3 <= 1) {
                    int bid = world.getblock(dim, x + l1, y + l3, z + l2);
                    if (bid == 0) {
                        world.setblock(dim, x + l1, y + l3, z + l2, OreSpawnMain.blockcrystalleavesblue.blockID);
                    }
                    ++l3;
                }
                ++l2;
            }
            ++l1;
        }
    }

    private static void make_crystal_castle_leaves(World world, int dim, int x, int y, int z) {
        int l1 = -1;
        while (l1 <= 1) {
            int l2 = -1;
            while (l2 <= 1) {
                int l3 = 0;
                while (l3 <= 1) {
                    int bid = world.getblock(dim, x + l1, y + l3, z + l2);
                    if (bid == 0) {
                        if (l3 != 0) {
                            world.setblock(dim, x + l1, y + l3, z + l2, OreSpawnMain.blockcrystalleavesblue.blockID);
                        } else {
                            world.setblock(dim, x + l1, y + l3, z + l2, OreSpawnMain.blockcrystalleavesgreen.blockID);
                        }
                    }
                    ++l3;
                }
                ++l2;
            }
            ++l1;
        }
    }

    private static void grow_crystal_branch(World world, int dim, int x, int y, int z, int xdir, int zdir, int xxdir, int zzdir, int ydir) {
        int i2 = 0;
        int k2 = 0;
        int j2 = 0;
        int i = x;
        int j = y;
        int k = z;
        int grow = 4 + Fastmath.nextInt(4);
        int n = 0;
        while (n < grow) {
            world.setblock(dim, i, j, k, OreSpawnMain.crystallog.blockID);
            OreSpawnTrees.make_crystal_leaves(world, dim, i, j, k);
            ++j;
            i2 = i += xdir;
            k2 = k += zdir;
            ++n;
        }
        grow = 5 + Fastmath.nextInt(5);
        n = 0;
        while (n < grow) {
            world.setblock(dim, i, j, k, OreSpawnMain.crystallog.blockID);
            OreSpawnTrees.make_crystal_leaves(world, dim, i, j, k);
            i += xdir;
            k += zdir;
            ++n;
        }
        grow = 5 + Fastmath.nextInt(5);
        n = 0;
        while (n < grow) {
            world.setblock(dim, i2, j, k2, OreSpawnMain.crystallog.blockID);
            OreSpawnTrees.make_crystal_leaves(world, dim, i2, j, k2);
            i2 += xxdir;
            k2 += zzdir;
            ++n;
        }
        j2 = --j;
        grow = 4 + Fastmath.nextInt(4);
        n = 0;
        while (n < grow) {
            world.setblock(dim, i, j, k, OreSpawnMain.crystallog.blockID);
            OreSpawnTrees.make_crystal_leaves(world, dim, i, j, k);
            i += xdir;
            k += zdir;
            j += ydir;
            ++n;
        }
        grow = 4 + Fastmath.nextInt(4);
        n = 0;
        while (n < grow) {
            world.setblock(dim, i2, j2, k2, OreSpawnMain.crystallog.blockID);
            OreSpawnTrees.make_crystal_leaves(world, dim, i2, j2, k2);
            i2 += xxdir;
            k2 += zzdir;
            j2 += ydir;
            ++n;
        }
    }

    public static void addSomething(World world, int dim, int x, int y, int z) {
        int i = Fastmath.nextInt(3);
        if (i == 1) {
            world.setblock(dim, x, y + 1, z, OreSpawnMain.fairyspawner.blockID);
        }
        if (i == 2) {
            Utils.add_chest(world, dim, x, y + 1, z, OreSpawnDungeons.AllTheCrystalStuff);
        }
    }

    public static void FairyCastleTree(World world, int dim, int x, int y, int z) {
        int nc = 6;
        int j = 3 + Fastmath.nextInt(3);
        int spread = 0;
        int iter = 0;
        while (iter < nc) {
            int k;
            int grow = 4 + Fastmath.nextInt(3);
            int width = 1 + Fastmath.nextInt(3);
            int randy = Fastmath.nextInt(3) - 1;
            int i = -width;
            while (i <= width) {
                k = -width;
                while (k <= width) {
                    world.setblock(dim, x + i + spread, y + j + randy, z + k, OreSpawnMain.crystallog.blockID);
                    if (i == -width || i == width || k == -width || k == width) {
                        OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i + spread, y + j + randy, z + k);
                    }
                    if (iter != 0 && i == 0 && k == 0) {
                        OreSpawnTrees.addSomething(world, dim, x + i + spread, y + j + randy, z + k);
                    }
                    if (i == -width && (k == -width || k == width)) {
                        world.setblock(dim, x + i + spread, y + j + randy + 1, z + k, OreSpawnMain.crystaltorch.blockID);
                    }
                    if (i == width && (k == -width || k == width)) {
                        world.setblock(dim, x + i + spread, y + j + randy + 1, z + k, OreSpawnMain.crystaltorch.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            if (iter != 0) {
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i - spread, y + j + randy, z + k, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i - spread, y + j + randy, z + k);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i - spread, y + j + randy, z + k);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i - spread, y + j + randy + 1, z + k, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i - spread, y + j + randy + 1, z + k, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i, y + j + randy, z + k + spread, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i, y + j + randy, z + k + spread);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i, y + j + randy, z + k + spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i, y + j + randy + 1, z + k + spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i, y + j + randy + 1, z + k + spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i, y + j + randy, z + k - spread, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i, y + j + randy, z + k - spread);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i, y + j + randy, z + k - spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i, y + j + randy + 1, z + k - spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i, y + j + randy + 1, z + k - spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            if (iter >= 2) {
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i + spread, y + j + randy, z + k + spread, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i + spread, y + j + randy, z + k + spread);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i + spread, y + j + randy, z + k + spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i + spread, y + j + randy + 1, z + k + spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i + spread, y + j + randy + 1, z + k + spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i - spread, y + j + randy, z + k - spread, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i - spread, y + j + randy, z + k - spread);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i - spread, y + j + randy, z + k - spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i - spread, y + j + randy + 1, z + k - spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i - spread, y + j + randy + 1, z + k - spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i - spread, y + j + randy, z + k + spread, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i - spread, y + j + randy, z + k + spread);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i - spread, y + j + randy, z + k + spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i - spread, y + j + randy + 1, z + k + spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i - spread, y + j + randy + 1, z + k + spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
                width = 1 + Fastmath.nextInt(3 + iter);
                randy = Fastmath.nextInt(3) - 1;
                i = -width;
                while (i <= width) {
                    k = -width;
                    while (k <= width) {
                        world.setblock(dim, x + i + spread, y + j + randy, z + k - spread, OreSpawnMain.crystallog.blockID);
                        if (i == -width || i == width || k == -width || k == width) {
                            OreSpawnTrees.make_crystal_castle_leaves(world, dim, x + i + spread, y + j + randy, z + k - spread);
                        }
                        if (i == 0 && k == 0) {
                            OreSpawnTrees.addSomething(world, dim, x + i + spread, y + j + randy, z + k - spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            world.setblock(dim, x + i + spread, y + j + randy + 1, z + k - spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        if (i == width && (k == -width || k == width)) {
                            world.setblock(dim, x + i + spread, y + j + randy + 1, z + k - spread, OreSpawnMain.crystaltorch.blockID);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            j += grow;
            if (iter == 0) {
                spread = 3;
            }
            spread += grow;
            ++iter;
        }
    }

    private static void make_leaves(World world, int d, int x, int y, int z) {
        int l1 = -3;
        while (l1 <= 3) {
            int l2 = -3;
            while (l2 <= 3) {
                int l3 = 0;
                while (l3 <= 2) {
                    int bid = world.getblock(d, x + l1, y + l3, z + l2);
                    if (bid == 0) {
                        OreSpawnTrees.FastSetBlock(world, d, x + l1, y + l3, z + l2, OreSpawnMain.experiencetree_leaves.blockID, 0);
                    }
                    ++l3;
                }
                ++l2;
            }
            ++l1;
        }
    }

    private static void grow_small_branch(World world, int d, int x, int y, int z, int xdir, int zdir, int xxdir, int zzdir) {
        int i2 = 0;
        int k2 = 0;
        int j2 = 0;
        int i = x;
        int j = y;
        int k = z;
        int grow = 4 + Fastmath.nextInt(2);
        int n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i, j, k, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i, j, k);
            ++j;
            i2 = i += xdir;
            k2 = k += zdir;
            ++n;
        }
        grow = 4 + Fastmath.nextInt(3);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i, j, k, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i, j, k);
            i += xdir;
            k += zdir;
            ++n;
        }
        grow = 4 + Fastmath.nextInt(3);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i2, j, k2, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i2, j, k2);
            i2 += xxdir;
            k2 += zzdir;
            ++n;
        }
        j2 = --j;
        grow = 3 + Fastmath.nextInt(3);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i, j, k, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i, j, k);
            i += xdir;
            k += zdir;
            --j;
            ++n;
        }
        grow = 3 + Fastmath.nextInt(3);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i2, j2, k2, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i2, j2, k2);
            i2 += xxdir;
            k2 += zzdir;
            --j2;
            ++n;
        }
    }

    private static void grow_branch(World world, int d, int x, int y, int z, int xdir, int zdir, int xxdir, int zzdir) {
        int i2 = 0;
        int k2 = 0;
        int j2 = 0;
        int i = x;
        int j = y;
        int k = z;
        int grow = 5 + Fastmath.nextInt(4);
        int n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i, j, k, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i, j, k);
            ++j;
            i2 = i += xdir;
            k2 = k += zdir;
            ++n;
        }
        grow = 6 + Fastmath.nextInt(5);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i, j, k, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i, j, k);
            i += xdir;
            k += zdir;
            ++n;
        }
        grow = 6 + Fastmath.nextInt(5);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i2, j, k2, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i2, j, k2);
            i2 += xxdir;
            k2 += zzdir;
            ++n;
        }
        j2 = --j;
        grow = 4 + Fastmath.nextInt(4);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i, j, k, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i, j, k);
            i += xdir;
            k += zdir;
            --j;
            ++n;
        }
        grow = 4 + Fastmath.nextInt(4);
        n = 0;
        while (n < grow) {
            OreSpawnTrees.FastSetBlock(world, d, i2, j2, k2, Blocks.willowlog.blockID, 0);
            OreSpawnTrees.make_leaves(world, d, i2, j2, k2);
            i2 += xxdir;
            k2 += zzdir;
            --j2;
            ++n;
        }
    }

    public static void ExperienceTree(World world, int d, int x, int y, int z) {
        int k;
        int i;
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int j = 1;
        while (j < 6) {
            i = 0;
            while (i < 2) {
                k = 0;
                while (k < 2) {
                    OreSpawnTrees.FastSetBlock(world, d, x + i, y + j, z + k, Blocks.willowlog.blockID, 0);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        OreSpawnTrees.grow_branch(world, d, x, y + 6, z, 0, 1, 1, 1);
        OreSpawnTrees.grow_branch(world, d, x + 1, y + 6, z, 1, 0, 1, -1);
        OreSpawnTrees.grow_branch(world, d, x, y + 6, z + 1, -1, 0, -1, 1);
        OreSpawnTrees.grow_branch(world, d, x + 1, y + 6, z + 1, 0, -1, -1, -1);
        j = 7;
        while (j < 19) {
            i = 0;
            while (i < 2) {
                k = 0;
                while (k < 2) {
                    OreSpawnTrees.FastSetBlock(world, d, x + i, y + j, z + k, Blocks.willowlog.blockID, 0);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        OreSpawnTrees.grow_small_branch(world, d, x, y + 19, z, 0, 1, -1, 1);
        OreSpawnTrees.grow_small_branch(world, d, x + 1, y + 19, z, 1, 0, 1, 1);
        OreSpawnTrees.grow_small_branch(world, d, x, y + 19, z + 1, -1, 0, -1, -1);
        OreSpawnTrees.grow_small_branch(world, d, x + 1, y + 19, z + 1, 0, -1, 1, -1);
        int grow = 5 + Fastmath.nextInt(6);
        j = 19;
        while (j < 19 + grow) {
            i = 0;
            while (i < 2) {
                k = 0;
                while (k < 2) {
                    OreSpawnTrees.FastSetBlock(world, d, x + i, y + j, z + k, Blocks.willowlog.blockID, 0);
                    OreSpawnTrees.make_leaves(world, d, x + i, y + j, z + k);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
    }

    public void darkTreeNormal(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != OreSpawnMain.darkdirt.blockID) {
            return;
        }
        int leafcolor = OreSpawnMain.darkleaves.blockID;
        int howmany = 8 + Fastmath.nextInt(10);
        int i = 0;
        while (i < howmany) {
            float rad = 6 + Fastmath.nextInt(12);
            int ioff = Fastmath.nextInt(360);
            float xoff = (Fastmath.nextFloat() - Fastmath.nextFloat()) * 2.0f;
            float zoff = (Fastmath.nextFloat() - Fastmath.nextFloat()) * 2.0f;
            int leafstart = 35 + Fastmath.nextInt(20);
            int idir = 0;
            while (idir < 90) {
                float dx = rad - (float)((double)rad * Fastmath.cos(Math.toRadians(idir)));
                float dz = (float)((double)dx * Fastmath.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Fastmath.sin(Math.toRadians(ioff)));
                float dy = (float)((double)rad * Fastmath.sin(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, OreSpawnMain.darklog.blockID);
                if (idir >= leafstart) {
                    this.makedarkleaves(world, d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, leafcolor);
                }
                idir += 2;
            }
            ++i;
        }
    }

    public void makedarkleaves(World world, int d, int x, int y, int z, int leafcolor) {
        int i = -1;
        while (i <= 1) {
            int j = 0;
            while (j <= 1) {
                int k = -1;
                while (k <= 1) {
                    if (world.getblock(d, x + i, y + j, z + k) == 0) {
                        world.setblocknonotify(d, x + i, y + j, z + k, leafcolor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addGrass(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        int howmany = 0;
        howmany = 5 + Fastmath.nextInt(10);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + Fastmath.nextInt(16);
            int posZ = chunkZ + Fastmath.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    world.setblock(d, posX, posY, posZ, Blocks.grass.blockID);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public boolean addGenericTrees(World world, int d, int chunkX, int chunkZ, int treetype) {
        if (Fastmath.nextInt(5) != 0) {
            return false;
        }
        int howmany = 0;
        int blkid = 0;
        boolean added = false;
        Trees dztr = new Trees();
        howmany = 2 + Fastmath.nextInt(5);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + Fastmath.nextInt(16);
            int posZ = chunkZ + Fastmath.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (treetype == 0) {
                        dztr.umbrellaTree(world, d, posX, posY - 1, posZ);
                    }
                    if (treetype == 1) {
                        dztr.flowerTreeNormal(world, d, posX, posY - 1, posZ);
                    }
                    if (treetype == 2) {
                        if (blkid == 0) {
                            blkid = Blocks.appleleaves.blockID;
                            if (Fastmath.nextBoolean()) {
                                blkid = Blocks.cherryleaves.blockID;
                            }
                            if (Fastmath.nextBoolean()) {
                                blkid = Blocks.peachleaves.blockID;
                            }
                        }
                        dztr.makeFruitTree(world, d, posX, posY - 1, posZ, blkid);
                    }
                    added = true;
                    break;
                }
                --posY;
            }
            ++i;
        }
        return added;
    }
}

