/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.MashupBiome;
import OreSpawn.MashupBiomeManager;
import dangerzone.Player;
import dangerzone.biomes.Biome;
import dangerzone.entities.Entity;
import dangerzone.world.Chunk;
import dangerzone.world.Dimension;
import dangerzone.world.Dimensions;
import dangerzone.world.SpawnlistEntry;
import dangerzone.world.World;

public class MashupDimension
extends Dimension {
    public MashupDimension(String n) {
        super(n);
    }

    @Override
    public String getDisplayName() {
        return "OreSpawn: Mashup Dimension";
    }

    @Override
    public boolean isNameMatch(String name, int cx, int cz) {
        if (name == null) {
            return true;
        }
        MashupBiomeManager mm = (MashupBiomeManager)this.bm;
        int li = mm.getWhichBiomeLocal(cx << 4, 1, cz << 4);
        MashupBiome mb = (MashupBiome)mm.biomes[li];
        return Dimensions.DimensionArray[mb.dim].isNameMatch(name, cx, cz);
    }

    @Override
    public boolean canSpawnHere(World w, int d, int x, int z, SpawnlistEntry st) {
        MashupBiomeManager mm = (MashupBiomeManager)this.bm;
        int li = mm.getWhichBiomeLocal(x, 1, z);
        MashupBiome mb = (MashupBiome)mm.biomes[li];
        return Dimensions.DimensionArray[mb.dim].canSpawnHere(w, d, x, z, st);
    }

    @Override
    public void tickChunk(Player p, World w, Chunk c) {
        MashupBiomeManager mm = (MashupBiomeManager)this.bm;
        int li = mm.getWhichBiomeLocal(c.chunkX << 4, 1, c.chunkZ << 4);
        MashupBiome mb = (MashupBiome)mm.biomes[li];
        Dimensions.DimensionArray[mb.dim].tickChunk(p, w, c);
    }

    @Override
    public boolean canOreBeHere(World w, int oreID, int d, Biome b, int cx, int cz) {
        MashupBiomeManager mm = (MashupBiomeManager)this.bm;
        int li = mm.getWhichBiomeLocal(cx << 4, 1, cz << 4);
        MashupBiome mb = (MashupBiome)mm.biomes[li];
        return Dimensions.DimensionArray[mb.dim].canOreBeHere(w, oreID, d, b, cx, cz);
    }

    @Override
    public void teleportToDimension(Entity e, World w, int d, int x, int y, int z) {
        MashupBiomeManager mm = (MashupBiomeManager)this.bm;
        int li = mm.getWhichBiomeLocal(x, y, z);
        MashupBiome mb = (MashupBiome)mm.biomes[li];
        Dimensions.DimensionArray[mb.dim].teleportToDimension(e, w, d, x, y, z);
    }
}

