/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIExportDataBlob;
import org.lwjgl.assimp.AIExportFormatDesc;
import org.lwjgl.assimp.AIFileIO;
import org.lwjgl.assimp.AIImporterDesc;
import org.lwjgl.assimp.AILogStream;
import org.lwjgl.assimp.AIMaterial;
import org.lwjgl.assimp.AIMatrix3x3;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIMemoryInfo;
import org.lwjgl.assimp.AIPropertyStore;
import org.lwjgl.assimp.AIQuaternion;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIUVTransform;
import org.lwjgl.assimp.AIVector2D;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;

public class Assimp {
    private static final SharedLibrary ASSIMP = Library.loadNative(Assimp.class, (String)"org.lwjgl.assimp", (String)((String)Configuration.ASSIMP_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"assimp"))), (boolean)true);
    public static final String AI_CONFIG_GLOB_MEASURE_TIME = "GLOB_MEASURE_TIME";
    public static final String AI_CONFIG_IMPORT_NO_SKELETON_MESHES = "IMPORT_NO_SKELETON_MESHES";
    public static final String AI_CONFIG_PP_SBBC_MAX_BONES = "PP_SBBC_MAX_BONES";
    public static final String AI_CONFIG_PP_CT_MAX_SMOOTHING_ANGLE = "PP_CT_MAX_SMOOTHING_ANGLE";
    public static final String AI_CONFIG_PP_CT_TEXTURE_CHANNEL_INDEX = "PP_CT_TEXTURE_CHANNEL_INDEX";
    public static final String AI_CONFIG_PP_GSN_MAX_SMOOTHING_ANGLE = "PP_GSN_MAX_SMOOTHING_ANGLE";
    public static final String AI_CONFIG_IMPORT_MDL_COLORMAP = "IMPORT_MDL_COLORMAP";
    public static final String AI_CONFIG_PP_RRM_EXCLUDE_LIST = "PP_RRM_EXCLUDE_LIST";
    public static final String AI_CONFIG_PP_PTV_KEEP_HIERARCHY = "PP_PTV_KEEP_HIERARCHY";
    public static final String AI_CONFIG_PP_PTV_NORMALIZE = "PP_PTV_NORMALIZE";
    public static final String AI_CONFIG_PP_PTV_ADD_ROOT_TRANSFORMATION = "PP_PTV_ADD_ROOT_TRANSFORMATION";
    public static final String AI_CONFIG_PP_PTV_ROOT_TRANSFORMATION = "PP_PTV_ROOT_TRANSFORMATION";
    public static final String AI_CONFIG_PP_FD_REMOVE = "PP_FD_REMOVE";
    public static final String AI_CONFIG_PP_FD_CHECKAREA = "PP_FD_CHECKAREA";
    public static final String AI_CONFIG_PP_OG_EXCLUDE_LIST = "PP_OG_EXCLUDE_LIST";
    public static final String AI_CONFIG_PP_SLM_TRIANGLE_LIMIT = "PP_SLM_TRIANGLE_LIMIT";
    public static final String AI_CONFIG_PP_SLM_VERTEX_LIMIT = "PP_SLM_VERTEX_LIMIT";
    public static final String AI_CONFIG_PP_LBW_MAX_WEIGHTS = "PP_LBW_MAX_WEIGHTS";
    public static final String AI_CONFIG_PP_DB_THRESHOLD = "PP_DB_THRESHOLD";
    public static final String AI_CONFIG_PP_DB_ALL_OR_NONE = "PP_DB_ALL_OR_NONE";
    public static final String AI_CONFIG_PP_ICL_PTCACHE_SIZE = "PP_ICL_PTCACHE_SIZE";
    public static final String AI_CONFIG_PP_RVC_FLAGS = "PP_RVC_FLAGS";
    public static final String AI_CONFIG_PP_SBP_REMOVE = "PP_SBP_REMOVE";
    public static final String AI_CONFIG_PP_FID_ANIM_ACCURACY = "PP_FID_ANIM_ACCURACY";
    public static final String AI_CONFIG_PP_FID_IGNORE_TEXTURECOORDS = "PP_FID_IGNORE_TEXTURECOORDS";
    public static final String AI_CONFIG_PP_TUV_EVALUATE = "PP_TUV_EVALUATE";
    public static final String AI_CONFIG_FAVOUR_SPEED = "FAVOUR_SPEED";
    public static final String AI_CONFIG_IMPORT_SCHEMA_DOCUMENT_PROVIDER = "IMPORT_SCHEMA_DOCUMENT_PROVIDER";
    public static final String AI_CONFIG_IMPORT_FBX_READ_ALL_GEOMETRY_LAYERS = "IMPORT_FBX_READ_ALL_GEOMETRY_LAYERS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_ALL_MATERIALS = "IMPORT_FBX_READ_ALL_MATERIALS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_MATERIALS = "IMPORT_FBX_READ_MATERIALS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_TEXTURES = "IMPORT_FBX_READ_TEXTURES";
    public static final String AI_CONFIG_IMPORT_FBX_READ_CAMERAS = "IMPORT_FBX_READ_CAMERAS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_LIGHTS = "IMPORT_FBX_READ_LIGHTS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_ANIMATIONS = "IMPORT_FBX_READ_ANIMATIONS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_WEIGHTS = "IMPORT_FBX_READ_WEIGHTS";
    public static final String AI_CONFIG_IMPORT_FBX_STRICT_MODE = "IMPORT_FBX_STRICT_MODE";
    public static final String AI_CONFIG_IMPORT_FBX_PRESERVE_PIVOTS = "IMPORT_FBX_PRESERVE_PIVOTS";
    public static final String AI_CONFIG_IMPORT_FBX_OPTIMIZE_EMPTY_ANIMATION_CURVES = "IMPORT_FBX_OPTIMIZE_EMPTY_ANIMATION_CURVES";
    public static final String AI_CONFIG_IMPORT_FBX_EMBEDDED_TEXTURES_LEGACY_NAMING = "AI_CONFIG_IMPORT_FBX_EMBEDDED_TEXTURES_LEGACY_NAMING";
    public static final String AI_CONFIG_IMPORT_REMOVE_EMPTY_BONES = "AI_CONFIG_IMPORT_REMOVE_EMPTY_BONES";
    public static final String AI_CONFIG_FBX_CONVERT_TO_M = "AI_CONFIG_FBX_CONVERT_TO_M";
    public static final String AI_CONFIG_IMPORT_GLOBAL_KEYFRAME = "IMPORT_GLOBAL_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MD3_KEYFRAME = "IMPORT_MD3_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MD2_KEYFRAME = "IMPORT_MD2_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MDL_KEYFRAME = "IMPORT_MDL_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MDC_KEYFRAME = "IMPORT_MDC_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_SMD_KEYFRAME = "IMPORT_SMD_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_UNREAL_KEYFRAME = "IMPORT_UNREAL_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_ANIMATIONS = "IMPORT_MDL_HL1_READ_ANIMATIONS";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_ANIMATION_EVENTS = "IMPORT_MDL_HL1_READ_ANIMATION_EVENTS";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_BLEND_CONTROLLERS = "IMPORT_MDL_HL1_READ_BLEND_CONTROLLERS";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_SEQUENCE_TRANSITIONS = "IMPORT_MDL_HL1_READ_SEQUENCE_TRANSITIONS";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_ATTACHMENTS = "IMPORT_MDL_HL1_READ_ATTACHMENTS";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_BONE_CONTROLLERS = "IMPORT_MDL_HL1_READ_BONE_CONTROLLERS";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_HITBOXES = "IMPORT_MDL_HL1_READ_HITBOXES";
    public static final String AI_CONFIG_IMPORT_MDL_HL1_READ_MISC_GLOBAL_INFO = "IMPORT_MDL_HL1_READ_MISC_GLOBAL_INFO";
    public static final String AI_CONFIG_IMPORT_SMD_LOAD_ANIMATION_LIST = "IMPORT_SMD_LOAD_ANIMATION_LIST";
    public static final String AI_CONFIG_IMPORT_AC_SEPARATE_BFCULL = "IMPORT_AC_SEPARATE_BFCULL";
    public static final String AI_CONFIG_IMPORT_AC_EVAL_SUBDIVISION = "IMPORT_AC_EVAL_SUBDIVISION";
    public static final String AI_CONFIG_UNREAL_HANDLE_FLAGS = "UNREAL_HANDLE_FLAGS";
    public static final String AI_CONFIG_IMPORT_TER_MAKE_UVS = "IMPORT_TER_MAKE_UVS";
    public static final String AI_CONFIG_IMPORT_ASE_RECONSTRUCT_NORMALS = "IMPORT_ASE_RECONSTRUCT_NORMALS";
    public static final String AI_CONFIG_IMPORT_MD3_HANDLE_MULTIPART = "IMPORT_MD3_HANDLE_MULTIPART";
    public static final String AI_CONFIG_IMPORT_MD3_SKIN_NAME = "IMPORT_MD3_SKIN_NAME";
    public static final String AI_CONFIG_IMPORT_MD3_LOAD_SHADERS = "IMPORT_MD3_LOAD_SHADERS";
    public static final String AI_CONFIG_IMPORT_MD3_SHADER_SRC = "IMPORT_MD3_SHADER_SRC";
    public static final String AI_CONFIG_IMPORT_LWO_ONE_LAYER_ONLY = "IMPORT_LWO_ONE_LAYER_ONLY";
    public static final String AI_CONFIG_IMPORT_MD5_NO_ANIM_AUTOLOAD = "IMPORT_MD5_NO_ANIM_AUTOLOAD";
    public static final String AI_CONFIG_IMPORT_LWS_ANIM_START = "IMPORT_LWS_ANIM_START";
    public static final String AI_CONFIG_IMPORT_LWS_ANIM_END = "IMPORT_LWS_ANIM_END";
    public static final String AI_CONFIG_IMPORT_IRR_ANIM_FPS = "IMPORT_IRR_ANIM_FPS";
    public static final String AI_CONFIG_IMPORT_OGRE_MATERIAL_FILE = "IMPORT_OGRE_MATERIAL_FILE";
    public static final String AI_CONFIG_IMPORT_OGRE_TEXTURETYPE_FROM_FILENAME = "IMPORT_OGRE_TEXTURETYPE_FROM_FILENAME";
    public static final String AI_CONFIG_IMPORT_IFC_SKIP_SPACE_REPRESENTATIONS = "IMPORT_IFC_SKIP_SPACE_REPRESENTATIONS";
    public static final String AI_CONFIG_ANDROID_JNI_ASSIMP_MANAGER_SUPPORT = "AI_CONFIG_ANDROID_JNI_ASSIMP_MANAGER_SUPPORT";
    public static final String AI_CONFIG_IMPORT_IFC_SKIP_CURVE_REPRESENTATIONS = "IMPORT_IFC_SKIP_CURVE_REPRESENTATIONS";
    public static final String AI_CONFIG_IMPORT_IFC_CUSTOM_TRIANGULATION = "IMPORT_IFC_CUSTOM_TRIANGULATION";
    public static final String AI_CONFIG_IMPORT_IFC_SMOOTHING_ANGLE = "IMPORT_IFC_SMOOTHING_ANGLE";
    public static final String AI_CONFIG_IMPORT_IFC_CYLINDRICAL_TESSELLATION = "IMPORT_IFC_CYLINDRICAL_TESSELLATION";
    public static final String AI_CONFIG_IMPORT_COLLADA_IGNORE_UP_DIRECTION = "IMPORT_COLLADA_IGNORE_UP_DIRECTION";
    public static final String AI_CONFIG_IMPORT_COLLADA_USE_COLLADA_NAMES = "IMPORT_COLLADA_USE_COLLADA_NAMES";
    public static final String AI_CONFIG_EXPORT_XFILE_64BIT = "EXPORT_XFILE_64BIT";
    public static final String AI_CONFIG_EXPORT_POINT_CLOUDS = "EXPORT_POINT_CLOUDS";
    public static final String AI_CONFIG_EXPORT_BLOB_NAME = "EXPORT_BLOB_NAME";
    public static final String AI_CONFIG_GLOBAL_SCALE_FACTOR_KEY = "GLOBAL_SCALE_FACTOR";
    public static final String AI_CONFIG_APP_SCALE_KEY = "APP_SCALE_FACTOR";
    public static final int AI_SBBC_DEFAULT_MAX_BONES = 60;
    public static final int AI_SLM_DEFAULT_MAX_TRIANGLES = 1000000;
    public static final int AI_SLM_DEFAULT_MAX_VERTICES = 1000000;
    public static final int AI_LBW_MAX_WEIGHTS = 4;
    public static final int PP_ICL_PTCACHE_SIZE = 12;
    public static final int AI_IMPORT_IFC_DEFAULT_CYLINDRICAL_TESSELLATION = 32;
    public static final float AI_DEBONE_THRESHOLD = 1.0f;
    public static final float AI_IMPORT_IFC_DEFAULT_SMOOTHING_ANGLE = 10.0f;
    public static final float AI_CONFIG_GLOBAL_SCALE_FACTOR_DEFAULT = 1.0f;
    public static final float AI_CONFIG_APP_SCALE_DEFAULT = 1.0f;
    public static final int AI_UVTRAFO_SCALING = 1;
    public static final int AI_UVTRAFO_ROTATION = 2;
    public static final int AI_UVTRAFO_TRANSLATION = 4;
    public static final int AI_UVTRAFO_ALL = 7;
    public static final int aiComponent_NORMALS = 2;
    public static final int aiComponent_TANGENTS_AND_BITANGENTS = 4;
    public static final int aiComponent_COLORS = 8;
    public static final int aiComponent_TEXCOORDS = 16;
    public static final int aiComponent_BONEWEIGHTS = 32;
    public static final int aiComponent_ANIMATIONS = 64;
    public static final int aiComponent_TEXTURES = 128;
    public static final int aiComponent_LIGHTS = 256;
    public static final int aiComponent_CAMERAS = 512;
    public static final int aiComponent_MESHES = 1024;
    public static final int aiComponent_MATERIALS = 2048;
    public static final double AI_MATH_PI = Math.PI;
    public static final double AI_MATH_TWO_PI = Math.PI * 2;
    public static final double AI_MATH_HALF_PI = 1.5707963267948966;
    public static final float AI_MATH_PI_F = (float)Math.PI;
    public static final float AI_MATH_TWO_PI_F = (float)Math.PI * 2;
    public static final float AI_MATH_HALF_PI_F = 0.0f;
    public static final float ai_epsilon = 1.0E-5f;
    public static final int MAXLEN = 1024;
    public static final int aiReturn_SUCCESS = 0;
    public static final int aiReturn_FAILURE = -1;
    public static final int aiReturn_OUTOFMEMORY = -3;
    public static final int aiOrigin_SET = 0;
    public static final int aiOrigin_CUR = 1;
    public static final int aiOrigin_END = 2;
    public static final int aiDefaultLogStream_FILE = 1;
    public static final int aiDefaultLogStream_STDOUT = 2;
    public static final int aiDefaultLogStream_STDERR = 4;
    public static final int aiDefaultLogStream_DEBUGGER = 8;
    public static final int aiAnimBehaviour_DEFAULT = 0;
    public static final int aiAnimBehaviour_CONSTANT = 1;
    public static final int aiAnimBehaviour_LINEAR = 2;
    public static final int aiAnimBehaviour_REPEAT = 3;
    public static final int AI_TRUE = 1;
    public static final int AI_FALSE = 0;
    public static final int aiImporterFlags_SupportTextFlavour = 1;
    public static final int aiImporterFlags_SupportBinaryFlavour = 2;
    public static final int aiImporterFlags_SupportCompressedFlavour = 4;
    public static final int aiImporterFlags_LimitedSupport = 8;
    public static final int aiImporterFlags_Experimental = 16;
    public static final int aiLightSource_UNDEFINED = 0;
    public static final int aiLightSource_DIRECTIONAL = 1;
    public static final int aiLightSource_POINT = 2;
    public static final int aiLightSource_SPOT = 3;
    public static final int aiLightSource_AMBIENT = 4;
    public static final int aiLightSource_AREA = 5;
    public static final String AI_DEFAULT_MATERIAL_NAME = "DefaultMaterial";
    public static final int aiTextureOp_Multiply = 0;
    public static final int aiTextureOp_Add = 1;
    public static final int aiTextureOp_Subtract = 2;
    public static final int aiTextureOp_Divide = 3;
    public static final int aiTextureOp_SmoothAdd = 4;
    public static final int aiTextureOp_SignedAdd = 5;
    public static final int aiTextureMapMode_Wrap = 0;
    public static final int aiTextureMapMode_Clamp = 1;
    public static final int aiTextureMapMode_Decal = 3;
    public static final int aiTextureMapMode_Mirror = 2;
    public static final int aiTextureMapping_UV = 0;
    public static final int aiTextureMapping_SPHERE = 1;
    public static final int aiTextureMapping_CYLINDER = 2;
    public static final int aiTextureMapping_BOX = 3;
    public static final int aiTextureMapping_PLANE = 4;
    public static final int aiTextureMapping_OTHER = 5;
    public static final int aiTextureType_NONE = 0;
    public static final int aiTextureType_DIFFUSE = 1;
    public static final int aiTextureType_SPECULAR = 2;
    public static final int aiTextureType_AMBIENT = 3;
    public static final int aiTextureType_EMISSIVE = 4;
    public static final int aiTextureType_HEIGHT = 5;
    public static final int aiTextureType_NORMALS = 6;
    public static final int aiTextureType_SHININESS = 7;
    public static final int aiTextureType_OPACITY = 8;
    public static final int aiTextureType_DISPLACEMENT = 9;
    public static final int aiTextureType_LIGHTMAP = 10;
    public static final int aiTextureType_REFLECTION = 11;
    public static final int aiTextureType_BASE_COLOR = 12;
    public static final int aiTextureType_NORMAL_CAMERA = 13;
    public static final int aiTextureType_EMISSION_COLOR = 14;
    public static final int aiTextureType_METALNESS = 15;
    public static final int aiTextureType_DIFFUSE_ROUGHNESS = 16;
    public static final int aiTextureType_AMBIENT_OCCLUSION = 17;
    public static final int aiTextureType_SHEEN = 19;
    public static final int aiTextureType_CLEARCOAT = 20;
    public static final int aiTextureType_TRANSMISSION = 21;
    public static final int aiTextureType_UNKNOWN = 18;
    public static final int aiShadingMode_Flat = 1;
    public static final int aiShadingMode_Gouraud = 2;
    public static final int aiShadingMode_Phong = 3;
    public static final int aiShadingMode_Blinn = 4;
    public static final int aiShadingMode_Toon = 5;
    public static final int aiShadingMode_OrenNayar = 6;
    public static final int aiShadingMode_Minnaert = 7;
    public static final int aiShadingMode_CookTorrance = 8;
    public static final int aiShadingMode_NoShading = 9;
    public static final int aiShadingMode_Unlit = 9;
    public static final int aiShadingMode_Fresnel = 10;
    public static final int aiShadingMode_PBR_BRDF = 11;
    public static final int aiTextureFlags_Invert = 1;
    public static final int aiTextureFlags_UseAlpha = 2;
    public static final int aiTextureFlags_IgnoreAlpha = 2;
    public static final int aiBlendMode_Default = 0;
    public static final int aiBlendMode_Additive = 1;
    public static final int aiPTI_Float = 1;
    public static final int aiPTI_Double = 2;
    public static final int aiPTI_String = 3;
    public static final int aiPTI_Integer = 4;
    public static final int aiPTI_Buffer = 5;
    public static final String AI_MATKEY_NAME = "?mat.name";
    public static final String AI_MATKEY_TWOSIDED = "$mat.twosided";
    public static final String AI_MATKEY_SHADING_MODEL = "$mat.shadingm";
    public static final String AI_MATKEY_ENABLE_WIREFRAME = "$mat.wireframe";
    public static final String AI_MATKEY_BLEND_FUNC = "$mat.blend";
    public static final String AI_MATKEY_OPACITY = "$mat.opacity";
    public static final String AI_MATKEY_TRANSPARENCYFACTOR = "$mat.transparencyfactor";
    public static final String AI_MATKEY_BUMPSCALING = "$mat.bumpscaling";
    public static final String AI_MATKEY_SHININESS = "$mat.shininess";
    public static final String AI_MATKEY_REFLECTIVITY = "$mat.reflectivity";
    public static final String AI_MATKEY_SHININESS_STRENGTH = "$mat.shinpercent";
    public static final String AI_MATKEY_REFRACTI = "$mat.refracti";
    public static final String AI_MATKEY_COLOR_DIFFUSE = "$clr.diffuse";
    public static final String AI_MATKEY_COLOR_AMBIENT = "$clr.ambient";
    public static final String AI_MATKEY_COLOR_SPECULAR = "$clr.specular";
    public static final String AI_MATKEY_COLOR_EMISSIVE = "$clr.emissive";
    public static final String AI_MATKEY_COLOR_TRANSPARENT = "$clr.transparent";
    public static final String AI_MATKEY_COLOR_REFLECTIVE = "$clr.reflective";
    public static final String AI_MATKEY_GLOBAL_BACKGROUND_IMAGE = "?bg.global";
    public static final String AI_MATKEY_GLOBAL_SHADERLANG = "?sh.lang";
    public static final String AI_MATKEY_SHADER_VERTEX = "?sh.vs";
    public static final String AI_MATKEY_SHADER_FRAGMENT = "?sh.fs";
    public static final String AI_MATKEY_SHADER_GEO = "?sh.gs";
    public static final String AI_MATKEY_SHADER_TESSELATION = "?sh.ts";
    public static final String AI_MATKEY_SHADER_PRIMITIVE = "?sh.ps";
    public static final String AI_MATKEY_SHADER_COMPUTE = "?sh.cs";
    public static final String AI_MATKEY_USE_COLOR_MAP = "$mat.useColorMap";
    public static final String AI_MATKEY_BASE_COLOR = "$clr.base";
    public static final String AI_MATKEY_USE_METALLIC_MAP = "$mat.useMetallicMap";
    public static final String AI_MATKEY_METALLIC_FACTOR = "$mat.metallicFactor";
    public static final String AI_MATKEY_USE_ROUGHNESS_MAP = "$mat.useRoughnessMap";
    public static final String AI_MATKEY_ROUGHNESS_FACTOR = "$mat.roughnessFactor";
    public static final String AI_MATKEY_SPECULAR_FACTOR = "$mat.specularFactor";
    public static final String AI_MATKEY_GLOSSINESS_FACTOR = "$mat.glossinessFactor";
    public static final String AI_MATKEY_SHEEN_COLOR_FACTOR = "$clr.sheen.factor";
    public static final String AI_MATKEY_SHEEN_ROUGHNESS_FACTOR = "$mat.sheen.roughnessFactor";
    public static final String AI_MATKEY_CLEARCOAT_FACTOR = "$mat.clearcoat.factor";
    public static final String AI_MATKEY_CLEARCOAT_ROUGHNESS_FACTOR = "$mat.clearcoat.roughnessFactor";
    public static final String AI_MATKEY_TRANSMISSION_FACTOR = "$mat.transmission.factor";
    public static final String AI_MATKEY_VOLUME_THICKNESS_FACTOR = "$mat.volume.thicknessFactor";
    public static final String AI_MATKEY_VOLUME_ATTENUATION_DISTANCE = "$mat.volume.attenuationDistance";
    public static final String AI_MATKEY_VOLUME_ATTENUATION_COLOR = "$mat.volume.attenuationColor";
    public static final String AI_MATKEY_USE_EMISSIVE_MAP = "$mat.useEmissiveMap";
    public static final String AI_MATKEY_EMISSIVE_INTENSITY = "$mat.emissiveIntensity";
    public static final String AI_MATKEY_USE_AO_MAP = "$mat.useAOMap";
    public static final String _AI_MATKEY_TEXTURE_BASE = "$tex.file";
    public static final String _AI_MATKEY_UVWSRC_BASE = "$tex.uvwsrc";
    public static final String _AI_MATKEY_TEXOP_BASE = "$tex.op";
    public static final String _AI_MATKEY_MAPPING_BASE = "$tex.mapping";
    public static final String _AI_MATKEY_TEXBLEND_BASE = "$tex.blend";
    public static final String _AI_MATKEY_MAPPINGMODE_U_BASE = "$tex.mapmodeu";
    public static final String _AI_MATKEY_MAPPINGMODE_V_BASE = "$tex.mapmodev";
    public static final String _AI_MATKEY_TEXMAP_AXIS_BASE = "$tex.mapaxis";
    public static final String _AI_MATKEY_UVTRANSFORM_BASE = "$tex.uvtrafo";
    public static final String _AI_MATKEY_TEXFLAGS_BASE = "$tex.flags";
    public static final String aiAI_MATKEY_GLTF_ALPHAMODE = "$mat.gltf.alphaMode";
    public static final String aiAI_MATKEY_GLTF_ALPHACUTOFF = "$mat.gltf.alphaCutoff";
    public static final String ai_AI_MATKEY_GLTF_TEXTURE_TEXCOORD_BASE = "$tex.file.texCoord";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGNAME_BASE = "$tex.mappingname";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGID_BASE = "$tex.mappingid";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGFILTER_MAG_BASE = "$tex.mappingfiltermag";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGFILTER_MIN_BASE = "$tex.mappingfiltermin";
    public static final String ai_AI_MATKEY_GLTF_SCALE_BASE = "$tex.scale";
    public static final String ai_AI_MATKEY_GLTF_STRENGTH_BASE = "$tex.strength";
    public static final int AI_MATKEY_GLTF_PBRMETALLICROUGHNESS_METALLICROUGHNESS_TEXTURE = 18;
    public static final int AI_MAX_FACE_INDICES = Short.MAX_VALUE;
    public static final int AI_MAX_BONE_WEIGHTS = Integer.MAX_VALUE;
    public static final int AI_MAX_VERTICES = Integer.MAX_VALUE;
    public static final int AI_MAX_FACES = Integer.MAX_VALUE;
    public static final int AI_MAX_NUMBER_OF_COLOR_SETS = 8;
    public static final int AI_MAX_NUMBER_OF_TEXTURECOORDS = 8;
    public static final int aiPrimitiveType_POINT = 1;
    public static final int aiPrimitiveType_LINE = 2;
    public static final int aiPrimitiveType_TRIANGLE = 4;
    public static final int aiPrimitiveType_POLYGON = 8;
    public static final int aiPrimitiveType_NGONEncodingFlag = 16;
    public static final int aiMorphingMethod_VERTEX_BLEND = 1;
    public static final int aiMorphingMethod_MORPH_NORMALIZED = 2;
    public static final int aiMorphingMethod_MORPH_RELATIVE = 3;
    public static final int AI_BOOL = 0;
    public static final int AI_INT32 = 1;
    public static final int AI_UINT64 = 2;
    public static final int AI_FLOAT = 3;
    public static final int AI_DOUBLE = 4;
    public static final int AI_AISTRING = 5;
    public static final int AI_AIVECTOR3D = 6;
    public static final int AI_AIMETADATA = 7;
    public static final int AI_META_MAX = 8;
    public static final String AI_METADATA_SOURCE_FORMAT = "SourceAsset_Format";
    public static final String AI_METADATA_SOURCE_FORMAT_VERSION = "SourceAsset_FormatVersion";
    public static final String AI_METADATA_SOURCE_GENERATOR = "SourceAsset_Generator";
    public static final String AI_METADATA_SOURCE_COPYRIGHT = "SourceAsset_Copyright";
    public static final int aiProcess_CalcTangentSpace = 1;
    public static final int aiProcess_JoinIdenticalVertices = 2;
    public static final int aiProcess_MakeLeftHanded = 4;
    public static final int aiProcess_Triangulate = 8;
    public static final int aiProcess_RemoveComponent = 16;
    public static final int aiProcess_GenNormals = 32;
    public static final int aiProcess_GenSmoothNormals = 64;
    public static final int aiProcess_SplitLargeMeshes = 128;
    public static final int aiProcess_PreTransformVertices = 256;
    public static final int aiProcess_LimitBoneWeights = 512;
    public static final int aiProcess_ValidateDataStructure = 1024;
    public static final int aiProcess_ImproveCacheLocality = 2048;
    public static final int aiProcess_RemoveRedundantMaterials = 4096;
    public static final int aiProcess_FixInfacingNormals = 8192;
    public static final int aiProcess_PopulateArmatureData = 16384;
    public static final int aiProcess_SortByPType = 32768;
    public static final int aiProcess_FindDegenerates = 65536;
    public static final int aiProcess_FindInvalidData = 131072;
    public static final int aiProcess_GenUVCoords = 262144;
    public static final int aiProcess_TransformUVCoords = 524288;
    public static final int aiProcess_FindInstances = 0x100000;
    public static final int aiProcess_OptimizeMeshes = 0x200000;
    public static final int aiProcess_OptimizeGraph = 0x400000;
    public static final int aiProcess_FlipUVs = 0x800000;
    public static final int aiProcess_FlipWindingOrder = 0x1000000;
    public static final int aiProcess_SplitByBoneCount = 0x2000000;
    public static final int aiProcess_Debone = 0x4000000;
    public static final int aiProcess_GlobalScale = 0x8000000;
    public static final int aiProcess_EmbedTextures = 0x10000000;
    public static final int aiProcess_ForceGenNormals = 0x20000000;
    public static final int aiProcess_DropNormals = 0x40000000;
    public static final int aiProcess_GenBoundingBoxes = Integer.MIN_VALUE;
    public static final int aiProcess_ConvertToLeftHanded = 25165828;
    public static final int aiProcessPreset_TargetRealtime_Fast = 294955;
    public static final int aiProcessPreset_TargetRealtime_Quality = 498379;
    public static final int aiProcessPreset_TargetRealtime_MaxQuality = 3644107;
    public static final int AI_SCENE_FLAGS_INCOMPLETE = 1;
    public static final int AI_SCENE_FLAGS_VALIDATED = 2;
    public static final int AI_SCENE_FLAGS_VALIDATION_WARNING = 4;
    public static final int AI_SCENE_FLAGS_NON_VERBOSE_FORMAT = 8;
    public static final int AI_SCENE_FLAGS_TERRAIN = 16;
    public static final int ASSIMP_CFLAGS_SHARED = 1;
    public static final int ASSIMP_CFLAGS_STLPORT = 2;
    public static final int ASSIMP_CFLAGS_DEBUG = 4;
    public static final int ASSIMP_CFLAGS_NOBOOST = 8;
    public static final int ASSIMP_CFLAGS_SINGLETHREADED = 16;
    public static final int ASSIMP_CFLAGS_DOUBLE_SUPPORT = 16;
    private static final long GetPredefinedLogStream = ASSIMP.getFunctionAddress((CharSequence)"aiGetPredefinedLogStream");
    private static final FFICIF GetPredefinedLogStreamCIF = APIUtil.apiCreateCIF((int)LibFFI.FFI_DEFAULT_ABI, (FFIType)APIUtil.apiCreateStruct((FFIType[])new FFIType[]{LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer}), (FFIType[])new FFIType[]{LibFFI.ffi_type_uint32, LibFFI.ffi_type_pointer});

    public static SharedLibrary getLibrary() {
        return ASSIMP;
    }

    protected Assimp() {
        throw new UnsupportedOperationException();
    }

    public static int aiComponent_COLORSn(int n) {
        return 1 << n + 20;
    }

    public static int aiComponent_TEXCOORDSn(int n) {
        return 1 << n + 25;
    }

    public static float AI_DEG_TO_RAD(float x) {
        return x * ((float)Math.PI / 180);
    }

    public static float AI_RAD_TO_DEG(float x) {
        return x * 57.29578f;
    }

    @NativeType(value="size_t")
    public static long aiGetExportFormatCount() {
        long __functionAddress = Functions.GetExportFormatCount;
        return JNI.invokeP((long)__functionAddress);
    }

    public static long naiGetExportFormatDescription(long pIndex) {
        long __functionAddress = Functions.GetExportFormatDescription;
        return JNI.invokePP((long)pIndex, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiExportFormatDesc *")
    public static AIExportFormatDesc aiGetExportFormatDescription(@NativeType(value="size_t") long pIndex) {
        long __result = Assimp.naiGetExportFormatDescription(pIndex);
        return AIExportFormatDesc.createSafe(__result);
    }

    public static void naiReleaseExportFormatDescription(long desc) {
        long __functionAddress = Functions.ReleaseExportFormatDescription;
        if (Checks.CHECKS) {
            AIExportFormatDesc.validate(desc);
        }
        JNI.invokePV((long)desc, (long)__functionAddress);
    }

    public static void aiReleaseExportFormatDescription(@NativeType(value="struct aiExportFormatDesc const *") AIExportFormatDesc desc) {
        Assimp.naiReleaseExportFormatDescription(desc.address());
    }

    public static void naiCopyScene(long pIn, long pOut) {
        long __functionAddress = Functions.CopyScene;
        if (Checks.CHECKS) {
            AIScene.validate(pIn);
        }
        JNI.invokePPV((long)pIn, (long)pOut, (long)__functionAddress);
    }

    public static void aiCopyScene(@NativeType(value="struct aiScene const *") AIScene pIn, @NativeType(value="struct aiScene **") PointerBuffer pOut) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pOut, (int)1);
        }
        Assimp.naiCopyScene(pIn.address(), MemoryUtil.memAddress((CustomBuffer)pOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="void")
    public static AIScene aiCopyScene(@NativeType(value="struct aiScene const *") AIScene pIn) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pOut = stack.callocPointer(1);
            Assimp.naiCopyScene(pIn.address(), MemoryUtil.memAddress((CustomBuffer)pOut));
            AIScene aIScene = AIScene.createSafe(pOut.get(0));
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiFreeScene(long pIn) {
        long __functionAddress = Functions.FreeScene;
        if (Checks.CHECKS) {
            AIScene.validate(pIn);
        }
        JNI.invokePV((long)pIn, (long)__functionAddress);
    }

    public static void aiFreeScene(@NativeType(value="struct aiScene const *") AIScene pIn) {
        Assimp.naiFreeScene(pIn.address());
    }

    public static int naiExportScene(long pScene, long pFormatId, long pFileName, int pPreProcessing) {
        long __functionAddress = Functions.ExportScene;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
        }
        return JNI.invokePPPI((long)pScene, (long)pFormatId, (long)pFileName, (int)pPreProcessing, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiExportScene(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") ByteBuffer pFormatId, @NativeType(value="char const *") ByteBuffer pFileName, @NativeType(value="unsigned int") int pPreProcessing) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pFormatId);
            Checks.checkNT1((ByteBuffer)pFileName);
        }
        return Assimp.naiExportScene(pScene.address(), MemoryUtil.memAddress((ByteBuffer)pFormatId), MemoryUtil.memAddress((ByteBuffer)pFileName), pPreProcessing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiExportScene(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") CharSequence pFormatId, @NativeType(value="char const *") CharSequence pFileName, @NativeType(value="unsigned int") int pPreProcessing) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pFormatId, true);
            long pFormatIdEncoded = stack.getPointerAddress();
            stack.nUTF8(pFileName, true);
            long pFileNameEncoded = stack.getPointerAddress();
            int n = Assimp.naiExportScene(pScene.address(), pFormatIdEncoded, pFileNameEncoded, pPreProcessing);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiExportSceneEx(long pScene, long pFormatId, long pFileName, long pIO, int pPreProcessing) {
        long __functionAddress = Functions.ExportSceneEx;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
            if (pIO != 0L) {
                AIFileIO.validate(pIO);
            }
        }
        return JNI.invokePPPPI((long)pScene, (long)pFormatId, (long)pFileName, (long)pIO, (int)pPreProcessing, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiExportSceneEx(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") ByteBuffer pFormatId, @NativeType(value="char const *") ByteBuffer pFileName, @Nullable @NativeType(value="struct aiFileIO const *") AIFileIO pIO, @NativeType(value="unsigned int") int pPreProcessing) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pFormatId);
            Checks.checkNT1((ByteBuffer)pFileName);
        }
        return Assimp.naiExportSceneEx(pScene.address(), MemoryUtil.memAddress((ByteBuffer)pFormatId), MemoryUtil.memAddress((ByteBuffer)pFileName), MemoryUtil.memAddressSafe((Pointer)pIO), pPreProcessing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiExportSceneEx(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") CharSequence pFormatId, @NativeType(value="char const *") CharSequence pFileName, @Nullable @NativeType(value="struct aiFileIO const *") AIFileIO pIO, @NativeType(value="unsigned int") int pPreProcessing) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pFormatId, true);
            long pFormatIdEncoded = stack.getPointerAddress();
            stack.nUTF8(pFileName, true);
            long pFileNameEncoded = stack.getPointerAddress();
            int n = Assimp.naiExportSceneEx(pScene.address(), pFormatIdEncoded, pFileNameEncoded, MemoryUtil.memAddressSafe((Pointer)pIO), pPreProcessing);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiExportSceneToBlob(long pScene, long pFormatId, int pPreProcessing) {
        long __functionAddress = Functions.ExportSceneToBlob;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
        }
        return JNI.invokePPP((long)pScene, (long)pFormatId, (int)pPreProcessing, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiExportDataBlob *")
    public static AIExportDataBlob aiExportSceneToBlob(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") ByteBuffer pFormatId, @NativeType(value="unsigned int") int pPreProcessing) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pFormatId);
        }
        long __result = Assimp.naiExportSceneToBlob(pScene.address(), MemoryUtil.memAddress((ByteBuffer)pFormatId), pPreProcessing);
        return AIExportDataBlob.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiExportDataBlob *")
    public static AIExportDataBlob aiExportSceneToBlob(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") CharSequence pFormatId, @NativeType(value="unsigned int") int pPreProcessing) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pFormatId, true);
            long pFormatIdEncoded = stack.getPointerAddress();
            long __result = Assimp.naiExportSceneToBlob(pScene.address(), pFormatIdEncoded, pPreProcessing);
            AIExportDataBlob aIExportDataBlob = AIExportDataBlob.createSafe(__result);
            return aIExportDataBlob;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiReleaseExportBlob(long pData) {
        long __functionAddress = Functions.ReleaseExportBlob;
        if (Checks.CHECKS) {
            AIExportDataBlob.validate(pData);
        }
        JNI.invokePV((long)pData, (long)__functionAddress);
    }

    public static void aiReleaseExportBlob(@NativeType(value="struct aiExportDataBlob const *") AIExportDataBlob pData) {
        Assimp.naiReleaseExportBlob(pData.address());
    }

    public static long naiImportFile(long pFile, int pFlags) {
        long __functionAddress = Functions.ImportFile;
        return JNI.invokePP((long)pFile, (int)pFlags, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFile(@NativeType(value="char const *") ByteBuffer pFile, @NativeType(value="unsigned int") int pFlags) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pFile);
        }
        long __result = Assimp.naiImportFile(MemoryUtil.memAddress((ByteBuffer)pFile), pFlags);
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFile(@NativeType(value="char const *") CharSequence pFile, @NativeType(value="unsigned int") int pFlags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pFile, true);
            long pFileEncoded = stack.getPointerAddress();
            long __result = Assimp.naiImportFile(pFileEncoded, pFlags);
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileEx(long pFile, int pFlags, long pFS) {
        long __functionAddress = Functions.ImportFileEx;
        if (Checks.CHECKS && pFS != 0L) {
            AIFileIO.validate(pFS);
        }
        return JNI.invokePPP((long)pFile, (int)pFlags, (long)pFS, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileEx(@NativeType(value="char const *") ByteBuffer pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pFile);
        }
        long __result = Assimp.naiImportFileEx(MemoryUtil.memAddress((ByteBuffer)pFile), pFlags, MemoryUtil.memAddressSafe((Pointer)pFS));
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileEx(@NativeType(value="char const *") CharSequence pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pFile, true);
            long pFileEncoded = stack.getPointerAddress();
            long __result = Assimp.naiImportFileEx(pFileEncoded, pFlags, MemoryUtil.memAddressSafe((Pointer)pFS));
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileExWithProperties(long pFile, int pFlags, long pFS, long pProps) {
        long __functionAddress = Functions.ImportFileExWithProperties;
        if (Checks.CHECKS && pFS != 0L) {
            AIFileIO.validate(pFS);
        }
        return JNI.invokePPPP((long)pFile, (int)pFlags, (long)pFS, (long)pProps, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileExWithProperties(@NativeType(value="char const *") ByteBuffer pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pFile);
        }
        long __result = Assimp.naiImportFileExWithProperties(MemoryUtil.memAddress((ByteBuffer)pFile), pFlags, MemoryUtil.memAddressSafe((Pointer)pFS), pProps.address());
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileExWithProperties(@NativeType(value="char const *") CharSequence pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pFile, true);
            long pFileEncoded = stack.getPointerAddress();
            long __result = Assimp.naiImportFileExWithProperties(pFileEncoded, pFlags, MemoryUtil.memAddressSafe((Pointer)pFS), pProps.address());
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileFromMemory(long pBuffer, int pLength, int pFlags, long pHint) {
        long __functionAddress = Functions.ImportFileFromMemory;
        return JNI.invokePPP((long)pBuffer, (int)pLength, (int)pFlags, (long)pHint, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemory(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") ByteBuffer pHint) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)pHint);
        }
        long __result = Assimp.naiImportFileFromMemory(MemoryUtil.memAddress((ByteBuffer)pBuffer), pBuffer.remaining(), pFlags, MemoryUtil.memAddressSafe((ByteBuffer)pHint));
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemory(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") CharSequence pHint) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(pHint, true);
            long pHintEncoded = pHint == null ? 0L : stack.getPointerAddress();
            long __result = Assimp.naiImportFileFromMemory(MemoryUtil.memAddress((ByteBuffer)pBuffer), pBuffer.remaining(), pFlags, pHintEncoded);
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileFromMemoryWithProperties(long pBuffer, int pLength, int pFlags, long pHint, long pProps) {
        long __functionAddress = Functions.ImportFileFromMemoryWithProperties;
        return JNI.invokePPPP((long)pBuffer, (int)pLength, (int)pFlags, (long)pHint, (long)pProps, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemoryWithProperties(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") ByteBuffer pHint, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)pHint);
        }
        long __result = Assimp.naiImportFileFromMemoryWithProperties(MemoryUtil.memAddress((ByteBuffer)pBuffer), pBuffer.remaining(), pFlags, MemoryUtil.memAddressSafe((ByteBuffer)pHint), pProps.address());
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemoryWithProperties(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") CharSequence pHint, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(pHint, true);
            long pHintEncoded = pHint == null ? 0L : stack.getPointerAddress();
            long __result = Assimp.naiImportFileFromMemoryWithProperties(MemoryUtil.memAddress((ByteBuffer)pBuffer), pBuffer.remaining(), pFlags, pHintEncoded, pProps.address());
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiApplyPostProcessing(long pScene, int pFlags) {
        long __functionAddress = Functions.ApplyPostProcessing;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
        }
        return JNI.invokePP((long)pScene, (int)pFlags, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiApplyPostProcessing(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="unsigned int") int pFlags) {
        long __result = Assimp.naiApplyPostProcessing(pScene.address(), pFlags);
        return AIScene.createSafe(__result);
    }

    public static void naiAttachLogStream(long stream) {
        long __functionAddress = Functions.AttachLogStream;
        if (Checks.CHECKS) {
            AILogStream.validate(stream);
        }
        JNI.invokePV((long)stream, (long)__functionAddress);
    }

    public static void aiAttachLogStream(@NativeType(value="struct aiLogStream const *") AILogStream stream) {
        Assimp.naiAttachLogStream(stream.address());
    }

    public static void aiEnableVerboseLogging(@NativeType(value="aiBool") boolean d) {
        long __functionAddress = Functions.EnableVerboseLogging;
        JNI.invokeV((int)(d ? 1 : 0), (long)__functionAddress);
    }

    public static int naiDetachLogStream(long stream) {
        long __functionAddress = Functions.DetachLogStream;
        if (Checks.CHECKS) {
            AILogStream.validate(stream);
        }
        return JNI.invokePI((long)stream, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiDetachLogStream(@NativeType(value="struct aiLogStream const *") AILogStream stream) {
        return Assimp.naiDetachLogStream(stream.address());
    }

    public static void aiDetachAllLogStreams() {
        long __functionAddress = Functions.DetachAllLogStreams;
        JNI.invokeV((long)__functionAddress);
    }

    public static void naiReleaseImport(long pScene) {
        long __functionAddress = Functions.ReleaseImport;
        if (Checks.CHECKS && pScene != 0L) {
            AIScene.validate(pScene);
        }
        JNI.invokePV((long)pScene, (long)__functionAddress);
    }

    public static void aiReleaseImport(@Nullable @NativeType(value="struct aiScene const *") AIScene pScene) {
        Assimp.naiReleaseImport(MemoryUtil.memAddressSafe((Pointer)pScene));
    }

    public static long naiGetErrorString() {
        long __functionAddress = Functions.GetErrorString;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String aiGetErrorString() {
        long __result = Assimp.naiGetErrorString();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int naiIsExtensionSupported(long szExtension) {
        long __functionAddress = Functions.IsExtensionSupported;
        return JNI.invokePI((long)szExtension, (long)__functionAddress);
    }

    @NativeType(value="aiBool")
    public static boolean aiIsExtensionSupported(@NativeType(value="char const *") ByteBuffer szExtension) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)szExtension);
        }
        return Assimp.naiIsExtensionSupported(MemoryUtil.memAddress((ByteBuffer)szExtension)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiBool")
    public static boolean aiIsExtensionSupported(@NativeType(value="char const *") CharSequence szExtension) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(szExtension, true);
            long szExtensionEncoded = stack.getPointerAddress();
            boolean bl = Assimp.naiIsExtensionSupported(szExtensionEncoded) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiGetExtensionList(long szOut) {
        long __functionAddress = Functions.GetExtensionList;
        JNI.invokePV((long)szOut, (long)__functionAddress);
    }

    public static void aiGetExtensionList(@NativeType(value="struct aiString *") AIString szOut) {
        Assimp.naiGetExtensionList(szOut.address());
    }

    public static void naiGetMemoryRequirements(long pIn, long in) {
        long __functionAddress = Functions.GetMemoryRequirements;
        if (Checks.CHECKS) {
            AIScene.validate(pIn);
        }
        JNI.invokePPV((long)pIn, (long)in, (long)__functionAddress);
    }

    public static void aiGetMemoryRequirements(@NativeType(value="struct aiScene const *") AIScene pIn, @NativeType(value="struct aiMemoryInfo *") AIMemoryInfo in) {
        Assimp.naiGetMemoryRequirements(pIn.address(), in.address());
    }

    public static long naiCreatePropertyStore() {
        long __functionAddress = Functions.CreatePropertyStore;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiPropertyStore *")
    public static AIPropertyStore aiCreatePropertyStore() {
        long __result = Assimp.naiCreatePropertyStore();
        return AIPropertyStore.createSafe(__result);
    }

    public static void naiReleasePropertyStore(long p) {
        long __functionAddress = Functions.ReleasePropertyStore;
        JNI.invokePV((long)p, (long)__functionAddress);
    }

    public static void aiReleasePropertyStore(@NativeType(value="struct aiPropertyStore *") AIPropertyStore p) {
        Assimp.naiReleasePropertyStore(p.address());
    }

    public static void naiSetImportPropertyInteger(long store, long szName, int value) {
        long __functionAddress = Functions.SetImportPropertyInteger;
        JNI.invokePPV((long)store, (long)szName, (int)value, (long)__functionAddress);
    }

    public static void aiSetImportPropertyInteger(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, int value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)szName);
        }
        Assimp.naiSetImportPropertyInteger(store.address(), MemoryUtil.memAddress((ByteBuffer)szName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyInteger(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, int value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(szName, true);
            long szNameEncoded = stack.getPointerAddress();
            Assimp.naiSetImportPropertyInteger(store.address(), szNameEncoded, value);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiSetImportPropertyFloat(long store, long szName, float value) {
        long __functionAddress = Functions.SetImportPropertyFloat;
        JNI.invokePPV((long)store, (long)szName, (float)value, (long)__functionAddress);
    }

    public static void aiSetImportPropertyFloat(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, float value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)szName);
        }
        Assimp.naiSetImportPropertyFloat(store.address(), MemoryUtil.memAddress((ByteBuffer)szName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyFloat(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, float value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(szName, true);
            long szNameEncoded = stack.getPointerAddress();
            Assimp.naiSetImportPropertyFloat(store.address(), szNameEncoded, value);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiSetImportPropertyString(long store, long szName, long value) {
        long __functionAddress = Functions.SetImportPropertyString;
        JNI.invokePPPV((long)store, (long)szName, (long)value, (long)__functionAddress);
    }

    public static void aiSetImportPropertyString(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, @NativeType(value="struct aiString const *") AIString value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)szName);
        }
        Assimp.naiSetImportPropertyString(store.address(), MemoryUtil.memAddress((ByteBuffer)szName), value.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyString(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, @NativeType(value="struct aiString const *") AIString value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(szName, true);
            long szNameEncoded = stack.getPointerAddress();
            Assimp.naiSetImportPropertyString(store.address(), szNameEncoded, value.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiSetImportPropertyMatrix(long store, long szName, long value) {
        long __functionAddress = Functions.SetImportPropertyMatrix;
        JNI.invokePPPV((long)store, (long)szName, (long)value, (long)__functionAddress);
    }

    public static void aiSetImportPropertyMatrix(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)szName);
        }
        Assimp.naiSetImportPropertyMatrix(store.address(), MemoryUtil.memAddress((ByteBuffer)szName), value.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyMatrix(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(szName, true);
            long szNameEncoded = stack.getPointerAddress();
            Assimp.naiSetImportPropertyMatrix(store.address(), szNameEncoded, value.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiCreateQuaternionFromMatrix(long quat, long mat) {
        long __functionAddress = Functions.CreateQuaternionFromMatrix;
        JNI.invokePPV((long)quat, (long)mat, (long)__functionAddress);
    }

    public static void aiCreateQuaternionFromMatrix(@NativeType(value="struct aiQuaternion *") AIQuaternion quat, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 mat) {
        Assimp.naiCreateQuaternionFromMatrix(quat.address(), mat.address());
    }

    public static void naiDecomposeMatrix(long mat, long scaling, long rotation, long position) {
        long __functionAddress = Functions.DecomposeMatrix;
        JNI.invokePPPPV((long)mat, (long)scaling, (long)rotation, (long)position, (long)__functionAddress);
    }

    public static void aiDecomposeMatrix(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D *") AIVector3D scaling, @NativeType(value="struct aiQuaternion *") AIQuaternion rotation, @NativeType(value="struct aiVector3D *") AIVector3D position) {
        Assimp.naiDecomposeMatrix(mat.address(), scaling.address(), rotation.address(), position.address());
    }

    public static void naiTransposeMatrix4(long mat) {
        long __functionAddress = Functions.TransposeMatrix4;
        JNI.invokePV((long)mat, (long)__functionAddress);
    }

    public static void aiTransposeMatrix4(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat) {
        Assimp.naiTransposeMatrix4(mat.address());
    }

    public static void naiTransposeMatrix3(long mat) {
        long __functionAddress = Functions.TransposeMatrix3;
        JNI.invokePV((long)mat, (long)__functionAddress);
    }

    public static void aiTransposeMatrix3(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat) {
        Assimp.naiTransposeMatrix3(mat.address());
    }

    public static void naiTransformVecByMatrix3(long vec, long mat) {
        long __functionAddress = Functions.TransformVecByMatrix3;
        JNI.invokePPV((long)vec, (long)mat, (long)__functionAddress);
    }

    public static void aiTransformVecByMatrix3(@NativeType(value="struct aiVector3D *") AIVector3D vec, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 mat) {
        Assimp.naiTransformVecByMatrix3(vec.address(), mat.address());
    }

    public static void naiTransformVecByMatrix4(long vec, long mat) {
        long __functionAddress = Functions.TransformVecByMatrix4;
        JNI.invokePPV((long)vec, (long)mat, (long)__functionAddress);
    }

    public static void aiTransformVecByMatrix4(@NativeType(value="struct aiVector3D *") AIVector3D vec, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat) {
        Assimp.naiTransformVecByMatrix4(vec.address(), mat.address());
    }

    public static void naiMultiplyMatrix4(long dst, long src) {
        long __functionAddress = Functions.MultiplyMatrix4;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiMultiplyMatrix4(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 dst, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 src) {
        Assimp.naiMultiplyMatrix4(dst.address(), src.address());
    }

    public static void naiMultiplyMatrix3(long dst, long src) {
        long __functionAddress = Functions.MultiplyMatrix3;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiMultiplyMatrix3(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 dst, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 src) {
        Assimp.naiMultiplyMatrix3(dst.address(), src.address());
    }

    public static void naiIdentityMatrix3(long mat) {
        long __functionAddress = Functions.IdentityMatrix3;
        JNI.invokePV((long)mat, (long)__functionAddress);
    }

    public static void aiIdentityMatrix3(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat) {
        Assimp.naiIdentityMatrix3(mat.address());
    }

    public static void naiIdentityMatrix4(long mat) {
        long __functionAddress = Functions.IdentityMatrix4;
        JNI.invokePV((long)mat, (long)__functionAddress);
    }

    public static void aiIdentityMatrix4(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat) {
        Assimp.naiIdentityMatrix4(mat.address());
    }

    @NativeType(value="size_t")
    public static long aiGetImportFormatCount() {
        long __functionAddress = Functions.GetImportFormatCount;
        return JNI.invokeP((long)__functionAddress);
    }

    public static long naiGetImportFormatDescription(long pIndex) {
        long __functionAddress = Functions.GetImportFormatDescription;
        return JNI.invokePP((long)pIndex, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiImporterDesc *")
    public static AIImporterDesc aiGetImportFormatDescription(@NativeType(value="size_t") long pIndex) {
        long __result = Assimp.naiGetImportFormatDescription(pIndex);
        return AIImporterDesc.createSafe(__result);
    }

    public static int naiVector2AreEqual(long a, long b) {
        long __functionAddress = Functions.Vector2AreEqual;
        return JNI.invokePPI((long)a, (long)b, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiVector2AreEqual(@NativeType(value="struct aiVector2D const *") AIVector2D a, @NativeType(value="struct aiVector2D const *") AIVector2D b) {
        return Assimp.naiVector2AreEqual(a.address(), b.address()) != 0;
    }

    public static int naiVector2AreEqualEpsilon(long a, long b, float epsilon) {
        long __functionAddress = Functions.Vector2AreEqualEpsilon;
        return JNI.invokePPI((long)a, (long)b, (float)epsilon, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiVector2AreEqualEpsilon(@NativeType(value="struct aiVector2D const *") AIVector2D a, @NativeType(value="struct aiVector2D const *") AIVector2D b, float epsilon) {
        return Assimp.naiVector2AreEqualEpsilon(a.address(), b.address(), epsilon) != 0;
    }

    public static void naiVector2Add(long dst, long src) {
        long __functionAddress = Functions.Vector2Add;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiVector2Add(@NativeType(value="struct aiVector2D *") AIVector2D dst, @NativeType(value="struct aiVector2D const *") AIVector2D src) {
        Assimp.naiVector2Add(dst.address(), src.address());
    }

    public static void naiVector2Subtract(long dst, long src) {
        long __functionAddress = Functions.Vector2Subtract;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiVector2Subtract(@NativeType(value="struct aiVector2D *") AIVector2D dst, @NativeType(value="struct aiVector2D const *") AIVector2D src) {
        Assimp.naiVector2Subtract(dst.address(), src.address());
    }

    public static void naiVector2Scale(long dst, float s) {
        long __functionAddress = Functions.Vector2Scale;
        JNI.invokePV((long)dst, (float)s, (long)__functionAddress);
    }

    public static void aiVector2Scale(@NativeType(value="struct aiVector2D *") AIVector2D dst, float s) {
        Assimp.naiVector2Scale(dst.address(), s);
    }

    public static void naiVector2SymMul(long dst, long other) {
        long __functionAddress = Functions.Vector2SymMul;
        JNI.invokePPV((long)dst, (long)other, (long)__functionAddress);
    }

    public static void aiVector2SymMul(@NativeType(value="struct aiVector2D *") AIVector2D dst, @NativeType(value="struct aiVector2D const *") AIVector2D other) {
        Assimp.naiVector2SymMul(dst.address(), other.address());
    }

    public static void naiVector2DivideByScalar(long dst, float s) {
        long __functionAddress = Functions.Vector2DivideByScalar;
        JNI.invokePV((long)dst, (float)s, (long)__functionAddress);
    }

    public static void aiVector2DivideByScalar(@NativeType(value="struct aiVector2D *") AIVector2D dst, float s) {
        Assimp.naiVector2DivideByScalar(dst.address(), s);
    }

    public static void naiVector2DivideByVector(long dst, long v) {
        long __functionAddress = Functions.Vector2DivideByVector;
        JNI.invokePPV((long)dst, (long)v, (long)__functionAddress);
    }

    public static void aiVector2DivideByVector(@NativeType(value="struct aiVector2D *") AIVector2D dst, @NativeType(value="struct aiVector2D *") AIVector2D v) {
        Assimp.naiVector2DivideByVector(dst.address(), v.address());
    }

    public static float naiVector2Length(long v) {
        long __functionAddress = Functions.Vector2Length;
        return JNI.invokePF((long)v, (long)__functionAddress);
    }

    public static float aiVector2Length(@NativeType(value="struct aiVector2D const *") AIVector2D v) {
        return Assimp.naiVector2Length(v.address());
    }

    public static float naiVector2SquareLength(long v) {
        long __functionAddress = Functions.Vector2SquareLength;
        return JNI.invokePF((long)v, (long)__functionAddress);
    }

    public static float aiVector2SquareLength(@NativeType(value="struct aiVector2D const *") AIVector2D v) {
        return Assimp.naiVector2SquareLength(v.address());
    }

    public static void naiVector2Negate(long dst) {
        long __functionAddress = Functions.Vector2Negate;
        JNI.invokePV((long)dst, (long)__functionAddress);
    }

    public static void aiVector2Negate(@NativeType(value="struct aiVector2D *") AIVector2D dst) {
        Assimp.naiVector2Negate(dst.address());
    }

    public static float naiVector2DotProduct(long a, long b) {
        long __functionAddress = Functions.Vector2DotProduct;
        return JNI.invokePPF((long)a, (long)b, (long)__functionAddress);
    }

    public static float aiVector2DotProduct(@NativeType(value="struct aiVector2D const *") AIVector2D a, @NativeType(value="struct aiVector2D const *") AIVector2D b) {
        return Assimp.naiVector2DotProduct(a.address(), b.address());
    }

    public static void naiVector2Normalize(long v) {
        long __functionAddress = Functions.Vector2Normalize;
        JNI.invokePV((long)v, (long)__functionAddress);
    }

    public static void aiVector2Normalize(@NativeType(value="struct aiVector2D *") AIVector2D v) {
        Assimp.naiVector2Normalize(v.address());
    }

    public static int naiVector3AreEqual(long a, long b) {
        long __functionAddress = Functions.Vector3AreEqual;
        return JNI.invokePPI((long)a, (long)b, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiVector3AreEqual(@NativeType(value="struct aiVector3D const *") AIVector3D a, @NativeType(value="struct aiVector3D const *") AIVector3D b) {
        return Assimp.naiVector3AreEqual(a.address(), b.address()) != 0;
    }

    public static int naiVector3AreEqualEpsilon(long a, long b, float epsilon) {
        long __functionAddress = Functions.Vector3AreEqualEpsilon;
        return JNI.invokePPI((long)a, (long)b, (float)epsilon, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiVector3AreEqualEpsilon(@NativeType(value="struct aiVector3D const *") AIVector3D a, @NativeType(value="struct aiVector3D const *") AIVector3D b, @NativeType(value="float const") float epsilon) {
        return Assimp.naiVector3AreEqualEpsilon(a.address(), b.address(), epsilon) != 0;
    }

    public static int naiVector3LessThan(long a, long b) {
        long __functionAddress = Functions.Vector3LessThan;
        return JNI.invokePPI((long)a, (long)b, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiVector3LessThan(@NativeType(value="struct aiVector3D const *") AIVector3D a, @NativeType(value="struct aiVector3D const *") AIVector3D b) {
        return Assimp.naiVector3LessThan(a.address(), b.address()) != 0;
    }

    public static void naiVector3Add(long dst, long src) {
        long __functionAddress = Functions.Vector3Add;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiVector3Add(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="struct aiVector3D const *") AIVector3D src) {
        Assimp.naiVector3Add(dst.address(), src.address());
    }

    public static void naiVector3Subtract(long dst, long src) {
        long __functionAddress = Functions.Vector3Subtract;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiVector3Subtract(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="struct aiVector3D const *") AIVector3D src) {
        Assimp.naiVector3Subtract(dst.address(), src.address());
    }

    public static void naiVector3Scale(long dst, float s) {
        long __functionAddress = Functions.Vector3Scale;
        JNI.invokePV((long)dst, (float)s, (long)__functionAddress);
    }

    public static void aiVector3Scale(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="float const") float s) {
        Assimp.naiVector3Scale(dst.address(), s);
    }

    public static void naiVector3SymMul(long dst, long other) {
        long __functionAddress = Functions.Vector3SymMul;
        JNI.invokePPV((long)dst, (long)other, (long)__functionAddress);
    }

    public static void aiVector3SymMul(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="struct aiVector3D const *") AIVector3D other) {
        Assimp.naiVector3SymMul(dst.address(), other.address());
    }

    public static void naiVector3DivideByScalar(long dst, float s) {
        long __functionAddress = Functions.Vector3DivideByScalar;
        JNI.invokePV((long)dst, (float)s, (long)__functionAddress);
    }

    public static void aiVector3DivideByScalar(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="float const") float s) {
        Assimp.naiVector3DivideByScalar(dst.address(), s);
    }

    public static void naiVector3DivideByVector(long dst, long v) {
        long __functionAddress = Functions.Vector3DivideByVector;
        JNI.invokePPV((long)dst, (long)v, (long)__functionAddress);
    }

    public static void aiVector3DivideByVector(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="struct aiVector3D *") AIVector3D v) {
        Assimp.naiVector3DivideByVector(dst.address(), v.address());
    }

    public static float naiVector3Length(long v) {
        long __functionAddress = Functions.Vector3Length;
        return JNI.invokePF((long)v, (long)__functionAddress);
    }

    public static float aiVector3Length(@NativeType(value="struct aiVector3D const *") AIVector3D v) {
        return Assimp.naiVector3Length(v.address());
    }

    public static float naiVector3SquareLength(long v) {
        long __functionAddress = Functions.Vector3SquareLength;
        return JNI.invokePF((long)v, (long)__functionAddress);
    }

    public static float aiVector3SquareLength(@NativeType(value="struct aiVector3D const *") AIVector3D v) {
        return Assimp.naiVector3SquareLength(v.address());
    }

    public static void naiVector3Negate(long dst) {
        long __functionAddress = Functions.Vector3Negate;
        JNI.invokePV((long)dst, (long)__functionAddress);
    }

    public static void aiVector3Negate(@NativeType(value="struct aiVector3D *") AIVector3D dst) {
        Assimp.naiVector3Negate(dst.address());
    }

    public static float naiVector3DotProduct(long a, long b) {
        long __functionAddress = Functions.Vector3DotProduct;
        return JNI.invokePPF((long)a, (long)b, (long)__functionAddress);
    }

    public static float aiVector3DotProduct(@NativeType(value="struct aiVector3D const *") AIVector3D a, @NativeType(value="struct aiVector3D const *") AIVector3D b) {
        return Assimp.naiVector3DotProduct(a.address(), b.address());
    }

    public static void naiVector3CrossProduct(long dst, long a, long b) {
        long __functionAddress = Functions.Vector3CrossProduct;
        JNI.invokePPPV((long)dst, (long)a, (long)b, (long)__functionAddress);
    }

    public static void aiVector3CrossProduct(@NativeType(value="struct aiVector3D *") AIVector3D dst, @NativeType(value="struct aiVector3D const *") AIVector3D a, @NativeType(value="struct aiVector3D const *") AIVector3D b) {
        Assimp.naiVector3CrossProduct(dst.address(), a.address(), b.address());
    }

    public static void naiVector3Normalize(long v) {
        long __functionAddress = Functions.Vector3Normalize;
        JNI.invokePV((long)v, (long)__functionAddress);
    }

    public static void aiVector3Normalize(@NativeType(value="struct aiVector3D *") AIVector3D v) {
        Assimp.naiVector3Normalize(v.address());
    }

    public static void naiVector3NormalizeSafe(long v) {
        long __functionAddress = Functions.Vector3NormalizeSafe;
        JNI.invokePV((long)v, (long)__functionAddress);
    }

    public static void aiVector3NormalizeSafe(@NativeType(value="struct aiVector3D *") AIVector3D v) {
        Assimp.naiVector3NormalizeSafe(v.address());
    }

    public static void naiVector3RotateByQuaternion(long v, long q) {
        long __functionAddress = Functions.Vector3RotateByQuaternion;
        JNI.invokePPV((long)v, (long)q, (long)__functionAddress);
    }

    public static void aiVector3RotateByQuaternion(@NativeType(value="struct aiVector3D *") AIVector3D v, @NativeType(value="struct aiQuaternion const *") AIQuaternion q) {
        Assimp.naiVector3RotateByQuaternion(v.address(), q.address());
    }

    public static void naiMatrix3FromMatrix4(long dst, long mat) {
        long __functionAddress = Functions.Matrix3FromMatrix4;
        JNI.invokePPV((long)dst, (long)mat, (long)__functionAddress);
    }

    public static void aiMatrix3FromMatrix4(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 dst, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat) {
        Assimp.naiMatrix3FromMatrix4(dst.address(), mat.address());
    }

    public static void naiMatrix3FromQuaternion(long mat, long q) {
        long __functionAddress = Functions.Matrix3FromQuaternion;
        JNI.invokePPV((long)mat, (long)q, (long)__functionAddress);
    }

    public static void aiMatrix3FromQuaternion(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat, @NativeType(value="struct aiQuaternion const *") AIQuaternion q) {
        Assimp.naiMatrix3FromQuaternion(mat.address(), q.address());
    }

    public static int naiMatrix3AreEqual(long a, long b) {
        long __functionAddress = Functions.Matrix3AreEqual;
        return JNI.invokePPI((long)a, (long)b, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiMatrix3AreEqual(@NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 a, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 b) {
        return Assimp.naiMatrix3AreEqual(a.address(), b.address()) != 0;
    }

    public static int naiMatrix3AreEqualEpsilon(long a, long b, float epsilon) {
        long __functionAddress = Functions.Matrix3AreEqualEpsilon;
        return JNI.invokePPI((long)a, (long)b, (float)epsilon, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiMatrix3AreEqualEpsilon(@NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 a, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 b, @NativeType(value="float const") float epsilon) {
        return Assimp.naiMatrix3AreEqualEpsilon(a.address(), b.address(), epsilon) != 0;
    }

    public static void naiMatrix3Inverse(long mat) {
        long __functionAddress = Functions.Matrix3Inverse;
        JNI.invokePV((long)mat, (long)__functionAddress);
    }

    public static void aiMatrix3Inverse(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat) {
        Assimp.naiMatrix3Inverse(mat.address());
    }

    public static float naiMatrix3Determinant(long mat) {
        long __functionAddress = Functions.Matrix3Determinant;
        return JNI.invokePF((long)mat, (long)__functionAddress);
    }

    public static float aiMatrix3Determinant(@NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 mat) {
        return Assimp.naiMatrix3Determinant(mat.address());
    }

    public static void naiMatrix3RotationZ(long mat, float angle) {
        long __functionAddress = Functions.Matrix3RotationZ;
        JNI.invokePV((long)mat, (float)angle, (long)__functionAddress);
    }

    public static void aiMatrix3RotationZ(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat, float angle) {
        Assimp.naiMatrix3RotationZ(mat.address(), angle);
    }

    public static void naiMatrix3FromRotationAroundAxis(long mat, long axis, float angle) {
        long __functionAddress = Functions.Matrix3FromRotationAroundAxis;
        JNI.invokePPV((long)mat, (long)axis, (float)angle, (long)__functionAddress);
    }

    public static void aiMatrix3FromRotationAroundAxis(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat, @NativeType(value="struct aiVector3D const *") AIVector3D axis, float angle) {
        Assimp.naiMatrix3FromRotationAroundAxis(mat.address(), axis.address(), angle);
    }

    public static void naiMatrix3Translation(long mat, long translation) {
        long __functionAddress = Functions.Matrix3Translation;
        JNI.invokePPV((long)mat, (long)translation, (long)__functionAddress);
    }

    public static void aiMatrix3Translation(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat, @NativeType(value="struct aiVector2D const *") AIVector2D translation) {
        Assimp.naiMatrix3Translation(mat.address(), translation.address());
    }

    public static void naiMatrix3FromTo(long mat, long from, long to) {
        long __functionAddress = Functions.Matrix3FromTo;
        JNI.invokePPPV((long)mat, (long)from, (long)to, (long)__functionAddress);
    }

    public static void aiMatrix3FromTo(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat, @NativeType(value="struct aiVector3D const *") AIVector3D from, @NativeType(value="struct aiVector3D const *") AIVector3D to) {
        Assimp.naiMatrix3FromTo(mat.address(), from.address(), to.address());
    }

    public static void naiMatrix4FromMatrix3(long dst, long mat) {
        long __functionAddress = Functions.Matrix4FromMatrix3;
        JNI.invokePPV((long)dst, (long)mat, (long)__functionAddress);
    }

    public static void aiMatrix4FromMatrix3(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 dst, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 mat) {
        Assimp.naiMatrix4FromMatrix3(dst.address(), mat.address());
    }

    public static void naiMatrix4FromScalingQuaternionPosition(long mat, long scaling, long rotation, long position) {
        long __functionAddress = Functions.Matrix4FromScalingQuaternionPosition;
        JNI.invokePPPPV((long)mat, (long)scaling, (long)rotation, (long)position, (long)__functionAddress);
    }

    public static void aiMatrix4FromScalingQuaternionPosition(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D const *") AIVector3D scaling, @NativeType(value="struct aiQuaternion const *") AIQuaternion rotation, @NativeType(value="struct aiVector3D const *") AIVector3D position) {
        Assimp.naiMatrix4FromScalingQuaternionPosition(mat.address(), scaling.address(), rotation.address(), position.address());
    }

    public static void naiMatrix4Add(long dst, long src) {
        long __functionAddress = Functions.Matrix4Add;
        JNI.invokePPV((long)dst, (long)src, (long)__functionAddress);
    }

    public static void aiMatrix4Add(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 dst, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 src) {
        Assimp.naiMatrix4Add(dst.address(), src.address());
    }

    public static int naiMatrix4AreEqual(long a, long b) {
        long __functionAddress = Functions.Matrix4AreEqual;
        return JNI.invokePPI((long)a, (long)b, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiMatrix4AreEqual(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 a, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 b) {
        return Assimp.naiMatrix4AreEqual(a.address(), b.address()) != 0;
    }

    public static int naiMatrix4AreEqualEpsilon(long a, long b, float epsilon) {
        long __functionAddress = Functions.Matrix4AreEqualEpsilon;
        return JNI.invokePPI((long)a, (long)b, (float)epsilon, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiMatrix4AreEqualEpsilon(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 a, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 b, @NativeType(value="float const") float epsilon) {
        return Assimp.naiMatrix4AreEqualEpsilon(a.address(), b.address(), epsilon) != 0;
    }

    public static void naiMatrix4Inverse(long mat) {
        long __functionAddress = Functions.Matrix4Inverse;
        JNI.invokePV((long)mat, (long)__functionAddress);
    }

    public static void aiMatrix4Inverse(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat) {
        Assimp.naiMatrix4Inverse(mat.address());
    }

    public static float naiMatrix4Determinant(long mat) {
        long __functionAddress = Functions.Matrix4Determinant;
        return JNI.invokePF((long)mat, (long)__functionAddress);
    }

    public static float aiMatrix4Determinant(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat) {
        return Assimp.naiMatrix4Determinant(mat.address());
    }

    public static int naiMatrix4IsIdentity(long mat) {
        long __functionAddress = Functions.Matrix4IsIdentity;
        return JNI.invokePI((long)mat, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiMatrix4IsIdentity(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat) {
        return Assimp.naiMatrix4IsIdentity(mat.address()) != 0;
    }

    public static void naiMatrix4DecomposeIntoScalingEulerAnglesPosition(long mat, long scaling, long rotation, long position) {
        long __functionAddress = Functions.Matrix4DecomposeIntoScalingEulerAnglesPosition;
        JNI.invokePPPPV((long)mat, (long)scaling, (long)rotation, (long)position, (long)__functionAddress);
    }

    public static void aiMatrix4DecomposeIntoScalingEulerAnglesPosition(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D *") AIVector3D scaling, @NativeType(value="struct aiVector3D *") AIVector3D rotation, @NativeType(value="struct aiVector3D *") AIVector3D position) {
        Assimp.naiMatrix4DecomposeIntoScalingEulerAnglesPosition(mat.address(), scaling.address(), rotation.address(), position.address());
    }

    public static void naiMatrix4DecomposeIntoScalingAxisAnglePosition(long mat, long scaling, long axis, long angle, long position) {
        long __functionAddress = Functions.Matrix4DecomposeIntoScalingAxisAnglePosition;
        JNI.invokePPPPPV((long)mat, (long)scaling, (long)axis, (long)angle, (long)position, (long)__functionAddress);
    }

    public static void aiMatrix4DecomposeIntoScalingAxisAnglePosition(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D *") AIVector3D scaling, @NativeType(value="struct aiVector3D *") AIVector3D axis, @NativeType(value="ai_real *") FloatBuffer angle, @NativeType(value="struct aiVector3D *") AIVector3D position) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)angle, (int)1);
        }
        Assimp.naiMatrix4DecomposeIntoScalingAxisAnglePosition(mat.address(), scaling.address(), axis.address(), MemoryUtil.memAddress((FloatBuffer)angle), position.address());
    }

    public static void naiMatrix4DecomposeNoScaling(long mat, long rotation, long position) {
        long __functionAddress = Functions.Matrix4DecomposeNoScaling;
        JNI.invokePPPV((long)mat, (long)rotation, (long)position, (long)__functionAddress);
    }

    public static void aiMatrix4DecomposeNoScaling(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat, @NativeType(value="struct aiQuaternion *") AIQuaternion rotation, @NativeType(value="struct aiVector3D *") AIVector3D position) {
        Assimp.naiMatrix4DecomposeNoScaling(mat.address(), rotation.address(), position.address());
    }

    public static void naiMatrix4FromEulerAngles(long mat, float x, float y, float z) {
        long __functionAddress = Functions.Matrix4FromEulerAngles;
        JNI.invokePV((long)mat, (float)x, (float)y, (float)z, (long)__functionAddress);
    }

    public static void aiMatrix4FromEulerAngles(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, float x, float y, float z) {
        Assimp.naiMatrix4FromEulerAngles(mat.address(), x, y, z);
    }

    public static void naiMatrix4RotationX(long mat, float angle) {
        long __functionAddress = Functions.Matrix4RotationX;
        JNI.invokePV((long)mat, (float)angle, (long)__functionAddress);
    }

    public static void aiMatrix4RotationX(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, float angle) {
        Assimp.naiMatrix4RotationX(mat.address(), angle);
    }

    public static void naiMatrix4RotationY(long mat, float angle) {
        long __functionAddress = Functions.Matrix4RotationY;
        JNI.invokePV((long)mat, (float)angle, (long)__functionAddress);
    }

    public static void aiMatrix4RotationY(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, float angle) {
        Assimp.naiMatrix4RotationY(mat.address(), angle);
    }

    public static void naiMatrix4RotationZ(long mat, float angle) {
        long __functionAddress = Functions.Matrix4RotationZ;
        JNI.invokePV((long)mat, (float)angle, (long)__functionAddress);
    }

    public static void aiMatrix4RotationZ(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, float angle) {
        Assimp.naiMatrix4RotationZ(mat.address(), angle);
    }

    public static void naiMatrix4FromRotationAroundAxis(long mat, long axis, float angle) {
        long __functionAddress = Functions.Matrix4FromRotationAroundAxis;
        JNI.invokePPV((long)mat, (long)axis, (float)angle, (long)__functionAddress);
    }

    public static void aiMatrix4FromRotationAroundAxis(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D const *") AIVector3D axis, float angle) {
        Assimp.naiMatrix4FromRotationAroundAxis(mat.address(), axis.address(), angle);
    }

    public static void naiMatrix4Translation(long mat, long translation) {
        long __functionAddress = Functions.Matrix4Translation;
        JNI.invokePPV((long)mat, (long)translation, (long)__functionAddress);
    }

    public static void aiMatrix4Translation(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D const *") AIVector3D translation) {
        Assimp.naiMatrix4Translation(mat.address(), translation.address());
    }

    public static void naiMatrix4Scaling(long mat, long scaling) {
        long __functionAddress = Functions.Matrix4Scaling;
        JNI.invokePPV((long)mat, (long)scaling, (long)__functionAddress);
    }

    public static void aiMatrix4Scaling(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D const *") AIVector3D scaling) {
        Assimp.naiMatrix4Scaling(mat.address(), scaling.address());
    }

    public static void naiMatrix4FromTo(long mat, long from, long to) {
        long __functionAddress = Functions.Matrix4FromTo;
        JNI.invokePPPV((long)mat, (long)from, (long)to, (long)__functionAddress);
    }

    public static void aiMatrix4FromTo(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D const *") AIVector3D from, @NativeType(value="struct aiVector3D const *") AIVector3D to) {
        Assimp.naiMatrix4FromTo(mat.address(), from.address(), to.address());
    }

    public static void naiQuaternionFromEulerAngles(long q, float x, float y, float z) {
        long __functionAddress = Functions.QuaternionFromEulerAngles;
        JNI.invokePV((long)q, (float)x, (float)y, (float)z, (long)__functionAddress);
    }

    public static void aiQuaternionFromEulerAngles(@NativeType(value="struct aiQuaternion *") AIQuaternion q, float x, float y, float z) {
        Assimp.naiQuaternionFromEulerAngles(q.address(), x, y, z);
    }

    public static void naiQuaternionFromAxisAngle(long q, long axis, float angle) {
        long __functionAddress = Functions.QuaternionFromAxisAngle;
        JNI.invokePPV((long)q, (long)axis, (float)angle, (long)__functionAddress);
    }

    public static void aiQuaternionFromAxisAngle(@NativeType(value="struct aiQuaternion *") AIQuaternion q, @NativeType(value="struct aiVector3D const *") AIVector3D axis, float angle) {
        Assimp.naiQuaternionFromAxisAngle(q.address(), axis.address(), angle);
    }

    public static void naiQuaternionFromNormalizedQuaternion(long q, long normalized) {
        long __functionAddress = Functions.QuaternionFromNormalizedQuaternion;
        JNI.invokePPV((long)q, (long)normalized, (long)__functionAddress);
    }

    public static void aiQuaternionFromNormalizedQuaternion(@NativeType(value="struct aiQuaternion *") AIQuaternion q, @NativeType(value="struct aiVector3D const *") AIVector3D normalized) {
        Assimp.naiQuaternionFromNormalizedQuaternion(q.address(), normalized.address());
    }

    public static int naiQuaternionAreEqual(long a, long b) {
        long __functionAddress = Functions.QuaternionAreEqual;
        return JNI.invokePPI((long)a, (long)b, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiQuaternionAreEqual(@NativeType(value="struct aiQuaternion const *") AIQuaternion a, @NativeType(value="struct aiQuaternion const *") AIQuaternion b) {
        return Assimp.naiQuaternionAreEqual(a.address(), b.address()) != 0;
    }

    public static int naiQuaternionAreEqualEpsilon(long a, long b, float epsilon) {
        long __functionAddress = Functions.QuaternionAreEqualEpsilon;
        return JNI.invokePPI((long)a, (long)b, (float)epsilon, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean aiQuaternionAreEqualEpsilon(@NativeType(value="struct aiQuaternion const *") AIQuaternion a, @NativeType(value="struct aiQuaternion const *") AIQuaternion b, @NativeType(value="float const") float epsilon) {
        return Assimp.naiQuaternionAreEqualEpsilon(a.address(), b.address(), epsilon) != 0;
    }

    public static void naiQuaternionNormalize(long q) {
        long __functionAddress = Functions.QuaternionNormalize;
        JNI.invokePV((long)q, (long)__functionAddress);
    }

    public static void aiQuaternionNormalize(@NativeType(value="struct aiQuaternion *") AIQuaternion q) {
        Assimp.naiQuaternionNormalize(q.address());
    }

    public static void naiQuaternionConjugate(long q) {
        long __functionAddress = Functions.QuaternionConjugate;
        JNI.invokePV((long)q, (long)__functionAddress);
    }

    public static void aiQuaternionConjugate(@NativeType(value="struct aiQuaternion *") AIQuaternion q) {
        Assimp.naiQuaternionConjugate(q.address());
    }

    public static void naiQuaternionMultiply(long dst, long q) {
        long __functionAddress = Functions.QuaternionMultiply;
        JNI.invokePPV((long)dst, (long)q, (long)__functionAddress);
    }

    public static void aiQuaternionMultiply(@NativeType(value="struct aiQuaternion *") AIQuaternion dst, @NativeType(value="struct aiQuaternion const *") AIQuaternion q) {
        Assimp.naiQuaternionMultiply(dst.address(), q.address());
    }

    public static void naiQuaternionInterpolate(long dst, long start, long end, float factor) {
        long __functionAddress = Functions.QuaternionInterpolate;
        JNI.invokePPPV((long)dst, (long)start, (long)end, (float)factor, (long)__functionAddress);
    }

    public static void aiQuaternionInterpolate(@NativeType(value="struct aiQuaternion *") AIQuaternion dst, @NativeType(value="struct aiQuaternion const *") AIQuaternion start, @NativeType(value="struct aiQuaternion const *") AIQuaternion end, float factor) {
        Assimp.naiQuaternionInterpolate(dst.address(), start.address(), end.address(), factor);
    }

    public static long naiGetImporterDesc(long extension) {
        long __functionAddress = Functions.GetImporterDesc;
        return JNI.invokePP((long)extension, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiImporterDesc *")
    public static AIImporterDesc aiGetImporterDesc(@NativeType(value="char const *") ByteBuffer extension) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)extension);
        }
        long __result = Assimp.naiGetImporterDesc(MemoryUtil.memAddress((ByteBuffer)extension));
        return AIImporterDesc.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiImporterDesc *")
    public static AIImporterDesc aiGetImporterDesc(@NativeType(value="char const *") CharSequence extension) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(extension, true);
            long extensionEncoded = stack.getPointerAddress();
            long __result = Assimp.naiGetImporterDesc(extensionEncoded);
            AIImporterDesc aIImporterDesc = AIImporterDesc.createSafe(__result);
            return aIImporterDesc;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nTextureTypeToString(int in) {
        long __functionAddress = Functions.TextureTypeToString;
        return JNI.invokeP((int)in, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String TextureTypeToString(@NativeType(value="aiTextureType") int in) {
        long __result = Assimp.nTextureTypeToString(in);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static int naiGetMaterialProperty(long pMat, long pKey, int type, int index, long mPropOut) {
        long __functionAddress = Functions.GetMaterialProperty;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI((long)pMat, (long)pKey, (int)type, (int)index, (long)mPropOut, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiMaterialProperty const **") PointerBuffer mPropOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
            Checks.check((CustomBuffer)mPropOut, (int)1);
        }
        return Assimp.naiGetMaterialProperty(pMat.address(), MemoryUtil.memAddress((ByteBuffer)pKey), type, index, MemoryUtil.memAddress((CustomBuffer)mPropOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiMaterialProperty const **") PointerBuffer mPropOut) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)mPropOut, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = Assimp.naiGetMaterialProperty(pMat.address(), pKeyEncoded, type, index, MemoryUtil.memAddress((CustomBuffer)mPropOut));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="struct aiMaterialProperty const **") PointerBuffer mPropOut) {
        return Assimp.aiGetMaterialProperty(pMat, pKey, 0, 0, mPropOut);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="struct aiMaterialProperty const **") PointerBuffer mPropOut) {
        return Assimp.aiGetMaterialProperty(pMat, pKey, 0, 0, mPropOut);
    }

    public static int naiGetMaterialFloatArray(long pMat, long pKey, int type, int index, long pOut, long pMax) {
        long __functionAddress = Functions.GetMaterialFloatArray;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPPI((long)pMat, (long)pKey, (int)type, (int)index, (long)pOut, (long)pMax, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") FloatBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
            Checks.checkSafe((Buffer)pMax, (int)1);
            Checks.check((Buffer)pOut, (int)pMax.get(pMax.position()));
        }
        return Assimp.naiGetMaterialFloatArray(pMat.address(), MemoryUtil.memAddress((ByteBuffer)pKey), type, index, MemoryUtil.memAddress((FloatBuffer)pOut), MemoryUtil.memAddressSafe((IntBuffer)pMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") FloatBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pMax, (int)1);
            Checks.check((Buffer)pOut, (int)pMax.get(pMax.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = Assimp.naiGetMaterialFloatArray(pMat.address(), pKeyEncoded, type, index, MemoryUtil.memAddress((FloatBuffer)pOut), MemoryUtil.memAddressSafe((IntBuffer)pMax));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialIntegerArray(long pMat, long pKey, int type, int index, long pOut, long pMax) {
        long __functionAddress = Functions.GetMaterialIntegerArray;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPPI((long)pMat, (long)pKey, (int)type, (int)index, (long)pOut, (long)pMax, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") IntBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
            Checks.checkSafe((Buffer)pMax, (int)1);
            Checks.check((Buffer)pOut, (int)pMax.get(pMax.position()));
        }
        return Assimp.naiGetMaterialIntegerArray(pMat.address(), MemoryUtil.memAddress((ByteBuffer)pKey), type, index, MemoryUtil.memAddress((IntBuffer)pOut), MemoryUtil.memAddressSafe((IntBuffer)pMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") IntBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pMax, (int)1);
            Checks.check((Buffer)pOut, (int)pMax.get(pMax.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = Assimp.naiGetMaterialIntegerArray(pMat.address(), pKeyEncoded, type, index, MemoryUtil.memAddress((IntBuffer)pOut), MemoryUtil.memAddressSafe((IntBuffer)pMax));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialColor(long pMat, long pKey, int type, int index, long pOut) {
        long __functionAddress = Functions.GetMaterialColor;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI((long)pMat, (long)pKey, (int)type, (int)index, (long)pOut, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialColor(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiColor4D *") AIColor4D pOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
        }
        return Assimp.naiGetMaterialColor(pMat.address(), MemoryUtil.memAddress((ByteBuffer)pKey), type, index, pOut.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialColor(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiColor4D *") AIColor4D pOut) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = Assimp.naiGetMaterialColor(pMat.address(), pKeyEncoded, type, index, pOut.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialUVTransform(long pMat, long pKey, int type, int index, long pOut) {
        long __functionAddress = Functions.GetMaterialUVTransform;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI((long)pMat, (long)pKey, (int)type, (int)index, (long)pOut, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialUVTransform(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiUVTransform *") AIUVTransform pOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
        }
        return Assimp.naiGetMaterialUVTransform(pMat.address(), MemoryUtil.memAddress((ByteBuffer)pKey), type, index, pOut.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialUVTransform(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiUVTransform *") AIUVTransform pOut) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = Assimp.naiGetMaterialUVTransform(pMat.address(), pKeyEncoded, type, index, pOut.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialString(long pMat, long pKey, int type, int index, long pOut) {
        long __functionAddress = Functions.GetMaterialString;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI((long)pMat, (long)pKey, (int)type, (int)index, (long)pOut, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialString(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString pOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
        }
        return Assimp.naiGetMaterialString(pMat.address(), MemoryUtil.memAddress((ByteBuffer)pKey), type, index, pOut.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialString(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString pOut) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = Assimp.naiGetMaterialString(pMat.address(), pKeyEncoded, type, index, pOut.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialTextureCount(long pMat, int type) {
        long __functionAddress = Functions.GetMaterialTextureCount;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePI((long)pMat, (int)type, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int aiGetMaterialTextureCount(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="aiTextureType") int type) {
        return Assimp.naiGetMaterialTextureCount(pMat.address(), type);
    }

    public static int naiGetMaterialTexture(long pMat, int type, int index, long path, long mapping, long uvindex, long blend, long op, long mapmode, long flags) {
        long __functionAddress = Functions.GetMaterialTexture;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPPPPPPI((long)pMat, (int)type, (int)index, (long)path, (long)mapping, (long)uvindex, (long)blend, (long)op, (long)mapmode, (long)flags, (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialTexture(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="aiTextureType") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString path, @Nullable @NativeType(value="aiTextureMapping *") IntBuffer mapping, @Nullable @NativeType(value="unsigned int *") IntBuffer uvindex, @Nullable @NativeType(value="float *") FloatBuffer blend, @Nullable @NativeType(value="aiTextureOp *") IntBuffer op, @Nullable @NativeType(value="aiTextureMapMode *") IntBuffer mapmode, @Nullable @NativeType(value="unsigned int *") IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)mapping, (int)1);
            Checks.checkSafe((Buffer)uvindex, (int)1);
            Checks.checkSafe((Buffer)blend, (int)1);
            Checks.checkSafe((Buffer)op, (int)1);
            Checks.checkSafe((Buffer)mapmode, (int)1);
            Checks.checkSafe((Buffer)flags, (int)1);
        }
        return Assimp.naiGetMaterialTexture(pMat.address(), type, index, path.address(), MemoryUtil.memAddressSafe((IntBuffer)mapping), MemoryUtil.memAddressSafe((IntBuffer)uvindex), MemoryUtil.memAddressSafe((FloatBuffer)blend), MemoryUtil.memAddressSafe((IntBuffer)op), MemoryUtil.memAddressSafe((IntBuffer)mapmode), MemoryUtil.memAddressSafe((IntBuffer)flags));
    }

    public static long naiGetLegalString() {
        long __functionAddress = Functions.GetLegalString;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String aiGetLegalString() {
        long __result = Assimp.naiGetLegalString();
        return MemoryUtil.memASCII((long)__result);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionPatch() {
        long __functionAddress = Functions.GetVersionPatch;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionMinor() {
        long __functionAddress = Functions.GetVersionMinor;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionMajor() {
        long __functionAddress = Functions.GetVersionMajor;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionRevision() {
        long __functionAddress = Functions.GetVersionRevision;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long naiGetBranchName() {
        long __functionAddress = Functions.GetBranchName;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String aiGetBranchName() {
        long __result = Assimp.naiGetBranchName();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="unsigned int")
    public static int aiGetCompileFlags() {
        long __functionAddress = Functions.GetCompileFlags;
        return JNI.invokeI((long)__functionAddress);
    }

    public static void aiMatrix4DecomposeIntoScalingAxisAnglePosition(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D *") AIVector3D scaling, @NativeType(value="struct aiVector3D *") AIVector3D axis, @NativeType(value="ai_real *") float[] angle, @NativeType(value="struct aiVector3D *") AIVector3D position) {
        long __functionAddress = Functions.Matrix4DecomposeIntoScalingAxisAnglePosition;
        if (Checks.CHECKS) {
            Checks.check((float[])angle, (int)1);
        }
        JNI.invokePPPPPV((long)mat.address(), (long)scaling.address(), (long)axis.address(), (float[])angle, (long)position.address(), (long)__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") float[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialFloatArray;
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
            Checks.checkSafe((int[])pMax, (int)1);
            Checks.check((float[])pOut, (int)pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        return JNI.invokePPPPI((long)pMat.address(), (long)MemoryUtil.memAddress((ByteBuffer)pKey), (int)type, (int)index, (float[])pOut, (int[])pMax, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") float[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialFloatArray;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])pMax, (int)1);
            Checks.check((float[])pOut, (int)pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = JNI.invokePPPPI((long)pMat.address(), (long)pKeyEncoded, (int)type, (int)index, (float[])pOut, (int[])pMax, (long)__functionAddress);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") int[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialIntegerArray;
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pKey);
            Checks.checkSafe((int[])pMax, (int)1);
            Checks.check((int[])pOut, (int)pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        return JNI.invokePPPPI((long)pMat.address(), (long)MemoryUtil.memAddress((ByteBuffer)pKey), (int)type, (int)index, (int[])pOut, (int[])pMax, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="char const *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") int[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialIntegerArray;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])pMax, (int)1);
            Checks.check((int[])pOut, (int)pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pKey, true);
            long pKeyEncoded = stack.getPointerAddress();
            int n = JNI.invokePPPPI((long)pMat.address(), (long)pKeyEncoded, (int)type, (int)index, (int[])pOut, (int[])pMax, (long)__functionAddress);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialTexture(@NativeType(value="struct aiMaterial const *") AIMaterial pMat, @NativeType(value="aiTextureType") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString path, @Nullable @NativeType(value="aiTextureMapping *") int[] mapping, @Nullable @NativeType(value="unsigned int *") int[] uvindex, @Nullable @NativeType(value="float *") float[] blend, @Nullable @NativeType(value="aiTextureOp *") int[] op, @Nullable @NativeType(value="aiTextureMapMode *") int[] mapmode, @Nullable @NativeType(value="unsigned int *") int[] flags) {
        long __functionAddress = Functions.GetMaterialTexture;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])mapping, (int)1);
            Checks.checkSafe((int[])uvindex, (int)1);
            Checks.checkSafe((float[])blend, (int)1);
            Checks.checkSafe((int[])op, (int)1);
            Checks.checkSafe((int[])mapmode, (int)1);
            Checks.checkSafe((int[])flags, (int)1);
            AIMaterial.validate(pMat.address());
        }
        return JNI.invokePPPPPPPPI((long)pMat.address(), (int)type, (int)index, (long)path.address(), (int[])mapping, (int[])uvindex, (float[])blend, (int[])op, (int[])mapmode, (int[])flags, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void naiGetPredefinedLogStream(int pStreams, long file, long __result) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long values = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 2);
            MemoryUtil.memPutInt((long)values, (int)pStreams);
            MemoryUtil.memPutAddress((long)(values + (long)MemoryStack.POINTER_SIZE), (long)file);
            long arguments = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 2);
            MemoryUtil.memPutAddress((long)arguments, (long)values);
            MemoryUtil.memPutAddress((long)(arguments + (long)MemoryStack.POINTER_SIZE), (long)(values + (long)MemoryStack.POINTER_SIZE));
            LibFFI.nffi_call((long)GetPredefinedLogStreamCIF.address(), (long)GetPredefinedLogStream, (long)__result, (long)arguments);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="struct aiLogStream")
    public static AILogStream aiGetPredefinedLogStream(@NativeType(value="aiDefaultLogStream") int pStreams, @Nullable @NativeType(value="char const *") ByteBuffer file, @NativeType(value="struct aiLogStream") AILogStream __result) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)file);
        }
        Assimp.naiGetPredefinedLogStream(pStreams, MemoryUtil.memAddressSafe((ByteBuffer)file), __result.address());
        return __result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="struct aiLogStream")
    public static AILogStream aiGetPredefinedLogStream(@NativeType(value="aiDefaultLogStream") int pStreams, @Nullable @NativeType(value="char const *") CharSequence file, @NativeType(value="struct aiLogStream") AILogStream __result) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(file, true);
            long fileEncoded = file == null ? 0L : stack.getPointerAddress();
            Assimp.naiGetPredefinedLogStream(pStreams, fileEncoded, __result.address());
            AILogStream aILogStream = __result;
            return aILogStream;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static /* synthetic */ SharedLibrary access$000() {
        return ASSIMP;
    }

    public static final class Functions {
        public static final long GetExportFormatCount = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetExportFormatCount");
        public static final long GetExportFormatDescription = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetExportFormatDescription");
        public static final long ReleaseExportFormatDescription = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiReleaseExportFormatDescription");
        public static final long CopyScene = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiCopyScene");
        public static final long FreeScene = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiFreeScene");
        public static final long ExportScene = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiExportScene");
        public static final long ExportSceneEx = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiExportSceneEx");
        public static final long ExportSceneToBlob = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiExportSceneToBlob");
        public static final long ReleaseExportBlob = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiReleaseExportBlob");
        public static final long ImportFile = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiImportFile");
        public static final long ImportFileEx = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiImportFileEx");
        public static final long ImportFileExWithProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiImportFileExWithProperties");
        public static final long ImportFileFromMemory = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiImportFileFromMemory");
        public static final long ImportFileFromMemoryWithProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiImportFileFromMemoryWithProperties");
        public static final long ApplyPostProcessing = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiApplyPostProcessing");
        public static final long AttachLogStream = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiAttachLogStream");
        public static final long EnableVerboseLogging = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiEnableVerboseLogging");
        public static final long DetachLogStream = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiDetachLogStream");
        public static final long DetachAllLogStreams = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiDetachAllLogStreams");
        public static final long ReleaseImport = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiReleaseImport");
        public static final long GetErrorString = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetErrorString");
        public static final long IsExtensionSupported = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiIsExtensionSupported");
        public static final long GetExtensionList = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetExtensionList");
        public static final long GetMemoryRequirements = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMemoryRequirements");
        public static final long CreatePropertyStore = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiCreatePropertyStore");
        public static final long ReleasePropertyStore = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiReleasePropertyStore");
        public static final long SetImportPropertyInteger = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiSetImportPropertyInteger");
        public static final long SetImportPropertyFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiSetImportPropertyFloat");
        public static final long SetImportPropertyString = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiSetImportPropertyString");
        public static final long SetImportPropertyMatrix = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiSetImportPropertyMatrix");
        public static final long CreateQuaternionFromMatrix = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiCreateQuaternionFromMatrix");
        public static final long DecomposeMatrix = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiDecomposeMatrix");
        public static final long TransposeMatrix4 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiTransposeMatrix4");
        public static final long TransposeMatrix3 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiTransposeMatrix3");
        public static final long TransformVecByMatrix3 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiTransformVecByMatrix3");
        public static final long TransformVecByMatrix4 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiTransformVecByMatrix4");
        public static final long MultiplyMatrix4 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMultiplyMatrix4");
        public static final long MultiplyMatrix3 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMultiplyMatrix3");
        public static final long IdentityMatrix3 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiIdentityMatrix3");
        public static final long IdentityMatrix4 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiIdentityMatrix4");
        public static final long GetImportFormatCount = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetImportFormatCount");
        public static final long GetImportFormatDescription = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetImportFormatDescription");
        public static final long Vector2AreEqual = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2AreEqual");
        public static final long Vector2AreEqualEpsilon = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2AreEqualEpsilon");
        public static final long Vector2Add = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2Add");
        public static final long Vector2Subtract = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2Subtract");
        public static final long Vector2Scale = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2Scale");
        public static final long Vector2SymMul = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2SymMul");
        public static final long Vector2DivideByScalar = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2DivideByScalar");
        public static final long Vector2DivideByVector = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2DivideByVector");
        public static final long Vector2Length = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2Length");
        public static final long Vector2SquareLength = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2SquareLength");
        public static final long Vector2Negate = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2Negate");
        public static final long Vector2DotProduct = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2DotProduct");
        public static final long Vector2Normalize = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector2Normalize");
        public static final long Vector3AreEqual = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3AreEqual");
        public static final long Vector3AreEqualEpsilon = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3AreEqualEpsilon");
        public static final long Vector3LessThan = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3LessThan");
        public static final long Vector3Add = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3Add");
        public static final long Vector3Subtract = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3Subtract");
        public static final long Vector3Scale = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3Scale");
        public static final long Vector3SymMul = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3SymMul");
        public static final long Vector3DivideByScalar = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3DivideByScalar");
        public static final long Vector3DivideByVector = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3DivideByVector");
        public static final long Vector3Length = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3Length");
        public static final long Vector3SquareLength = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3SquareLength");
        public static final long Vector3Negate = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3Negate");
        public static final long Vector3DotProduct = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3DotProduct");
        public static final long Vector3CrossProduct = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3CrossProduct");
        public static final long Vector3Normalize = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3Normalize");
        public static final long Vector3NormalizeSafe = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3NormalizeSafe");
        public static final long Vector3RotateByQuaternion = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiVector3RotateByQuaternion");
        public static final long Matrix3FromMatrix4 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3FromMatrix4");
        public static final long Matrix3FromQuaternion = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3FromQuaternion");
        public static final long Matrix3AreEqual = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3AreEqual");
        public static final long Matrix3AreEqualEpsilon = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3AreEqualEpsilon");
        public static final long Matrix3Inverse = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3Inverse");
        public static final long Matrix3Determinant = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3Determinant");
        public static final long Matrix3RotationZ = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3RotationZ");
        public static final long Matrix3FromRotationAroundAxis = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3FromRotationAroundAxis");
        public static final long Matrix3Translation = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3Translation");
        public static final long Matrix3FromTo = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix3FromTo");
        public static final long Matrix4FromMatrix3 = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4FromMatrix3");
        public static final long Matrix4FromScalingQuaternionPosition = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4FromScalingQuaternionPosition");
        public static final long Matrix4Add = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4Add");
        public static final long Matrix4AreEqual = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4AreEqual");
        public static final long Matrix4AreEqualEpsilon = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4AreEqualEpsilon");
        public static final long Matrix4Inverse = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4Inverse");
        public static final long Matrix4Determinant = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4Determinant");
        public static final long Matrix4IsIdentity = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4IsIdentity");
        public static final long Matrix4DecomposeIntoScalingEulerAnglesPosition = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4DecomposeIntoScalingEulerAnglesPosition");
        public static final long Matrix4DecomposeIntoScalingAxisAnglePosition = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4DecomposeIntoScalingAxisAnglePosition");
        public static final long Matrix4DecomposeNoScaling = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4DecomposeNoScaling");
        public static final long Matrix4FromEulerAngles = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4FromEulerAngles");
        public static final long Matrix4RotationX = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4RotationX");
        public static final long Matrix4RotationY = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4RotationY");
        public static final long Matrix4RotationZ = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4RotationZ");
        public static final long Matrix4FromRotationAroundAxis = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4FromRotationAroundAxis");
        public static final long Matrix4Translation = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4Translation");
        public static final long Matrix4Scaling = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4Scaling");
        public static final long Matrix4FromTo = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiMatrix4FromTo");
        public static final long QuaternionFromEulerAngles = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionFromEulerAngles");
        public static final long QuaternionFromAxisAngle = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionFromAxisAngle");
        public static final long QuaternionFromNormalizedQuaternion = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionFromNormalizedQuaternion");
        public static final long QuaternionAreEqual = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionAreEqual");
        public static final long QuaternionAreEqualEpsilon = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionAreEqualEpsilon");
        public static final long QuaternionNormalize = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionNormalize");
        public static final long QuaternionConjugate = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionConjugate");
        public static final long QuaternionMultiply = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionMultiply");
        public static final long QuaternionInterpolate = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiQuaternionInterpolate");
        public static final long GetImporterDesc = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetImporterDesc");
        public static final long TextureTypeToString = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"TextureTypeToString");
        public static final long GetMaterialProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialProperty");
        public static final long GetMaterialFloatArray = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialFloatArray");
        public static final long GetMaterialIntegerArray = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialIntegerArray");
        public static final long GetMaterialColor = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialColor");
        public static final long GetMaterialUVTransform = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialUVTransform");
        public static final long GetMaterialString = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialString");
        public static final long GetMaterialTextureCount = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialTextureCount");
        public static final long GetMaterialTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetMaterialTexture");
        public static final long GetLegalString = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetLegalString");
        public static final long GetVersionPatch = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetVersionPatch");
        public static final long GetVersionMinor = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetVersionMinor");
        public static final long GetVersionMajor = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetVersionMajor");
        public static final long GetVersionRevision = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetVersionRevision");
        public static final long GetBranchName = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetBranchName");
        public static final long GetCompileFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)Assimp.access$000(), (String)"aiGetCompileFlags");

        private Functions() {
        }
    }
}

