/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRCameraExtrinsics;
import org.lwjgl.ovr.OVRCameraIntrinsics;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrExternalCamera")
public class OVRExternalCamera
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    public OVRExternalCamera(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRExternalCamera.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[32]")
    public ByteBuffer Name() {
        return OVRExternalCamera.nName(this.address());
    }

    @NativeType(value="char[32]")
    public String NameString() {
        return OVRExternalCamera.nNameString(this.address());
    }

    @NativeType(value="ovrCameraIntrinsics")
    public OVRCameraIntrinsics Intrinsics() {
        return OVRExternalCamera.nIntrinsics(this.address());
    }

    @NativeType(value="ovrCameraExtrinsics")
    public OVRCameraExtrinsics Extrinsics() {
        return OVRExternalCamera.nExtrinsics(this.address());
    }

    public static OVRExternalCamera malloc() {
        return (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRExternalCamera calloc() {
        return (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRExternalCamera create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRExternalCamera create(long address) {
        return (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)address);
    }

    @Nullable
    public static OVRExternalCamera createSafe(long address) {
        return address == 0L ? null : (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRExternalCamera.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRExternalCamera.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRExternalCamera mallocStack() {
        return OVRExternalCamera.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRExternalCamera callocStack() {
        return OVRExternalCamera.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRExternalCamera mallocStack(MemoryStack stack) {
        return OVRExternalCamera.malloc(stack);
    }

    @Deprecated
    public static OVRExternalCamera callocStack(MemoryStack stack) {
        return OVRExternalCamera.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRExternalCamera.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRExternalCamera.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.calloc(capacity, stack);
    }

    public static OVRExternalCamera malloc(MemoryStack stack) {
        return (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRExternalCamera calloc(MemoryStack stack) {
        return (OVRExternalCamera)OVRExternalCamera.wrap(OVRExternalCamera.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRExternalCamera.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)32);
    }

    public static String nNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static OVRCameraIntrinsics nIntrinsics(long struct) {
        return OVRCameraIntrinsics.create(struct + (long)INTRINSICS);
    }

    public static OVRCameraExtrinsics nExtrinsics(long struct) {
        return OVRCameraExtrinsics.create(struct + (long)EXTRINSICS);
    }

    static {
        Struct.Layout layout = OVRExternalCamera.__struct((Struct.Member[])new Struct.Member[]{OVRExternalCamera.__array((int)1, (int)32), OVRExternalCamera.__member((int)OVRCameraIntrinsics.SIZEOF, (int)OVRCameraIntrinsics.ALIGNOF), OVRExternalCamera.__member((int)OVRCameraExtrinsics.SIZEOF, (int)OVRCameraExtrinsics.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        INTRINSICS = layout.offsetof(1);
        EXTRINSICS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRExternalCamera, Buffer>
    implements NativeResource {
        private static final OVRExternalCamera ELEMENT_FACTORY = OVRExternalCamera.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRExternalCamera getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[32]")
        public ByteBuffer Name() {
            return OVRExternalCamera.nName(this.address());
        }

        @NativeType(value="char[32]")
        public String NameString() {
            return OVRExternalCamera.nNameString(this.address());
        }

        @NativeType(value="ovrCameraIntrinsics")
        public OVRCameraIntrinsics Intrinsics() {
            return OVRExternalCamera.nIntrinsics(this.address());
        }

        @NativeType(value="ovrCameraExtrinsics")
        public OVRCameraExtrinsics Extrinsics() {
            return OVRExternalCamera.nExtrinsics(this.address());
        }
    }
}

