/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrDetectResult")
public class OVRDetectResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISOCULUSSERVICERUNNING;
    public static final int ISOCULUSHMDCONNECTED;

    public OVRDetectResult(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRDetectResult.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsOculusServiceRunning() {
        return OVRDetectResult.nIsOculusServiceRunning(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean IsOculusHMDConnected() {
        return OVRDetectResult.nIsOculusHMDConnected(this.address());
    }

    public static OVRDetectResult malloc() {
        return (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRDetectResult calloc() {
        return (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRDetectResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRDetectResult create(long address) {
        return (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)address);
    }

    @Nullable
    public static OVRDetectResult createSafe(long address) {
        return address == 0L ? null : (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRDetectResult.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRDetectResult.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRDetectResult.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRDetectResult.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRDetectResult.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRDetectResult.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRDetectResult.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRDetectResult mallocStack() {
        return OVRDetectResult.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRDetectResult callocStack() {
        return OVRDetectResult.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRDetectResult mallocStack(MemoryStack stack) {
        return OVRDetectResult.malloc(stack);
    }

    @Deprecated
    public static OVRDetectResult callocStack(MemoryStack stack) {
        return OVRDetectResult.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRDetectResult.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRDetectResult.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRDetectResult.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRDetectResult.calloc(capacity, stack);
    }

    public static OVRDetectResult malloc(MemoryStack stack) {
        return (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRDetectResult calloc(MemoryStack stack) {
        return (OVRDetectResult)OVRDetectResult.wrap(OVRDetectResult.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRDetectResult.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRDetectResult.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static boolean nIsOculusServiceRunning(long struct) {
        return UNSAFE.getByte(null, struct + (long)ISOCULUSSERVICERUNNING) != 0;
    }

    public static boolean nIsOculusHMDConnected(long struct) {
        return UNSAFE.getByte(null, struct + (long)ISOCULUSHMDCONNECTED) != 0;
    }

    static {
        Struct.Layout layout = OVRDetectResult.__struct((Struct.Member[])new Struct.Member[]{OVRDetectResult.__member((int)1), OVRDetectResult.__member((int)1), OVRDetectResult.__padding((int)6, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISOCULUSSERVICERUNNING = layout.offsetof(0);
        ISOCULUSHMDCONNECTED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRDetectResult, Buffer>
    implements NativeResource {
        private static final OVRDetectResult ELEMENT_FACTORY = OVRDetectResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRDetectResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrBool")
        public boolean IsOculusServiceRunning() {
            return OVRDetectResult.nIsOculusServiceRunning(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean IsOculusHMDConnected() {
            return OVRDetectResult.nIsOculusHMDConnected(this.address());
        }
    }
}

