/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.items;

import OreSpawn.entities.ThrownThunder;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.entities.Entity;
import dangerzone.gui.InventoryMenus;
import dangerzone.items.Item;

public class LightningStaff
extends Item {
    public LightningStaff(String n, String txt) {
        super(n, txt);
        this.maxstack = 1;
        this.attackstrength = 25;
        this.maxuses = 100;
        this.menu = InventoryMenus.HARDWARE;
    }

    public boolean onSwingStop(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (holder.world.isServer) {
            if (DangerZone.isVR && holder instanceof Player) {
                TargetInfo ti = DangerZone.weapon_controller;
                ThrownThunder e = (ThrownThunder)holder.world.createEntityByName("OreSpawn:ThrownThunder", holder.dimension, ti.real_posx, ti.real_posy + (double)holder.getEyeHeight(), ti.real_posz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(0);
                    e.thrower = holder;
                    e.thrower2 = null;
                    e.setAttackDamage(10.0f);
                    e.setDirectionAndVelocity(ti.dx, ti.dy, ti.dz, 25.0f, 0.01f);
                    holder.world.spawnEntityInWorld((Entity)e);
                }
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return false;
    }

    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (DangerZone.isVR) {
            return false;
        }
        if (holder.world.isServer) {
            ThrownThunder e = (ThrownThunder)holder.world.createEntityByName("OreSpawn:ThrownThunder", holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 1.0f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(0);
                e.thrower = holder;
                e.thrower2 = null;
                e.setAttackDamage(10.0f);
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head))), (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), 11.0f, 0.02f);
                holder.world.spawnEntityInWorld((Entity)e);
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return false;
    }
}

