/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnUtils;
import OreSpawn.entities.GnatBat;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class TeraBat
extends EntityLiving {
    public float myspeed = 0.0f;

    public TeraBat(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 1.75f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:Tera Bat";
        this.setMaxHealth(125.0f);
        this.setHealth(125.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(20.0f);
        if (w != null) {
            this.myspeed = 0.35f + w.rand.nextFloat() * 0.1f;
        }
        this.takesFallDamage = false;
        this.setExperience(335);
        this.daytimespawn = false;
        this.nighttimespawn = true;
        this.daytimedespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.temperament = 1;
        this.searchDistance = 60.0f;
        this.attackRange = 5.5f;
        if (w != null) {
            this.lifetimeticker += (long)w.rand.nextInt(10000);
        }
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return "DangerZone:chirp1";
        }
        return "DangerZone:chirp2";
    }

    public String getAttackSound() {
        if (this.world.rand.nextBoolean()) {
            return "DangerZone:batattack1";
        }
        return "DangerZone:batattack2";
    }

    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public void doEntityAction(float deltaT) {
        int bid;
        int keep_trying = 25;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx + 1.0, this.posy, this.posz + 1.0);
        }
        this.do_swarm_despawn();
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(30) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)this.targetentity.getHeight() + 1.0, this.targetentity.posz);
                float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
                tdir = (float)((double)tdir - 1.5707963267948966);
                this.target.setTarget(this.target.targetx + Math.sin(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2), this.target.targety + (double)(this.world.rand.nextInt(3) - this.world.rand.nextInt(3)), this.target.targetz + Math.cos(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2));
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            this.world.playSound(this.getAttackSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(50) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 1;
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            int updown = 5;
            int k = 1;
            while (k < 11) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.getAttacking() && this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)this.targetentity.getHeight() + 1.0, this.targetentity.posz);
                    float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
                    tdir = (float)((double)tdir - 1.5707963267948966);
                    this.target.setTarget(this.target.targetx + Math.sin(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2), this.target.targety + (double)(this.world.rand.nextInt(7) - updown), this.target.targetz + Math.cos(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2));
                } else if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(20), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(20));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(20) - (double)this.world.rand.nextInt(20), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(20) - (double)this.world.rand.nextInt(20));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.45f + this.world.rand.nextFloat() * 0.2f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        float dy = (float)(this.target.targety - this.posy);
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0f) > 0.2f) {
            dy = 0.2f;
        }
        if (dy < -0.2f) {
            dy = -0.2f;
        }
        this.motiony += dy;
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath((EntityLiving)this);
        float dx = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        float dz = (float)Math.atan2(-this.motiony * 0.5f, dx);
        this.rotation_pitch = (float)Math.toDegrees(dz);
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            GnatBat sc;
            if (this.world.rand.nextInt(2000) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.batscat.itemID, (float)0.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            int chance = 500;
            if (this.getAttacking()) {
                chance = 40;
            }
            if (this.world.rand.nextInt(chance) == 1 && (sc = (GnatBat)this.world.createEntityByName("OreSpawn:Gnat Bat", this.dimension, this.posx, this.posy + 0.5, this.posz)) != null) {
                sc.init();
                sc.setIID(1);
                this.world.spawnEntityInWorld((Entity)sc);
            }
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (OreSpawnUtils.isBat(e).booleanValue()) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyterabat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int i = 0;
        while (i < 7) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.deadbug.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 7) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.furball.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_guts.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_nose.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_toes.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_tail.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_ear.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.minersdream.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.sifter.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        i = 0;
        while (i < 3) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.krakenrepellent.blockID, (int)0, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/TeraBattexture.png");
        }
        return this.texture;
    }
}

