/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RedPanda
extends EntityLiving {
    public RedPanda(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 0.75f;
        this.width = 0.55f;
        this.uniquename = "OreSpawn:Red Panda";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 65;
        this.setExperience(5);
        this.canSwim = true;
        this.temperament = 2;
        this.enableTaming(14);
        this.enableFollowHeldFood(12);
        this.enableDroppedFood(12);
    }

    public boolean isFoodItem(int foodid) {
        return foodid == Items.corn.itemID;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyredpanda.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        int i = 2 + this.world.rand.nextInt(4);
        int j = 0;
        while (j < i) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.furball.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++j;
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RedPandatexture.png");
        }
        return this.texture;
    }
}

