/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Lavrov;
import OreSpawn.entities.Russian;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Putin
extends EntityLiving {
    public Putin(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 3.8f;
        this.width = 1.7f;
        this.uniquename = "OreSpawn:Vladimir Putin";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(2500.0f);
        this.setHealth(2500.0f);
        this.setDefense(2.75f);
        this.setAttackDamage(75.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setMaxAir(150.0f);
        this.setAir(150.0f);
        this.setExperience(200);
        this.searchDistance = 16.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 55;
        this.canSwim = true;
        this.has_inventory = true;
        this.temperament = 2;
        this.enable_hostile = true;
        this.tower_defense_enable = false;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.setPetName("Vladimir Putin");
        this.setCanDespawn(false);
    }

    public void doEntityAction(float deltaT) {
        this.temperament = this.getAttacking() ? 1 : 2;
        if (this.world.rand.nextInt(10) == 1) {
            this.heal(1.0f);
        }
        super.doEntityAction(deltaT);
    }

    public boolean isFoodItem(int iid) {
        if (iid == Items.moosemeat.itemID) {
            return true;
        }
        if (iid == Items.moosemeat_cooked.itemID) {
            return true;
        }
        if (iid == Items.goosemeat.itemID) {
            return true;
        }
        return iid == Items.goosemeat_cooked.itemID;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyputin.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Lavrov) {
            return false;
        }
        if (e instanceof Putin) {
            return false;
        }
        if (e instanceof Russian) {
            return false;
        }
        if (e instanceof Cockroach) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        return false;
    }

    public float getScale() {
        if (this.isBaby()) {
            return 1.0f;
        }
        return 2.0f;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Putin.png");
        }
        return this.texture;
    }
}

