/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.entities.EntityLivingDragon;
import dangerzone.DangerZone;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class PurpleFireball
extends ThrownBlockItem {
    public float spin = 0.0f;
    double oposx;
    double oposy;
    double oposz;

    public PurpleFireball(World w) {
        super(w);
        this.setAttackDamage(100.0f);
        this.uniquename = "OreSpawn:PurpleFireball";
        this.maxrenderdist = 300;
        this.oposx = 0.0;
        this.oposy = 0.0;
        this.oposz = 0.0;
        this.deathtimer = 15;
    }

    public float getWidth() {
        return this.getScale();
    }

    public float getHeight() {
        return this.getScale();
    }

    public void doEntityAction(float deltaT) {
        this.motiony -= 0.16f * deltaT;
        float dist = (float)Math.sqrt(this.motionx * deltaT * this.motionx * deltaT + this.motiony * deltaT * this.motiony * deltaT + this.motionz * deltaT * this.motionz * deltaT);
        float blockdist = 0.0f;
        float edist = 0.0f;
        ArrayList<Entity> hit_list = null;
        List nearby_list = null;
        Entity enthit = null;
        Entity henthit = null;
        Entity ridden = null;
        boolean doit = true;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f + dist, this.dimension, this.posx, this.posy, this.posz);
        hit_list = new ArrayList<Entity>();
        double fx = this.posx;
        double fy = this.posy;
        double fz = this.posz;
        if (this.thrower != null && (ridden = this.thrower.getRiddenEntity()) == null) {
            ridden = this.thrower.getRiderEntity();
        }
        while (dist > 0.0f && blockdist < dist) {
            fx = this.posx + (double)(this.motionx * deltaT * blockdist / dist);
            fy = this.posy + (double)(this.motiony * deltaT * blockdist / dist);
            fz = this.posz + (double)(this.motionz * deltaT * blockdist / dist);
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                enthit = (Entity)li.next();
                if (enthit == this || enthit.canthitme || enthit == this.thrower || enthit == ridden || enthit == this.thrower2 || !(fy > enthit.posy - (double)(this.getWidth() / 2.0f)) || !(fy < enthit.posy + (double)enthit.getHeight() + (double)(this.getWidth() / 2.0f))) continue;
                edist = (float)enthit.getHorizontalDistanceFromEntity(fx, fz);
                edist -= this.getWidth() / 2.0f;
                if (!((edist -= enthit.getWidth() / 2.0f) < 0.0f)) continue;
                doit = true;
                ListIterator hli = hit_list.listIterator();
                while (hli.hasNext()) {
                    henthit = (Entity)hli.next();
                    if (henthit != enthit) continue;
                    doit = false;
                    break;
                }
                if (!doit) continue;
                this.doHitSomething(false, fx, fy, fz, true, enthit);
                hit_list.add(enthit);
            }
            this.doSpecialEffects(fx, fy, fz);
            blockdist += 0.25f;
        }
        --this.deathtimer;
        if (this.deathtimer <= 0) {
            this.deadflag = true;
        }
    }

    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (he && ent != null) {
            if (ent instanceof EntityLivingDragon) {
                return;
            }
            if (ent instanceof PurpleFireball) {
                return;
            }
            ent.doAttackFromNoKnock(this.thrower, 8, this.getAttackDamage() / this.getScale());
            ent.doSetOnFire((int)(20.0f / this.getScale()));
            if (ent instanceof EntityLiving) {
                EntityLiving el = (EntityLiving)ent;
                el.damage_backoff = 0;
            }
            this.world.playSound("OreSpawn:Varmint_death", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    public float getDensity() {
        float d = 1.5f / this.getScale();
        if (d > 1.0f) {
            d = 1.0f;
        }
        return d;
    }

    public float getSpinz() {
        this.spin += 5.0f;
        return this.spin;
    }

    public float getScale() {
        double d3;
        double d2;
        double d1;
        float scale;
        if (this.oposx == 0.0) {
            this.oposx = this.posx;
            this.oposy = this.posy;
            this.oposz = this.posz;
        }
        if ((scale = (float)Math.sqrt((d1 = this.oposx - this.posx) * d1 + (d2 = this.oposy - this.posy) * d2 + (d3 = this.oposz - this.posz) * d3)) < 10.0f) {
            scale = 10.0f;
        }
        return scale / 10.0f;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/misc/purple_fireball.png");
        }
        return this.texture;
    }
}

