/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Bee;
import OreSpawn.entities.Bird;
import OreSpawn.entities.Brutalfly;
import OreSpawn.entities.CliffRacer;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.EmperorScorpion;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.GoldFish;
import OreSpawn.entities.Mantis;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.TerribleTerror;
import OreSpawn.entities.Vortex;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Butterfly;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class LurkingTerror
extends EntityLiving {
    float myspeed = 0.0f;
    public float attackRange = 1.5f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    public RenderInfo renderdata = new RenderInfo();

    public LurkingTerror(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.uniquename = "OreSpawn:LurkingTerror";
        if (w != null) {
            this.myspeed = 0.33f + this.world.rand.nextFloat() * 0.22f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.temperament = 1;
        this.setExperience(35);
        this.height = 1.25f;
        this.width = 1.25f;
        this.setMaxHealth(40.0f);
        this.setHealth(40.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 30.0f;
        this.attackRange = 3.5f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
    }

    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 35;
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(35) - this.world.rand.nextInt(35)), this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)(this.world.rand.nextInt(35) - this.world.rand.nextInt(35)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                }
                this.myspeed = 0.32f + this.world.rand.nextFloat() * 0.22f;
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            this.motionx = (float)((double)this.motionx + (double)this.myspeed * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)this.myspeed * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath((EntityLiving)this);
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TerribleTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof EmperorScorpion && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror) {
            return false;
        }
        if (e instanceof Rotator && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Bee && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mantis && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mothra && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Brutalfly && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Vortex && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (!this.CanProbablySeeEntity(e)) {
            return false;
        }
        if (e instanceof Bird) {
            return true;
        }
        if (e instanceof Butterfly) {
            return true;
        }
        if (e instanceof GoldFish) {
            return true;
        }
        if (e instanceof CliffRacer) {
            return true;
        }
        if (e instanceof Girlfriend) {
            return true;
        }
        if (e instanceof Player) {
            return true;
        }
        return e instanceof Flag;
    }

    public void doDeathDrops() {
        int howmany = 6 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.deadbug.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophylurkingterror.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/LurkingTerrortexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:lurkingterror_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:lurkingterror_dead";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:lurkingterror_living";
    }
}

