/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Flounder
extends EntityLiving {
    public Flounder(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.85f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Flounder";
        this.moveSpeed = 0.175f;
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(2);
        this.canSwim = true;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockdisteat = 0;
        this.foodblockheal = 0;
        this.fooddaytimeonly = false;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Flounder;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:little_splash";
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
        if (!this.getInLiquid()) {
            this.enable_findfoodblock = true;
        } else {
            this.enable_findfoodblock = false;
            Utils.SpawnBubblesAlongPath((EntityLiving)this);
        }
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyflounder.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Floundertexture.png");
        }
        return this.texture;
    }
}

