/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Brutalfly;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.EmperorScorpion;
import OreSpawn.entities.LurkingTerror;
import OreSpawn.entities.Mantis;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.TerribleTerror;
import OreSpawn.entities.Vortex;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Bee
extends EntityLiving {
    float myspeed = 0.0f;

    public Bee(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.uniquename = "OreSpawn:Bee";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 3.25f;
        this.width = 1.55f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 28.0f;
        this.attackRange = 3.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.05f, 200);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    public void doEntityAction(float deltaT) {
        int bid;
        this.do_swarm_despawn();
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 35;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0) {
            int i = 0;
            while (i < 4) {
                if (this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)i, this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                    bid = 1;
                }
                ++i;
            }
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            int updown = 5;
            int k = 1;
            while (k < 13) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(25), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(25));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath((EntityLiving)this);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TerribleTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof EmperorScorpion && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Rotator && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Bee) {
            return false;
        }
        if (e instanceof Mantis && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mothra && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Brutalfly && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Vortex && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int howmany = 6 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.buttercandy.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.flower_yellow.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophybee.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Beetexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:dragonfly_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:beebuzz";
    }
}

