/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Beaver
extends EntityLiving {
    public Beaver(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 0.9f;
        this.width = 0.9f;
        this.uniquename = "OreSpawn:Beaver";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(1.0f);
        this.movefrequency = 35;
        this.setExperience(15);
        this.canSwim = true;
        this.setCanDespawn(false);
        this.enable_avoid = true;
        this.avoiddistance = 30;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 2;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Beaver;
    }

    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.log.blockID || bid == Blocks.willowlog.blockID || bid == Blocks.redwoodlog.blockID) {
            return true;
        }
        return bid == OreSpawnMain.MySkyTreeLog.blockID || bid == OreSpawnMain.MyDT.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        this.world.setblockWithPerm((Entity)this, d, x, y, z, 0);
        this.world.playSound("OreSpawn:chainsaw", this.dimension, this.posx, this.posy, this.posz, 0.95f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        this.breakRecursor(x, y, z, x, y, z, 0);
    }

    public void breakRecursor(int x, int y, int z, int xf, int yf, int zf, int recursion) {
        int var7 = 1;
        if (recursion > 200) {
            return;
        }
        int var9 = -var7;
        while (var9 <= var7) {
            int var10 = -var7;
            while (var10 <= var7) {
                int var11 = -var7;
                while (var11 <= var7) {
                    int var12;
                    if (!(var9 == 0 && var10 == 0 && var11 == 0 || x + var9 == xf && y + var10 == yf && z + var11 == zf || recursion > 0 && x + var9 >= xf - var7 && x + var9 <= xf + var7 && y + var10 >= yf - var7 && y + var10 <= yf + var7 && z + var11 >= zf - var7 && z + var11 <= zf + var7 || !this.isFoodBlock(var12 = this.world.getblock(this.dimension, x + var9, y + var10, z + var11)))) {
                        this.world.setblockWithPerm((Entity)this, this.dimension, x + var9, y + var10, z + var11, 0);
                        if (this.world.rand.nextBoolean()) {
                            Utils.doDropRand((World)this.world, (int)var12, (int)0, (float)3.0f, (int)this.dimension, (double)(x + var9), (double)(y + var10), (double)(z + var11));
                        }
                        this.breakRecursor(x + var9, y + var10, z + var11, x, y, z, recursion + 1);
                    }
                    ++var11;
                }
                ++var10;
            }
            ++var9;
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:scorpion_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int howmany = 5 + this.world.rand.nextInt(13);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Blocks.log.blockID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophybeaver.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Beavertexture.png");
        }
        return this.texture;
    }
}

