/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Baryonyx
extends EntityLiving {
    public Baryonyx(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 3.1f;
        this.width = 1.5f;
        this.uniquename = "OreSpawn:Baryonyx";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(60.0f);
        this.setHealth(60.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        this.movefrequency = 65;
        this.setExperience(45);
        this.canSwim = true;
        this.setCanDespawn(false);
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 5;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Baryonyx;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.grass.blockID || bid == Blocks.grassblock.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        int bid;
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp();
        }
        if ((bid = this.world.getblock(d, x, y, z)) == Blocks.grass.blockID) {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, 0, 0);
        } else {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, Blocks.dirt.blockID, 0);
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophybaryonyx.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Baryonyxtexture.png");
        }
        return this.texture;
    }
}

