/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Boyfriend;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.DelayedTeleport;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import OreSpawn.entities.ThePrincessYoungAdult;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class BabySitter
extends EntityLiving {
    Entity killed_baby = null;

    public BabySitter(World w) {
        super(w);
        this.maxrenderdist = 250;
        this.height = 14.0f;
        this.width = 3.0f;
        this.uniquename = "OreSpawn:BabySitter";
        this.moveSpeed = 0.41f;
        this.setMaxHealth(1200.0f);
        this.setHealth(1200.0f);
        this.setDefense(4.25f);
        this.setAttackDamage(120.0f);
        this.searchDistance = 48.0f;
        this.attackRange = 5.5f;
        this.movefrequency = 55;
        this.setExperience(2599);
        this.canSwim = true;
        this.daytimespawn = false;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = false;
        this.setCanDespawn(false);
        this.enable_buddy = true;
        this.findbuddydistance = 64;
        this.findbuddyfrequency = 20;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof ChaosDemon;
    }

    public void doEntityAction(float deltaT) {
        if (this.world.rand.nextInt(25) == 1) {
            this.heal(1.0f);
        }
        if (this.killed_baby != null) {
            if (!this.killed_baby.deadflag) {
                this.hurtMe = this.killed_baby;
            } else {
                this.killed_baby = null;
            }
        }
        super.doEntityAction(deltaT);
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.teleportnearby(e, 10);
        super.doAttackFrom(e, dt, pain);
    }

    private void teleportnearby(Entity e, int dist) {
        int tries = 10;
        while (tries > 0) {
            --tries;
            int py = (int)e.posy;
            int px = (int)(e.posx + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
            int pz = (int)(e.posz + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
            int i = -7;
            while (i <= 9) {
                int bid = this.world.getblock(this.dimension, px, py + i, pz);
                if (bid == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 1, pz)) == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 2, pz)) == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 3, pz)) != 0) {
                    int j = 0;
                    while (j < 3) {
                        Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSmoke", (int)12, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)j), (double)this.posz);
                        ++j;
                    }
                    this.posx = 0.5f + (float)px;
                    this.posz = 0.5f + (float)pz;
                    this.posy = py + i - 2;
                    tries = 0;
                    int which = this.world.rand.nextInt(3);
                    if (which == 0) {
                        this.world.playSound("DangerZone:teleport1", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    if (which == 1) {
                        this.world.playSound("DangerZone:teleport2", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    if (which == 2) {
                        this.world.playSound("DangerZone:teleport3", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
                    this.rotation_yaw = this.rotation_yaw_head = (float)Math.toDegrees(tdir);
                    return;
                }
                ++i;
            }
        }
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:babysitter_living1";
        }
        return "OreSpawn:babysitter_living2";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "OreSpawn:babysitter_hit1";
        }
        if (which == 1) {
            return "OreSpawn:babysitter_hit2";
        }
        if (which == 2) {
            return "OreSpawn:babysitter_hit3";
        }
        if (which == 3) {
            return "OreSpawn:babysitter_hit4";
        }
        if (which == 4) {
            return "OreSpawn:babysitter_hit5";
        }
        if (which == 5) {
            return "OreSpawn:babysitter_hit6";
        }
        if (which == 6) {
            return "OreSpawn:babysitter_hit7";
        }
        if (which == 7) {
            return "OreSpawn:babysitter_hit8";
        }
        if (which == 8) {
            return "OreSpawn:babysitter_hit9";
        }
        return null;
    }

    public String getDeathSound() {
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:babysitter_death1";
        }
        return "OreSpawn:babysitter_death2";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophybabysitter.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int howmany = this.world.rand.nextInt(8) + 1;
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.buttercandy.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.popcorn_buttered_salted.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crabbypatty.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.corndog_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.bacon_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.blt_sandwich.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.salad.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.peacockmeat_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crabmeat_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.lettuce.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.strawberry.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.tomato.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.quinoa.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.instantgarden.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.instantshelter.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.spam.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.goosemeat_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.ostrichmeat_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat_cooked.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.bread.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.butter.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.cheese.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.radish.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.rice.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.corn.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.peach.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.cherries.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.apple.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(8) + 1;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.squeaktoy.itemID, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        super.doDeathDrops();
        DelayedTeleport sc = (DelayedTeleport)this.world.createEntityByName("OreSpawn:DelayedTeleport", this.dimension, this.posx, this.posy, this.posz);
        if (sc != null) {
            sc.init();
            this.world.spawnEntityInWorld((Entity)sc);
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (e instanceof Squid) {
            return false;
        }
        if (e instanceof SquidGuard) {
            return false;
        }
        if (e instanceof Kraken) {
            return false;
        }
        if (e instanceof KrakenKing) {
            return false;
        }
        if (e instanceof ThePrincessYoungAdult) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Boyfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Flag && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/BabySittertexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Babysitter!!!";
    }
}

