/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Alosaurus
extends EntityLiving {
    public Alosaurus(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 3.33f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:Alosaurus";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(30.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 65;
        this.setExperience(199);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:alo_living";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpcopper.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.blockcopper.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperchestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperhelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperpickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coppershovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coppersword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.copperhoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyalosaurus.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Alosaurus) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Alosaurustexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }
}

