/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.entities.RubberDucky;
import dangerzone.DangerZone;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.rendering.StitchedTexture;
import dangerzone.threads.FastBlockTicker;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class BlockDuckSucker
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tside = null;
    String topname;
    String bottomname;
    String sidename;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture sside = new StitchedTexture();

    public BlockDuckSucker(String n, String top, String bot, String side) {
        super(n, "");
        this.isStone = true;
        this.maxdamage = 20;
        this.mindamage = 2;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.topname = top;
        this.bottomname = bot;
        this.sidename = side;
        this.alwaystick = true;
        this.hasFront = true;
        this.showTop = true;
    }

    public void tickMe(World w, int d, int x, int y, int z) {
        FastBlockTicker.addFastTick((int)d, (int)x, (int)y, (int)z, (int)2);
        super.tickMe(w, d, x, y, z);
    }

    public void tickMeFast(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        FastBlockTicker.addFastTick((int)d, (int)x, (int)y, (int)z, (int)2);
        int i = -4;
        while (i <= 4) {
            int j = -4;
            while (j <= 4) {
                int bid = w.getblock(d, x + i, y, z + j);
                if (Blocks.isLiquid((int)bid)) {
                    this.move_things(d, x + i, y, z + j, -i, 0, -j);
                }
                j += 2;
            }
            i += 2;
        }
        this.kill_things(d, x, y, z);
    }

    public boolean fillit(World w, int d, int x, int y, int z, int lib) {
        int bid = w.getblock(d, x, y, z);
        if (bid == 0 || Blocks.isLiquid((int)bid) || Blocks.isLeaves((int)bid)) {
            int bidtoset = Blocks.getActiveBlockid((int)lib);
            if (bidtoset == 0) {
                bidtoset = lib;
            }
            if (!BreakChecks.canChangeBlock((World)w, (int)d, (int)x, (int)y, (int)z, (int)d, (int)x, (int)y, (int)z, (int)bidtoset, (int)1)) {
                return false;
            }
            w.setblockandmeta(d, x, y, z, bidtoset, 1);
            return true;
        }
        return false;
    }

    public void move_things(int dimension, double posx, double posy, double posz, int xdir, int ydir, int zdir) {
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(3.0f, dimension, posx + 0.5, posy + 1.0, posz + 0.5);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                double dist = e.getDistanceFromEntityCenter(posx + 0.5, posy + 1.0, posz + 0.5);
                if (!((dist -= (double)e.getWidth()) < 3.0) || !this.isSuitableTarget(e) || e.world.rand.nextInt(2) != 1) continue;
                e.motionx += (float)xdir * 0.04f;
                e.motiony += (float)ydir * 0.01f;
                e.motionz += (float)zdir * 0.04f;
            }
        }
    }

    public void kill_things(int dimension, double posx, double posy, double posz) {
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(2.0f, dimension, posx + 0.5, posy + 1.0, posz + 0.5);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                double dist = e.getDistanceFromEntityCenter(posx + 0.5, posy + 1.0, posz + 0.5);
                if (!((dist -= (double)e.getWidth()) < 1.75) || !this.isSuitableTarget(e)) continue;
                e.doAttackFrom(null, 0, 50.0f);
            }
        }
    }

    public boolean isSuitableTarget(Entity e) {
        return e instanceof RubberDucky;
    }

    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tside == null) {
            this.tside = this.initBlockTexture(this.sidename);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        return this.tside;
    }

    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        return this.sside;
    }

    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        return this.sidename;
    }
}

