/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.OreSpawnMain;
import dangerzone.blocks.Blocks;
import dangerzone.rendering.Fastmath;
import dangerzone.world.World;
import java.awt.Point;
import java.util.Vector;

public class CrystalMaze {
    private final int WTOP = 1;
    private final int WRGT = 2;
    private final int WBOT = 4;
    private final int WLFT = 8;

    public void buildCrystalMaze(World world, int dim, int x, int y, int z) {
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int k = 0;
                while (k < 3) {
                    world.setblock(dim, x + j, y + k, z + i, 0);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.makeMaze(world, dim, x, y, z, 4, 4, 4, 1);
        this.openCrystalMaze(world, dim, x, y, z, 4, 4, 4);
    }

    private void openCrystalMaze(World world, int dim, int xx, int yy, int zz, int xw, int zw, int csz) {
        int j;
        int i = 0;
        while (i < zw * csz) {
            world.setblock(dim, xx, yy, zz + i, 0);
            world.setblock(dim, xx, yy + 1, zz + i, 0);
            world.setblock(dim, xx, yy + 2, zz + i, 0);
            world.setblock(dim, xx + i, yy, zz, 0);
            world.setblock(dim, xx + i, yy + 1, zz, 0);
            world.setblock(dim, xx + i, yy + 2, zz, 0);
            world.setblock(dim, xx + zw * csz - 1, yy, zz + i, 0);
            world.setblock(dim, xx + zw * csz - 1, yy + 1, zz + i, 0);
            world.setblock(dim, xx + zw * csz - 1, yy + 2, zz + i, 0);
            world.setblock(dim, xx + i, yy, zz + zw * csz - 1, 0);
            world.setblock(dim, xx + i, yy + 1, zz + zw * csz - 1, 0);
            world.setblock(dim, xx + i, yy + 2, zz + zw * csz - 1, 0);
            ++i;
        }
        i = 0;
        while (i < zw * csz) {
            j = 0;
            while (j < zw * csz) {
                world.setblock(dim, xx + j, yy - 1, zz + i, Blocks.hardrock.blockID);
                world.setblock(dim, xx + j, yy + 3, zz + i, Blocks.hardrock.blockID);
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 4) {
            i = Fastmath.nextInt((int)(zw * csz));
            j = Fastmath.nextInt((int)(zw * csz));
            world.setblock(dim, xx + j, yy + 3, zz + i, OreSpawnMain.crystalstone.blockID);
            ++k;
        }
        i = Fastmath.nextInt((int)(zw * csz));
        j = Fastmath.nextInt((int)(zw * csz));
        world.setblock(dim, xx + j, yy - 1, zz + i, OreSpawnMain.crystalstone.blockID);
    }

    private void makeMaze(World world, int dim, int xx, int yy, int zz, int xw, int zw, int csz, int b) {
        int y;
        int gridw = xw;
        int gridh = zw;
        int cellsize = csz;
        if (cellsize < 3) {
            cellsize = 3;
        }
        int[][] cells = new int[gridw][gridh];
        int full = 15;
        int x = 0;
        while (x < gridw) {
            y = 0;
            while (y < gridh) {
                cells[x][y] = full;
                ++y;
            }
            ++x;
        }
        int left = 128;
        int right = 32;
        y = 0;
        while (y < gridh) {
            int[] nArray = cells[0];
            int n = y;
            nArray[n] = nArray[n] | left;
            int[] nArray2 = cells[gridw - 1];
            int n2 = y++;
            nArray2[n2] = nArray2[n2] | right;
        }
        int top = 16;
        int bottom = 64;
        x = 0;
        while (x < gridw) {
            int[] nArray = cells[x];
            nArray[0] = nArray[0] | top;
            int[] nArray3 = cells[x];
            int n = gridh - 1;
            nArray3[n] = nArray3[n] | bottom;
            ++x;
        }
        Vector<Point> outlist = new Vector<Point>(gridw * gridh);
        Vector<Point> inlist = new Vector<Point>(10, 10);
        Vector<Point> frontlist = new Vector<Point>(10, 10);
        x = 0;
        while (x < gridw) {
            y = 0;
            while (y < gridh) {
                outlist.addElement(new Point(x, y));
                ++y;
            }
            ++x;
        }
        Point current_cell = (Point)this.rndElement(outlist);
        inlist.addElement(current_cell);
        this.moveNbrs(current_cell, cells, outlist, frontlist);
        while (!frontlist.isEmpty()) {
            current_cell = (Point)this.rndElement(frontlist);
            inlist.addElement(current_cell);
            this.moveNbrs(current_cell, cells, outlist, frontlist);
            int dir = this.findInNbr(current_cell, cells, inlist);
            this.removeWall(current_cell, dir, cells);
        }
        current_cell = null;
        x = 0;
        while (x < gridw) {
            y = 0;
            while (y < gridh) {
                int val = cells[x][y];
                if ((val & 1) != 0) {
                    this.drawSide(world, dim, x * cellsize, y * cellsize, (x + 1) * cellsize, y * cellsize, xx, yy, zz, cellsize, gridh, gridw, b);
                }
                if ((val & 2) != 0) {
                    this.drawSide(world, dim, (x + 1) * cellsize - 1, y * cellsize, (x + 1) * cellsize - 1, (y + 1) * cellsize, xx, yy, zz, cellsize, gridh, gridw, b);
                }
                if ((val & 4) != 0) {
                    this.drawSide(world, dim, x * cellsize, (y + 1) * cellsize - 1, (x + 1) * cellsize, (y + 1) * cellsize - 1, xx, yy, zz, cellsize, gridh, gridw, b);
                }
                if ((val & 8) != 0) {
                    this.drawSide(world, dim, x * cellsize, y * cellsize, x * cellsize, (y + 1) * cellsize, xx, yy, zz, cellsize, gridh, gridw, b);
                }
                ++y;
            }
            ++x;
        }
    }

    private void drawSide(World world, int dim, int fromx, int fromz, int tox, int toz, int x, int y, int z, int cellsize, int gridh, int gridw, int bb) {
        int i;
        int blk = Blocks.hardrock.blockID;
        if (fromx > tox) {
            i = fromx;
            fromx = tox;
            tox = i;
        }
        if (fromz > toz) {
            i = fromz;
            fromz = toz;
            toz = i;
        }
        if (fromx == tox) {
            i = fromx;
            int j = fromz;
            while (j <= toz) {
                if (j < cellsize * gridh) {
                    world.setblock(dim, i + x, y, j + z, blk);
                    world.setblock(dim, i + x, y + 1, j + z, blk);
                    world.setblock(dim, i + x, y + 2, j + z, blk);
                }
                ++j;
            }
        } else {
            int j = fromz;
            i = fromx;
            while (i <= tox) {
                if (i < cellsize * gridw) {
                    world.setblock(dim, i + x, y, j + z, blk);
                    world.setblock(dim, i + x, y + 1, j + z, blk);
                    world.setblock(dim, i + x, y + 2, j + z, blk);
                }
                ++i;
            }
        }
    }

    private int findInNbr(Point p, int[][] cells, Vector<Point> inlist) {
        int d = this.rnd(4) - 1;
        int k = 0;
        while (k < 4) {
            switch (d) {
                case 0: {
                    if ((cells[p.x][p.y] & 0x10) != 0 || inlist.indexOf(new Point(p.x, p.y - 1)) < 0) break;
                    return 1;
                }
                case 1: {
                    if ((cells[p.x][p.y] & 0x20) != 0 || inlist.indexOf(new Point(p.x + 1, p.y)) < 0) break;
                    return 2;
                }
                case 2: {
                    if ((cells[p.x][p.y] & 0x40) != 0 || inlist.indexOf(new Point(p.x, p.y + 1)) < 0) break;
                    return 4;
                }
                case 3: {
                    if ((cells[p.x][p.y] & 0x80) != 0 || inlist.indexOf(new Point(p.x - 1, p.y)) < 0) break;
                    return 8;
                }
            }
            d = (d + 1) % 4;
            ++k;
        }
        return 0;
    }

    private void moveNbrs(Point p, int[][] cells, Vector<Point> outlist, Vector<Point> frontlist) {
        Point s;
        if ((cells[p.x][p.y] & 0x10) == 0) {
            s = new Point(p.x, p.y - 1);
            this.movePoint(s, outlist, frontlist);
        }
        if ((cells[p.x][p.y] & 0x20) == 0) {
            s = new Point(p.x + 1, p.y);
            this.movePoint(s, outlist, frontlist);
        }
        if ((cells[p.x][p.y] & 0x40) == 0) {
            s = new Point(p.x, p.y + 1);
            this.movePoint(s, outlist, frontlist);
        }
        if ((cells[p.x][p.y] & 0x80) == 0) {
            s = new Point(p.x - 1, p.y);
            this.movePoint(s, outlist, frontlist);
        }
    }

    private void movePoint(Point p, Vector<Point> v, Vector<Point> w) {
        int i = v.indexOf(p);
        if (i >= 0) {
            v.removeElementAt(i);
            w.addElement(p);
        }
    }

    private void removeWall(Point p, int d, int[][] cells) {
        int[] nArray = cells[p.x];
        int n = p.y;
        nArray[n] = nArray[n] ^ d;
        switch (d) {
            case 1: {
                int[] nArray2 = cells[p.x];
                int n2 = p.y - 1;
                nArray2[n2] = nArray2[n2] ^ 4;
                break;
            }
            case 2: {
                int[] nArray3 = cells[p.x + 1];
                int n3 = p.y;
                nArray3[n3] = nArray3[n3] ^ 8;
                break;
            }
            case 4: {
                int[] nArray4 = cells[p.x];
                int n4 = p.y + 1;
                nArray4[n4] = nArray4[n4] ^ 1;
                break;
            }
            case 8: {
                int[] nArray5 = cells[p.x - 1];
                int n5 = p.y;
                nArray5[n5] = nArray5[n5] ^ 2;
            }
        }
    }

    private int rnd(int n) {
        return (int)(Math.random() * (double)n + 1.0);
    }

    private Object rndElement(Vector<Point> v) {
        int i = this.rnd(v.size()) - 1;
        Point s = v.elementAt(i);
        v.removeElementAt(i);
        return s;
    }
}

