/*
 * Decompiled with CFR 0.152.
 */
package slick;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;

public class Inputs {
    private boolean[] keys = new boolean[348];
    private List<KeyEvent> keyevents;
    private List<MouseEvent> mouseevents;
    private List<ScrollEvent> scrollevents;
    private boolean[] buttons = new boolean[7];
    private double mousex = -1.0;
    private double mousey = -1.0;
    private int mousedx = 0;
    private int mousedy = 0;
    private int screen_width = 640;
    private int screen_height = 480;
    private boolean resized = false;
    private boolean invert = true;
    private volatile boolean first = true;
    private GLFWKeyCallback keyboard;
    private GLFWCursorPosCallback mouseMove;
    private GLFWMouseButtonCallback mouseButtons;
    private GLFWScrollCallback wheel;
    private GLFWFramebufferSizeCallback framesize;

    public Inputs(int w, int h) {
        this.screen_width = w;
        this.screen_height = h;
        this.do_init();
    }

    public Inputs() {
        this.do_init();
    }

    private void do_init() {
        this.keyevents = new ArrayList<KeyEvent>();
        this.mouseevents = new ArrayList<MouseEvent>();
        this.scrollevents = new ArrayList<ScrollEvent>();
        this.keyboard = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                if (key < 0 || key >= Inputs.this.keys.length) {
                    return;
                }
                ((Inputs)Inputs.this).keys[key] = action != 0;
                KeyEvent ke = new KeyEvent();
                ke.key = key;
                ke.isdown = Inputs.this.keys[key];
                if (Inputs.this.keyevents.size() < 20) {
                    Inputs.this.keyevents.add(ke);
                }
            }
        };
        this.mouseMove = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double inypos) {
                double ypos = inypos;
                if (Inputs.this.invert) {
                    ypos = (double)Inputs.this.screen_height - ypos;
                }
                if (Inputs.this.first) {
                    Inputs.this.mousex = (int)xpos;
                    Inputs.this.mousey = (int)ypos;
                    Inputs.this.first = false;
                }
                Inputs.this.mousedx = (int)(xpos - Inputs.this.mousex);
                Inputs.this.mousedy = (int)(ypos - Inputs.this.mousey);
                Inputs.this.mousex = (int)xpos;
                Inputs.this.mousey = (int)ypos;
                MouseEvent me = new MouseEvent();
                me.buttonevent = false;
                me.dx = Inputs.this.mousedx;
                me.dy = Inputs.this.mousedy;
                me.x = Inputs.this.mousex;
                me.y = Inputs.this.mousey;
                if (Inputs.this.mouseevents.size() < 50) {
                    Inputs.this.mouseevents.add(me);
                }
            }
        };
        this.mouseButtons = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                ((Inputs)Inputs.this).buttons[button] = action != 0;
                MouseEvent me = new MouseEvent();
                me.buttonevent = true;
                me.button = button;
                me.isdown = Inputs.this.buttons[button];
                me.dx = 0;
                me.dy = 0;
                Inputs.this.first = true;
                me.x = Inputs.this.mousex;
                me.y = Inputs.this.mousey;
                if (Inputs.this.mouseevents.size() < 50) {
                    Inputs.this.mouseevents.add(me);
                }
            }
        };
        this.wheel = new GLFWScrollCallback(){

            public void invoke(long window, double xpos, double ypos) {
                ScrollEvent me = new ScrollEvent();
                me.dx = (int)xpos;
                me.dy = (int)ypos;
                if (Inputs.this.scrollevents.size() < 50) {
                    Inputs.this.scrollevents.add(me);
                }
            }
        };
        this.framesize = new GLFWFramebufferSizeCallback(){

            public void invoke(long window, int w, int h) {
                if (w > 0 && h > 0) {
                    if (Inputs.this.screen_width != w || Inputs.this.screen_height != h) {
                        Inputs.this.resized = true;
                    }
                    Inputs.this.screen_width = w;
                    Inputs.this.screen_height = h;
                }
            }
        };
    }

    public GLFWKeyCallback getKeyboardCallback() {
        return this.keyboard;
    }

    public GLFWCursorPosCallback getMouseMoveCallback() {
        return this.mouseMove;
    }

    public GLFWMouseButtonCallback getMouseButtonsCallback() {
        return this.mouseButtons;
    }

    public GLFWFramebufferSizeCallback getFrameSizeCallback() {
        return this.framesize;
    }

    public GLFWScrollCallback getScrollCallback() {
        return this.wheel;
    }

    public int getScreenWidth() {
        return this.screen_width;
    }

    public int getScreenHeight() {
        return this.screen_height;
    }

    public void setScreenWidthHeight(int w, int h) {
        this.screen_width = w;
        this.screen_height = h;
    }

    public boolean isKeyDown(int key) {
        if (key < 0) {
            return false;
        }
        if (key >= this.keys.length) {
            return false;
        }
        return this.keys[key];
    }

    public boolean hasNextKey() {
        return this.keyevents.size() > 0;
    }

    public KeyEvent nextKey() {
        if (this.keyevents.size() > 0) {
            KeyEvent ke = this.keyevents.get(0);
            this.keyevents.remove(0);
            return ke;
        }
        return null;
    }

    public ScrollEvent nextScroll() {
        if (this.scrollevents.size() > 0) {
            ScrollEvent ke = this.scrollevents.get(0);
            this.scrollevents.remove(0);
            return ke;
        }
        return null;
    }

    public boolean knext() {
        if (this.keyevents.size() > 0) {
            if (this.keyevents.get((int)0).used) {
                this.keyevents.remove(0);
                if (this.keyevents.size() > 0) {
                    this.keyevents.get((int)0).used = true;
                } else {
                    return false;
                }
            }
            this.keyevents.get((int)0).used = true;
            return true;
        }
        return false;
    }

    public void kclear() {
        this.keyevents.clear();
    }

    public int getEventKey() {
        if (this.keyevents.size() > 0) {
            return this.keyevents.get((int)0).key;
        }
        return -1;
    }

    public boolean getEventKeyState() {
        if (this.keyevents.size() > 0) {
            return this.keyevents.get((int)0).isdown;
        }
        return false;
    }

    public int getCurMousex() {
        return (int)this.mousex;
    }

    public int getCurMousey() {
        return (int)this.mousey;
    }

    public int getCurMousedx() {
        return this.mousedx;
    }

    public int getCurMousedy() {
        return this.mousedy;
    }

    public int getEventx() {
        if (this.mouseevents.size() > 0) {
            return (int)this.mouseevents.get((int)0).x;
        }
        return -1;
    }

    public int getEventy() {
        if (this.mouseevents.size() > 0) {
            return (int)this.mouseevents.get((int)0).y;
        }
        return -1;
    }

    public int getEventdx() {
        if (this.mouseevents.size() > 0) {
            return this.mouseevents.get((int)0).dx;
        }
        return -1;
    }

    public int getEventdy() {
        if (this.mouseevents.size() > 0) {
            return this.mouseevents.get((int)0).dy;
        }
        return -1;
    }

    public boolean isButtonDown(int button) {
        return this.buttons[button];
    }

    public boolean hasNextButton() {
        int inext = this.mouseevents.size();
        int i = 0;
        while (i < inext) {
            if (this.mouseevents.get((int)i).buttonevent) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getEventButton() {
        if (this.mouseevents.size() > 0 && this.mouseevents.get((int)0).buttonevent) {
            return this.mouseevents.get((int)0).button;
        }
        return -1;
    }

    public boolean getEventButtonState() {
        if (this.mouseevents.size() > 0 && this.mouseevents.get((int)0).buttonevent) {
            return this.mouseevents.get((int)0).isdown;
        }
        return false;
    }

    public boolean mnext() {
        if (this.mouseevents.size() > 0) {
            if (this.mouseevents.get((int)0).used) {
                this.mouseevents.remove(0);
                if (this.mouseevents.size() > 0) {
                    this.mouseevents.get((int)0).used = true;
                } else {
                    return false;
                }
            }
            this.mouseevents.get((int)0).used = true;
            return true;
        }
        return false;
    }

    public void mclear() {
        this.mouseevents.clear();
        this.first = true;
    }

    public MouseEvent nextButton() {
        while (this.mouseevents.size() > 0) {
            MouseEvent me = this.mouseevents.get(0);
            this.mouseevents.remove(0);
            if (!me.buttonevent) continue;
            return me;
        }
        return null;
    }

    public void destroy() {
        this.keyboard.free();
        this.mouseMove.free();
        this.mouseButtons.free();
    }

    public boolean wasResized() {
        boolean was = this.resized;
        this.resized = false;
        return was;
    }

    public class KeyEvent {
        public int key;
        public boolean isdown;
        public boolean used = false;
    }

    public class MouseEvent {
        public boolean buttonevent = false;
        public boolean used = false;
        public int button = -1;
        public boolean isdown = false;
        public double x = 0.0;
        public double y = 0.0;
        public int dx = 0;
        public int dy = 0;
    }

    public class ScrollEvent {
        public int dx = 0;
        public int dy = 0;
    }
}

