/*
 * Decompiled with CFR 0.152.
 */
package slick;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import slick.Audio;
import slick.SoundStore;

public class AudioLoader {
    private static final String AIF = "AIF";
    private static final String WAV = "WAV";
    private static final String OGG = "OGG";
    private static final String MOD = "MOD";
    private static final String XM = "XM";
    private static boolean inited = false;

    private static void init() {
        if (!inited) {
            SoundStore.get().init();
            inited = true;
        }
    }

    public static Audio getAudio(String format, InputStream in) throws IOException {
        AudioLoader.init();
        format.equals(AIF);
        if (format.equals(WAV)) {
            return SoundStore.get().getWAV(in);
        }
        format.equals(OGG);
        throw new IOException("Unsupported format for non-streaming Audio: " + format);
    }

    public static Audio getStreamingAudio(String format, URL url) throws IOException {
        AudioLoader.init();
        format.equals(OGG);
        if (format.equals(MOD)) {
            return SoundStore.get().getMOD(url.openStream());
        }
        if (format.equals(XM)) {
            return SoundStore.get().getMOD(url.openStream());
        }
        throw new IOException("Unsupported format for streaming Audio: " + format);
    }

    public static void update() {
        AudioLoader.init();
        SoundStore.get().poll(0);
    }
}

