/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractImageBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.EnumeratedBundlerParam;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacAppBundler
extends AbstractImageBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacAppBundler.class.getName());
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String LIBRARY_NAME = "libpackager.dylib";
    private static final String TEMPLATE_BUNDLE_ICON = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String TEMPLATE_INFO_PLIST_LEGACY = "Info.plist.template";
    private static final String TEMPLATE_INFO_PLIST_LITE = "Info-lite.plist.template";
    public static final BundlerParamInfo<Boolean> MAC_CONFIGURE_LAUNCHER_IN_PLIST = new StandardBundlerParam<Boolean>(I18N.getString("param.configure-launcher-in-plist"), I18N.getString("param.configure-launcher-in-plist.description"), "mac.configure-launcher-in-plist", Boolean.class, params -> Boolean.FALSE, (s, p) -> Boolean.valueOf(s));
    public static final EnumeratedBundlerParam<String> MAC_CATEGORY = new EnumeratedBundlerParam<String>(I18N.getString("param.category-name"), I18N.getString("param.category-name.description"), "mac.category", String.class, params -> params.containsKey(StandardBundlerParam.CATEGORY.getID()) ? (String)StandardBundlerParam.CATEGORY.fetchFrom((Map<String, Object>)params) : "Unknown", (s, p) -> s, MacAppBundler.getMacCategories(), false);
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_NAME = new StandardBundlerParam<String>(I18N.getString("param.cfbundle-name.name"), I18N.getString("param.cfbundle-name.description"), "mac.CFBundleName", String.class, params -> null, (s, p) -> s);
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_IDENTIFIER = new StandardBundlerParam<String>(I18N.getString("param.cfbundle-identifier.name"), I18N.getString("param.cfbundle-identifier.description"), "mac.CFBundleIdentifier", String.class, StandardBundlerParam.IDENTIFIER::fetchFrom, (s, p) -> s);
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_VERSION = new StandardBundlerParam<String>(I18N.getString("param.cfbundle-version.name"), I18N.getString("param.cfbundle-version.description"), "mac.CFBundleVersion", String.class, p -> {
        String s = (String)StandardBundlerParam.VERSION.fetchFrom((Map<String, Object>)p);
        if (MacAppBundler.validCFBundleVersion(s)) {
            return s;
        }
        return "100";
    }, (s, p) -> s);
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> {
        File configRoot = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "macosx");
        configRoot.mkdirs();
        return configRoot;
    }, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL = new StandardBundlerParam<URL>(I18N.getString("param.raw-executable-url.name"), I18N.getString("param.raw-executable-url.description"), "mac.launcher.url", URL.class, params -> MacResources.class.getResource(EXECUTABLE_NAME), (s, p) -> {
        try {
            return new URL((String)s);
        }
        catch (MalformedURLException e) {
            Log.info(e.toString());
            return null;
        }
    });
    public static final BundlerParamInfo<String> DEFAULT_ICNS_ICON = new StandardBundlerParam<String>(I18N.getString("param.default-icon-icns"), I18N.getString("param.default-icon-icns.description"), ".mac.default.icns", String.class, params -> "GenericApp.icns", (s, p) -> s);
    public static final BundlerParamInfo<JreUtils.Rule[]> MAC_RULES = new StandardBundlerParam<JreUtils.Rule[]>("", "", ".mac.runtime.rules", JreUtils.Rule[].class, MacAppBundler::createMacRuntimeRules, (s, p) -> null);
    public static final BundlerParamInfo<RelativeFileSet> MAC_RUNTIME = new StandardBundlerParam<RelativeFileSet>(I18N.getString("param.runtime.name"), I18N.getString("param.runtime.description"), "runtime", RelativeFileSet.class, params -> MacAppBundler.extractMacRuntime(System.getProperty("java.home"), params), MacAppBundler::extractMacRuntime);
    public static final BundlerParamInfo<String> DEVELOPER_ID_APP_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-developer-id-app.name"), I18N.getString("param.signing-key-developer-id-app.description"), "mac.signing-key-developer-id-app", String.class, params -> MacBaseInstallerBundler.findKey("Developer ID Application: " + MacBaseInstallerBundler.SIGNING_KEY_USER.fetchFrom((Map<String, Object>)params), MacBaseInstallerBundler.SIGNING_KEYCHAIN.fetchFrom((Map<String, Object>)params), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)params)), (s, p) -> s);
    public static final BundlerParamInfo<String> BUNDLE_ID_SIGNING_PREFIX = new StandardBundlerParam<String>(I18N.getString("param.bundle-id-signing-prefix.name"), I18N.getString("param.bundle-id-signing-prefix.description"), "mac.bundle-id-signing-prefix", String.class, params -> (String)StandardBundlerParam.IDENTIFIER.fetchFrom((Map<String, Object>)params) + ".", (s, p) -> s);
    public static final BundlerParamInfo<File> ICON_ICNS = new StandardBundlerParam<File>(I18N.getString("param.icon-icns.name"), I18N.getString("param.icon-icns.description"), "icon.icns", File.class, params -> {
        File f = (File)StandardBundlerParam.ICON.fetchFrom((Map<String, Object>)params);
        if (f != null && !f.getName().toLowerCase().endsWith(".icns")) {
            Log.info(MessageFormat.format(I18N.getString("message.icon-not-icns"), f));
            return null;
        }
        return f;
    }, (s, p) -> new File((String)s));

    private static Map<String, String> getMacCategories() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Business", "public.app-category.business");
        map.put("Developer Tools", "public.app-category.developer-tools");
        map.put("Education", "public.app-category.education");
        map.put("Entertainment", "public.app-category.entertainment");
        map.put("Finance", "public.app-category.finance");
        map.put("Games", "public.app-category.games");
        map.put("Graphics & Design", "public.app-category.graphics-design");
        map.put("Healthcare & Fitness", "public.app-category.healthcare-fitness");
        map.put("Lifestyle", "public.app-category.lifestyle");
        map.put("Medical", "public.app-category.medical");
        map.put("Music", "public.app-category.music");
        map.put("News", "public.app-category.news");
        map.put("Photography", "public.app-category.photography");
        map.put("Productivity", "public.app-category.productivity");
        map.put("Reference", "public.app-category.reference");
        map.put("Social Networking", "public.app-category.social-networking");
        map.put("Sports", "public.app-category.sports");
        map.put("Travel", "public.app-category.travel");
        map.put("Utilities", "public.app-category.utilities");
        map.put("Video", "public.app-category.video");
        map.put("Weather", "public.app-category.weather");
        map.put("Action Games", "public.app-category.action-games");
        map.put("Adventure Games", "public.app-category.adventure-games");
        map.put("Arcade Games", "public.app-category.arcade-games");
        map.put("Board Games", "public.app-category.board-games");
        map.put("Card Games", "public.app-category.card-games");
        map.put("Casino Games", "public.app-category.casino-games");
        map.put("Dice Games", "public.app-category.dice-games");
        map.put("Educational Games", "public.app-category.educational-games");
        map.put("Family Games", "public.app-category.family-games");
        map.put("Kids Games", "public.app-category.kids-games");
        map.put("Music Games", "public.app-category.music-games");
        map.put("Puzzle Games", "public.app-category.puzzle-games");
        map.put("Racing Games", "public.app-category.racing-games");
        map.put("Role Playing Games", "public.app-category.role-playing-games");
        map.put("Simulation Games", "public.app-category.simulation-games");
        map.put("Sports Games", "public.app-category.sports-games");
        map.put("Strategy Games", "public.app-category.strategy-games");
        map.put("Trivia Games", "public.app-category.trivia-games");
        map.put("Word Games", "public.app-category.word-games");
        return map;
    }

    public static RelativeFileSet extractMacRuntime(String base, Map<String, ? super Object> params) {
        if (base.isEmpty()) {
            return null;
        }
        File workingBase = new File(base);
        workingBase = workingBase.getAbsoluteFile();
        try {
            workingBase = workingBase.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (workingBase.getName().equals("jre")) {
            workingBase = workingBase.getParentFile();
        }
        if (workingBase.getName().equals("Home")) {
            workingBase = workingBase.getParentFile();
        }
        if (workingBase.getName().equals("Contents")) {
            workingBase = workingBase.getParentFile();
        }
        return JreUtils.extractJreAsRelativeFileSet(workingBase.toString(), MAC_RULES.fetchFrom(params), true);
    }

    public MacAppBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    @Override
    protected String getCacheLocation(Map<String, ? super Object> params) {
        return "$CACHEDIR/";
    }

    public static boolean validCFBundleVersion(String v) {
        if (v == null) {
            return false;
        }
        String[] p = v.split("\\.");
        if (p.length > 3 || p.length < 1) {
            Log.verbose(I18N.getString("message.version-string-too-many-components"));
            return false;
        }
        try {
            BigInteger n = new BigInteger(p[0]);
            if (BigInteger.ONE.compareTo(n) > 0) {
                Log.verbose(I18N.getString("message.version-string-first-number-not-zero"));
                return false;
            }
            if (p.length > 1 && BigInteger.ZERO.compareTo(n = new BigInteger(p[1])) > 0) {
                Log.verbose(I18N.getString("message.version-string-no-negative-numbers"));
                return false;
            }
            if (p.length > 2 && BigInteger.ZERO.compareTo(n = new BigInteger(p[2])) > 0) {
                Log.verbose(I18N.getString("message.version-string-no-negative-numbers"));
                return false;
            }
        }
        catch (NumberFormatException ne) {
            Log.verbose(I18N.getString("message.version-string-numbers-only"));
            Log.verbose(ne);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        try {
            return this.doValidate(params);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    public boolean doValidate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        String signingIdentity;
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            throw new UnsupportedPlatformException();
        }
        this.imageBundleValidation(p);
        if (MacBaseInstallerBundler.getPredefinedImage(p) != null) {
            return true;
        }
        RelativeFileSet runtime = MAC_RUNTIME.fetchFrom(p);
        if (runtime != null) {
            if ("jre".equals((runtime = new RelativeFileSet(runtime)).getBaseDirectory().getName())) {
                runtime.upshift();
            }
            if ("Home".equals(runtime.getBaseDirectory().getName())) {
                runtime.upshift();
            }
            if ("Contents".equals(runtime.getBaseDirectory().getName())) {
                runtime.upshift();
            }
        }
        this.testRuntime(runtime, new String[]{"Contents/Home/(jre/)?lib/[^/]+/libjvm.dylib", "Contents/Home/(jre/)?lib/rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(p)).booleanValue()) {
            this.testRuntime(runtime, new String[]{"Contents/Home/(jre/)?lib/ext/jfxrt.jar", "Contents/Home/(jre/)?lib/jfxrt.jar"});
        }
        if (!MacAppBundler.validCFBundleVersion(MAC_CF_BUNDLE_VERSION.fetchFrom(p))) {
            throw new ConfigException(I18N.getString("error.invalid-cfbundle-version"), I18N.getString("error.invalid-cfbundle-version.advice"));
        }
        if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(p)).orElse(Boolean.FALSE).booleanValue() && (signingIdentity = DEVELOPER_ID_APP_SIGNING_KEY.fetchFrom(p)) == null) {
            throw new ConfigException(I18N.getString("error.explicit-sign-no-cert"), I18N.getString("error.explicit-sign-no-cert.advice"));
        }
        return true;
    }

    private File getConfig_InfoPlist(Map<String, ? super Object> params) {
        return new File(CONFIG_ROOT.fetchFrom(params), "Info.plist");
    }

    private File getConfig_Icon(Map<String, ? super Object> params) {
        return new File(CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".icns");
    }

    private void prepareConfigFiles(Map<String, ? super Object> params) throws IOException {
        File infoPlistFile = this.getConfig_InfoPlist(params);
        infoPlistFile.createNewFile();
        this.writeInfoPlist(infoPlistFile, params);
        this.prepareIcon(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doBundle(Map<String, ? super Object> p, File outputDirectory, boolean dependentTask) {
        File rootDirectory;
        block18: {
            HashMap<String, ? super Object> originalParams;
            block16: {
                File file;
                block17: {
                    rootDirectory = null;
                    originalParams = new HashMap<String, Object>(p);
                    if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
                        throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outputDirectory.getAbsolutePath()));
                    }
                    if (!outputDirectory.canWrite()) {
                        throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outputDirectory.getAbsolutePath()));
                    }
                    File predefinedImage = MacBaseInstallerBundler.getPredefinedImage(p);
                    if (predefinedImage == null) break block16;
                    file = predefinedImage;
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block17;
                    this.cleanupConfigFiles(p);
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
                return file;
            }
            try {
                String signingIdentity;
                StandardBundlerParam.BUILD_ROOT.fetchFrom(p);
                this.prepareConfigFiles(p);
                rootDirectory = new File(outputDirectory, (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + ".app");
                IOUtils.deleteRecursive(rootDirectory);
                rootDirectory.mkdirs();
                if (!dependentTask) {
                    Log.info(MessageFormat.format(I18N.getString("message.creating-app-bundle"), rootDirectory.getAbsolutePath()));
                }
                File contentsDirectory = new File(rootDirectory, "Contents");
                contentsDirectory.mkdirs();
                File macOSDirectory = new File(contentsDirectory, "MacOS");
                macOSDirectory.mkdirs();
                File javaDirectory = new File(contentsDirectory, "Java");
                javaDirectory.mkdirs();
                File plugInsDirectory = new File(contentsDirectory, "PlugIns");
                File resourcesDirectory = new File(contentsDirectory, "Resources");
                resourcesDirectory.mkdirs();
                File pkgInfoFile = new File(contentsDirectory, "PkgInfo");
                pkgInfoFile.createNewFile();
                this.writePkgInfo(pkgInfoFile);
                File executableFile = new File(macOSDirectory, this.getLauncherName(p));
                IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(p), executableFile);
                IOUtils.copyFromURL(MacResources.class.getResource(LIBRARY_NAME), new File(macOSDirectory, LIBRARY_NAME));
                if (!MAC_CONFIGURE_LAUNCHER_IN_PLIST.fetchFrom(p).booleanValue()) {
                    if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(p)).equals("prop")) {
                        this.writeCfgFile(p, rootDirectory);
                    } else {
                        this.writeCfgFile(p, new File(rootDirectory, MacAppBundler.getLauncherCfgName(p)), this.getRuntimeLocation(p));
                    }
                }
                executableFile.setExecutable(true, false);
                this.copyRuntime(plugInsDirectory, p);
                this.copyClassPathEntries(javaDirectory, p);
                IOUtils.copyFile(this.getConfig_Icon(p), new File(resourcesDirectory, this.getConfig_Icon(p).getName()));
                for (Object fa : (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(p)) {
                    File f = (File)StandardBundlerParam.FA_ICON.fetchFrom((Map<String, Object>)fa);
                    if (f == null || !f.exists()) continue;
                    IOUtils.copyFile(f, new File(resourcesDirectory, f.getName()));
                }
                IOUtils.copyFile(this.getConfig_InfoPlist(p), new File(contentsDirectory, "Info.plist"));
                List entryPoints = (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(p);
                for (Map entryPoint : entryPoints) {
                    HashMap<String, ? super Object> tmp = new HashMap<String, Object>(originalParams);
                    tmp.putAll(entryPoint);
                    this.createLauncherForEntryPoint(tmp, rootDirectory);
                }
                if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(p)).orElse(Boolean.TRUE).booleanValue() && (signingIdentity = DEVELOPER_ID_APP_SIGNING_KEY.fetchFrom(p)) != null) {
                    MacBaseInstallerBundler.signAppBundle(p, rootDirectory, signingIdentity, BUNDLE_ID_SIGNING_PREFIX.fetchFrom(p));
                }
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block18;
                this.cleanupConfigFiles(p);
            }
            catch (IOException ex) {
                File file;
                block19: {
                    try {
                        Log.info(ex.toString());
                        Log.verbose(ex);
                        file = null;
                        if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block19;
                        this.cleanupConfigFiles(p);
                    }
                    catch (Throwable throwable) {
                        if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                            this.cleanupConfigFiles(p);
                        } else {
                            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
                        }
                        throw throwable;
                    }
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
                return file;
            }
        }
        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
        return rootDirectory;
    }

    public void cleanupConfigFiles(Map<String, ? super Object> params) {
        if (CONFIG_ROOT.fetchFrom(params) != null) {
            this.getConfig_Icon(params).delete();
            this.getConfig_InfoPlist(params).delete();
        }
    }

    private void copyClassPathEntries(File javaDirectory, Map<String, ? super Object> params) throws IOException {
        List resourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params);
        if (resourcesList == null) {
            throw new RuntimeException(I18N.getString("message.null-classpath"));
        }
        for (RelativeFileSet classPath : resourcesList) {
            File srcdir = classPath.getBaseDirectory();
            for (String fname : classPath.getIncludedFiles()) {
                IOUtils.copyFile(new File(srcdir, fname), new File(javaDirectory, fname));
            }
        }
    }

    private void copyRuntime(File plugInsDirectory, Map<String, ? super Object> params) throws IOException {
        RelativeFileSet runtime = MAC_RUNTIME.fetchFrom(params);
        if (runtime == null) {
            return;
        }
        if ("jre".equals((runtime = new RelativeFileSet(runtime)).getBaseDirectory().getName())) {
            runtime.upshift();
        }
        if ("Home".equals(runtime.getBaseDirectory().getName())) {
            runtime.upshift();
        }
        if ("Contents".equals(runtime.getBaseDirectory().getName())) {
            runtime.upshift();
        }
        plugInsDirectory.mkdirs();
        File srcdir = runtime.getBaseDirectory();
        File destDir = new File(plugInsDirectory, "Java.runtime");
        Set<String> filesToCopy = runtime.getIncludedFiles();
        for (String fname : filesToCopy) {
            IOUtils.copyFile(new File(srcdir, fname), new File(destDir, fname));
        }
    }

    private void prepareIcon(Map<String, ? super Object> params) throws IOException {
        File icon = ICON_ICNS.fetchFrom(params);
        if (icon == null || !icon.exists()) {
            this.fetchResource(MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".icns", "icon", DEFAULT_ICNS_ICON.fetchFrom(params), this.getConfig_Icon(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        } else {
            this.fetchResource(MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".icns", "icon", icon, this.getConfig_Icon(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        }
    }

    private String getLauncherName(Map<String, ? super Object> params) {
        if (StandardBundlerParam.APP_NAME.fetchFrom(params) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(params);
        }
        return (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params);
    }

    private String getBundleName(Map<String, ? super Object> params) {
        if (MAC_CF_BUNDLE_NAME.fetchFrom(params) != null) {
            String bn = MAC_CF_BUNDLE_NAME.fetchFrom(params);
            if (bn.length() > 16) {
                Log.info(MessageFormat.format(I18N.getString("message.bundle-name-too-long-warning"), MAC_CF_BUNDLE_NAME.getID(), bn));
            }
            return MAC_CF_BUNDLE_NAME.fetchFrom(params);
        }
        if (StandardBundlerParam.APP_NAME.fetchFrom(params) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(params);
        }
        String nm = (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params);
        if (nm.length() > 16) {
            nm = nm.substring(0, 16);
        }
        return nm;
    }

    private String getRuntimeLocation(Map<String, ? super Object> params) {
        if (MAC_RUNTIME.fetchFrom(params) == null) {
            return "";
        }
        return "$APPDIR/PlugIns/Java.runtime";
    }

    private void writeInfoPlist(File file, Map<String, ? super Object> params) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-info-plist"), file.getAbsolutePath()));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("DEPLOY_ICON_FILE", this.getConfig_Icon(params).getName());
        data.put("DEPLOY_BUNDLE_IDENTIFIER", MAC_CF_BUNDLE_IDENTIFIER.fetchFrom(params));
        data.put("DEPLOY_BUNDLE_NAME", this.getBundleName(params));
        data.put("DEPLOY_BUNDLE_COPYRIGHT", StandardBundlerParam.COPYRIGHT.fetchFrom(params) != null ? (String)StandardBundlerParam.COPYRIGHT.fetchFrom(params) : "Unknown");
        data.put("DEPLOY_LAUNCHER_NAME", this.getLauncherName(params));
        if (MAC_RUNTIME.fetchFrom(params) != null) {
            data.put("DEPLOY_JAVA_RUNTIME_NAME", "$APPDIR/PlugIns/Java.runtime");
        } else {
            data.put("DEPLOY_JAVA_RUNTIME_NAME", "");
        }
        data.put("DEPLOY_BUNDLE_SHORT_VERSION", StandardBundlerParam.VERSION.fetchFrom(params) != null ? (String)StandardBundlerParam.VERSION.fetchFrom(params) : "1.0.0");
        data.put("DEPLOY_BUNDLE_CFBUNDLE_VERSION", MAC_CF_BUNDLE_VERSION.fetchFrom(params) != null ? MAC_CF_BUNDLE_VERSION.fetchFrom(params) : "100");
        data.put("DEPLOY_BUNDLE_CATEGORY", MAC_CATEGORY.validatedFetchFrom(params));
        data.put("DEPLOY_MAIN_JAR_NAME", ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(params)).getIncludedFiles().iterator().next());
        data.put("DEPLOY_PREFERENCES_ID", ((String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(params)).toLowerCase());
        StringBuilder sb = new StringBuilder();
        List jvmOptions = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(params);
        String newline = "";
        for (Object o : jvmOptions) {
            sb.append(newline).append("    <string>").append((String)o).append("</string>");
            newline = "\n";
        }
        Map jvmProps = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params);
        for (Map.Entry entry : jvmProps.entrySet()) {
            sb.append(newline).append("    <string>-D").append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("</string>");
            newline = "\n";
        }
        String preloader = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(params);
        if (preloader != null) {
            sb.append(newline).append("    <string>-Djavafx.preloader=").append(preloader).append("</string>");
        }
        data.put("DEPLOY_JVM_OPTIONS", sb.toString());
        sb = new StringBuilder();
        List list = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(params);
        newline = "";
        for (Object o : list) {
            sb.append(newline).append("    <string>").append((String)o).append("</string>");
            newline = "\n";
        }
        data.put("DEPLOY_ARGUMENTS", sb.toString());
        newline = "";
        sb = new StringBuilder();
        Map overridableJVMOptions = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(params);
        for (Map.Entry entry : overridableJVMOptions.entrySet()) {
            sb.append(newline).append("      <key>").append((String)entry.getKey()).append("</key>\n").append("      <string>").append((String)entry.getValue()).append("</string>");
            newline = "\n";
        }
        data.put("DEPLOY_JVM_USER_OPTIONS", sb.toString());
        data.put("DEPLOY_LAUNCHER_CLASS", (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params));
        StringBuilder macroedPath = new StringBuilder();
        for (String s : ((String)StandardBundlerParam.CLASSPATH.fetchFrom(params)).split("[ ;:]+")) {
            macroedPath.append(s);
            macroedPath.append(":");
        }
        macroedPath.deleteCharAt(macroedPath.length() - 1);
        data.put("DEPLOY_APP_CLASSPATH", macroedPath.toString());
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder exportedTypes = new StringBuilder();
        for (Map fileAssociation : (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(params)) {
            List extensions = (List)StandardBundlerParam.FA_EXTENSIONS.fetchFrom(fileAssociation);
            if (extensions == null) {
                Log.info(I18N.getString("message.creating-association-with-null-extension"));
            }
            List mimeTypes = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(fileAssociation);
            String itemContentType = MAC_CF_BUNDLE_IDENTIFIER.fetchFrom(params) + "." + (extensions == null || extensions.isEmpty() ? "mime" : (String)extensions.get(0));
            String description = (String)StandardBundlerParam.FA_DESCRIPTION.fetchFrom(fileAssociation);
            File icon = (File)StandardBundlerParam.FA_ICON.fetchFrom(fileAssociation);
            stringBuilder.append("    <dict>\n").append("      <key>LSItemContentTypes</key>\n").append("      <array>\n").append("        <string>").append(itemContentType).append("</string>\n").append("      </array>\n").append("\n").append("      <key>CFBundleTypeName</key>\n").append("      <string>").append(description).append("</string>\n").append("\n").append("      <key>LSHandlerRank</key>\n").append("      <string>Owner</string>\n").append("\n").append("      <key>CFBundleTypeRole</key>\n").append("      <string>Editor</string>\n").append("\n").append("      <key>LSIsAppleDefaultForType</key>\n").append("      <true/>\n").append("\n");
            if (icon != null && icon.exists()) {
                stringBuilder.append("      <key>CFBundleTypeIconFile</key>\n").append("      <string>").append(icon.getName()).append("</string>\n");
            }
            stringBuilder.append("    </dict>\n");
            exportedTypes.append("    <dict>\n").append("      <key>UTTypeIdentifier</key>\n").append("      <string>").append(itemContentType).append("</string>\n").append("\n").append("      <key>UTTypeDescription</key>\n").append("      <string>").append(description).append("</string>\n").append("      <key>UTTypeConformsTo</key>\n").append("      <array>\n").append("          <string>public.data</string>\n").append("      </array>\n").append("\n");
            if (icon != null && icon.exists()) {
                exportedTypes.append("      <key>UTTypeIconFile</key>\n").append("      <string>").append(icon.getName()).append("</string>\n").append("\n");
            }
            exportedTypes.append("\n").append("      <key>UTTypeTagSpecification</key>\n").append("      <dict>\n").append("\n");
            if (extensions != null && !extensions.isEmpty()) {
                exportedTypes.append("        <key>public.filename-extension</key>\n").append("        <array>\n");
                for (String ext : extensions) {
                    exportedTypes.append("          <string>").append(ext).append("</string>\n");
                }
                exportedTypes.append("        </array>\n");
            }
            if (mimeTypes != null && !mimeTypes.isEmpty()) {
                exportedTypes.append("        <key>public.mime-type</key>\n").append("        <array>\n");
                for (String mime : mimeTypes) {
                    exportedTypes.append("          <string>").append(mime).append("</string>\n");
                }
                exportedTypes.append("        </array>\n");
            }
            exportedTypes.append("      </dict>\n").append("    </dict>\n");
        }
        String associationData = stringBuilder.length() > 0 ? "\n  <key>CFBundleDocumentTypes</key>\n  <array>\n" + stringBuilder.toString() + "  </array>\n\n  <key>UTExportedTypeDeclarations</key>\n  <array>\n" + exportedTypes.toString() + "  </array>\n" : "";
        data.put("DEPLOY_FILE_ASSOCIATIONS", associationData);
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        w.write(this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getConfig_InfoPlist(params).getName(), I18N.getString("resource.bundle-config-file"), MAC_CONFIGURE_LAUNCHER_IN_PLIST.fetchFrom(params) != false ? TEMPLATE_INFO_PLIST_LEGACY : TEMPLATE_INFO_PLIST_LITE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params)));
        ((Writer)w).close();
    }

    private void writePkgInfo(File file) throws IOException {
        String signature = "????";
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            out.write(OS_TYPE_CODE + signature);
            ((Writer)out).flush();
        }
    }

    public static JreUtils.Rule[] createMacRuntimeRules(Map<String, ? super Object> params) {
        boolean isJDK;
        boolean isJRE;
        Object o;
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            return null;
        }
        ArrayList<JreUtils.Rule> rules = new ArrayList<JreUtils.Rule>();
        File baseDir = params.containsKey(MAC_RUNTIME.getID()) ? ((o = params.get(MAC_RUNTIME.getID())) instanceof RelativeFileSet ? ((RelativeFileSet)o).getBaseDirectory() : new File(o.toString())) : new File(System.getProperty("java.home"));
        if (!baseDir.exists()) {
            throw new RuntimeException(I18N.getString("error.non-existent-runtime"), new ConfigException(I18N.getString("error.non-existent-runtime"), I18N.getString("error.non-existent-runtime.advice")));
        }
        try {
            String path = baseDir.getCanonicalPath();
            if (path.endsWith("/Contents/Home/jre")) {
                baseDir = baseDir.getParentFile().getParentFile().getParentFile();
            } else if (path.endsWith("/Contents/Home")) {
                baseDir = baseDir.getParentFile().getParentFile();
            }
            isJRE = new File(baseDir, "Contents/Home/lib/jli/libjli.dylib").exists();
            isJDK = new File(baseDir, "Contents/Home/jre/lib/jli/libjli.dylib").exists();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!isJRE && !isJDK) {
            throw new RuntimeException(I18N.getString("error.cannot-detect-runtime-in-directory"), new ConfigException(I18N.getString("error.cannot-detect-runtime-in-directory"), I18N.getString("error.cannot-detect-runtime-in-directory.advice")));
        }
        rules.add(JreUtils.Rule.suffix("/contents/info.plist"));
        if (isJRE) {
            rules.add(JreUtils.Rule.suffixNeg("/contents/disabled.plist"));
            rules.add(JreUtils.Rule.suffixNeg("/contents/enabled.plist"));
            rules.add(JreUtils.Rule.substrNeg("/contents/frameworks/"));
        }
        rules.add(JreUtils.Rule.suffixNeg("home/bin"));
        if (isJDK) {
            rules.add(JreUtils.Rule.suffixNeg("home/jre/bin"));
        }
        if (isJRE) {
            rules.add(JreUtils.Rule.suffixNeg("resources"));
            rules.add(JreUtils.Rule.suffixNeg("lib/nibs"));
            rules.add(JreUtils.Rule.suffixNeg("lib/libnpjp2.dylib"));
            rules.add(JreUtils.Rule.suffixNeg("lib/security/javaws.policy"));
            rules.add(JreUtils.Rule.suffixNeg("lib/shortcuts"));
            rules.add(JreUtils.Rule.suffixNeg("lib/deploy"));
            rules.add(JreUtils.Rule.suffixNeg("lib/deploy.jar"));
            rules.add(JreUtils.Rule.suffixNeg("lib/javaws.jar"));
            rules.add(JreUtils.Rule.suffixNeg("lib/libdeploy.dylib"));
            rules.add(JreUtils.Rule.suffixNeg("lib/plugin.jar"));
        }
        rules.add(JreUtils.Rule.suffixNeg("home/man"));
        if (isJDK) {
            rules.add(JreUtils.Rule.suffixNeg("home/db"));
            rules.add(JreUtils.Rule.suffixNeg("home/demo"));
            rules.add(JreUtils.Rule.suffixNeg("home/include"));
            rules.add(JreUtils.Rule.suffixNeg("home/lib"));
            rules.add(JreUtils.Rule.suffixNeg("home/sample"));
            rules.add(JreUtils.Rule.suffixNeg("home/src.zip"));
            rules.add(JreUtils.Rule.suffixNeg("home/javafx-src.zip"));
        }
        rules.add(JreUtils.Rule.suffixNeg("home/rt"));
        rules.add(JreUtils.Rule.suffixNeg("lib/jfr.jar"));
        return rules.toArray(new JreUtils.Rule[rules.size()]);
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "mac.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return MacAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.ARGUMENTS, BUNDLE_ID_SIGNING_PREFIX, StandardBundlerParam.CLASSPATH, DEVELOPER_ID_APP_SIGNING_KEY, ICON_ICNS, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, MAC_CATEGORY, MAC_CF_BUNDLE_IDENTIFIER, MAC_CF_BUNDLE_NAME, MAC_CF_BUNDLE_VERSION, MAC_RUNTIME, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.PRELOADER_CLASS, MacBaseInstallerBundler.SIGNING_KEYCHAIN, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.doBundle(params, outputParentDir, false);
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> p, File rootDirectory) throws IOException {
        this.prepareConfigFiles(p);
        if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(p)).equals("prop")) {
            this.writeCfgFile(p, rootDirectory);
        } else {
            this.writeCfgFile(p, new File(rootDirectory, MacAppBundler.getLauncherCfgName(p)), "$APPDIR/PlugIns/Java.runtime");
        }
        File executableFile = new File(rootDirectory, "Contents/MacOS/" + this.getLauncherName(p));
        IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(p), executableFile);
        executableFile.setExecutable(true, false);
    }

    public static String getLauncherCfgName(Map<String, ? super Object> p) {
        return "Contents/Java/" + (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + ".cfg";
    }

    private void writeCfgFile(Map<String, ? super Object> params, File rootDir) throws FileNotFoundException {
        File pkgInfoFile = new File(rootDir, MacAppBundler.getLauncherCfgName(params));
        pkgInfoFile.delete();
        PrintStream out = new PrintStream(pkgInfoFile);
        out.println("app.runtime=" + this.getRuntimeLocation(params));
        out.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(params)).getIncludedFiles().iterator().next());
        out.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(params));
        out.println("app.id=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params));
        out.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(params));
        out.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params));
        out.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params)).replaceAll("\\.", "/"));
        out.println("app.classpath=" + (String)StandardBundlerParam.CLASSPATH.fetchFrom(params));
        List jvmargs = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(params);
        int idx = 1;
        for (Object a : jvmargs) {
            out.println("jvmarg." + idx + "=" + (String)a);
            ++idx;
        }
        Map jvmProps = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params);
        for (Map.Entry entry : jvmProps.entrySet()) {
            out.println("jvmarg." + idx + "=-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            ++idx;
        }
        String preloader = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(params);
        if (preloader != null) {
            out.println("jvmarg." + idx + "=-Djavafx.preloader=" + preloader);
        }
        Map map = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(params);
        idx = 1;
        for (Map.Entry arg : map.entrySet()) {
            if (arg.getKey() == null || arg.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                out.println("jvmuserarg." + idx + ".name=" + (String)arg.getKey());
                out.println("jvmuserarg." + idx + ".value=" + (String)arg.getValue());
            }
            ++idx;
        }
        List args = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(params);
        idx = 1;
        for (String a : args) {
            out.println("arg." + idx + "=" + a);
            ++idx;
        }
        out.close();
    }

    @Override
    public void extractRuntimeFlags(Map<String, ? super Object> params) {
        if (params.containsKey(".runtime.autodetect")) {
            return;
        }
        params.put(".runtime.autodetect", "attempted");
        RelativeFileSet runtime = MAC_RUNTIME.fetchFrom(params);
        if (runtime == null) {
            params.put(".runtime.autodetect", "systemjre");
        } else {
            File workingBase = runtime.getBaseDirectory();
            if (workingBase.getName().equals("jre")) {
                workingBase = workingBase.getParentFile();
            }
            if (workingBase.getName().equals("Home")) {
                workingBase = workingBase.getParentFile();
            }
            if (workingBase.getName().equals("Contents")) {
                workingBase = workingBase.getParentFile();
            }
            try {
                byte[] infoPlistBytes = Files.readAllBytes(workingBase.toPath().resolve(Paths.get("Contents", "Info.plist")));
                String infoPlist = new String(infoPlistBytes);
                Pattern cfBundleVersionMatcher = Pattern.compile("<key>CFBundleVersion</key>\\s*<string>([^<]+)</string>");
                Matcher m = cfBundleVersionMatcher.matcher(infoPlist);
                if (m.find()) {
                    AbstractImageBundler.extractFlagsFromVersion(params, "java version \"" + m.group(1) + "\"\n");
                    params.put(".runtime.autodetect", "succeeded");
                } else {
                    params.put(".runtime.autodetect", "failed");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                params.put(".runtime.autodetect", "failed");
            }
        }
    }
}

