/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.linux.LinuxResources;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class LinuxDebBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(LinuxDebBundler.class.getName());
    public static final BundlerParamInfo<LinuxAppBundler> APP_BUNDLER = new StandardBundlerParam<LinuxAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "linux.app.bundler", LinuxAppBundler.class, params -> new LinuxAppBundler(), (s, p) -> null);
    private static final Pattern DEB_BUNDLE_NAME_PATTERN = Pattern.compile("^[a-z][a-z\\d\\+\\-\\.]+");
    public static final BundlerParamInfo<String> BUNDLE_NAME = new StandardBundlerParam<String>(I18N.getString("param.bundle-name.name"), I18N.getString("param.bundle-name.description"), "linux.bundleName", String.class, params -> {
        String nm = (String)StandardBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)params);
        if (nm == null) {
            return null;
        }
        nm = nm.toLowerCase().replaceAll("[ _]", "-");
        return nm;
    }, (s, p) -> {
        if (!DEB_BUNDLE_NAME_PATTERN.matcher((CharSequence)s).matches()) {
            throw new IllegalArgumentException(new ConfigException(MessageFormat.format(I18N.getString("error.invalid-value-for-package-name"), s), I18N.getString("error.invalid-value-for-package-name.advice")));
        }
        return s;
    });
    public static final BundlerParamInfo<String> FULL_PACKAGE_NAME = new StandardBundlerParam<String>(I18N.getString("param.full-package-name.name"), I18N.getString("param.full-package-name.description"), "linux.deb.fullPackageName", String.class, params -> BUNDLE_NAME.fetchFrom((Map<String, Object>)params) + "-" + (String)StandardBundlerParam.VERSION.fetchFrom((Map<String, Object>)params), (s, p) -> s);
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "linux"), (s, p) -> new File((String)s));
    public static final BundlerParamInfo<File> DEB_IMAGE_DIR = new StandardBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "linux.deb.imageDir", File.class, params -> {
        File imagesRoot = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)params);
        if (!imagesRoot.exists()) {
            imagesRoot.mkdirs();
        }
        return new File(new File(imagesRoot, "linux-deb.image"), FULL_PACKAGE_NAME.fetchFrom((Map<String, Object>)params));
    }, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<File> APP_IMAGE_ROOT = new StandardBundlerParam<File>(I18N.getString("param.app-image-root.name"), I18N.getString("param.app-image-root.description"), "linux.deb.imageRoot", File.class, params -> {
        File imageDir = DEB_IMAGE_DIR.fetchFrom((Map<String, Object>)params);
        return new File(imageDir, "opt");
    }, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<File> CONFIG_DIR = new StandardBundlerParam<File>(I18N.getString("param.config-dir.name"), I18N.getString("param.config-dir.description"), "linux.deb.configDir", File.class, params -> new File(DEB_IMAGE_DIR.fetchFrom((Map<String, Object>)params), "DEBIAN"), (s, p) -> new File((String)s));
    public static final BundlerParamInfo<String> EMAIL = new StandardBundlerParam<String>(I18N.getString("param.maintainer-email.name"), I18N.getString("param.maintainer-email.description"), "email", String.class, params -> "Unknown", (s, p) -> s);
    public static final BundlerParamInfo<String> MAINTAINER = new StandardBundlerParam<String>(I18N.getString("param.maintainer-name.name"), I18N.getString("param.maintainer-name.description"), "linux.deb.maintainer", String.class, params -> (String)StandardBundlerParam.VENDOR.fetchFrom((Map<String, Object>)params) + " <" + EMAIL.fetchFrom((Map<String, Object>)params) + ">", (s, p) -> s);
    public static final BundlerParamInfo<String> LICENSE_TEXT = new StandardBundlerParam<String>(I18N.getString("param.license-text.name"), I18N.getString("param.license-text.description"), "linux.deb.licenseText", String.class, params -> {
        block4: {
            try {
                List licenseFiles = (List)StandardBundlerParam.LICENSE_FILE.fetchFrom((Map<String, Object>)params);
                if (licenseFiles.size() > 0) {
                    String licFileStr = (String)licenseFiles.get(0);
                    for (RelativeFileSet rfs : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom((Map<String, Object>)params)) {
                        if (!rfs.contains(licFileStr)) continue;
                        return new String(IOUtils.readFully(new File(rfs.getBaseDirectory(), licFileStr)));
                    }
                }
            }
            catch (Exception e) {
                if (!Log.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return StandardBundlerParam.LICENSE_TYPE.fetchFrom((Map<String, Object>)params);
    }, (s, p) -> s);
    public static final BundlerParamInfo<String> XDG_FILE_PREFIX = new StandardBundlerParam<String>(I18N.getString("param.xdg-prefix.name"), I18N.getString("param.xdg-prefix.description"), "linux.xdg-prefix", String.class, params -> {
        try {
            String vendor = params.containsKey(StandardBundlerParam.VENDOR.getID()) ? (String)StandardBundlerParam.VENDOR.fetchFrom((Map<String, Object>)params) : "javapackager";
            String appName = (String)StandardBundlerParam.APP_FS_NAME.fetchFrom((Map<String, Object>)params);
            return (vendor + "-" + appName).replaceAll("\\s", "");
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                e.printStackTrace();
            }
            return "unknown-MimeInfo.xml";
        }
    }, (s, p) -> s);
    private static final String DEFAULT_ICON = "javalogo_white_32.png";
    private static final String DEFAULT_CONTROL_TEMPLATE = "template.control";
    private static final String DEFAULT_PRERM_TEMPLATE = "template.prerm";
    private static final String DEFAULT_PREINSTALL_TEMPLATE = "template.preinst";
    private static final String DEFAULT_POSTRM_TEMPLATE = "template.postrm";
    private static final String DEFAULT_POSTINSTALL_TEMPLATE = "template.postinst";
    private static final String DEFAULT_COPYRIGHT_TEMPLATE = "template.copyright";
    private static final String DEFAULT_DESKTOP_FILE_TEMPLATE = "template.desktop";
    private static final String DEFAULT_INIT_SCRIPT_TEMPLATE = "template.deb.init.script";
    public static final String TOOL_DPKG = "dpkg-deb";

    public LinuxDebBundler() {
        this.baseResourceLoader = LinuxResources.class;
    }

    public static boolean testTool(String toolName, String minVersion) {
        try {
            ProcessBuilder pb = new ProcessBuilder(toolName, "--version");
            IOUtils.exec(pb, Log.isDebug(), true);
        }
        catch (Exception e) {
            Log.verbose(MessageFormat.format(I18N.getString("message.test-for-tool"), toolName, e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        try {
            boolean systemWide;
            boolean serviceHint;
            if (p == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(p).doValidate(p);
            if (!LinuxDebBundler.testTool(TOOL_DPKG, "1")) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.tool-not-found"), TOOL_DPKG), I18N.getString("error.tool-not-found.advice"));
            }
            if (p.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                List appResourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(p);
                for (String license : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(p)) {
                    boolean found = false;
                    for (RelativeFileSet appResources : appResourcesList) {
                        found = found || appResources.contains(license);
                    }
                    if (found) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), license));
                }
            } else {
                Log.info(I18N.getString("message.debs-like-licenses"));
            }
            boolean bl = serviceHint = p.containsKey(StandardBundlerParam.SERVICE_HINT.getID()) && (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(p) != false;
            if (serviceHint && BUNDLE_NAME.fetchFrom(p).length() > 16) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.launcher-name-too-long"), BUNDLE_NAME.fetchFrom(p)), MessageFormat.format(I18N.getString("error.launcher-name-too-long.advice"), BUNDLE_NAME.getID()));
            }
            boolean bl2 = systemWide = StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) == null || (Boolean)StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) != false;
            if (serviceHint && !systemWide) {
                throw new ConfigException(I18N.getString("error.no-support-for-peruser-daemons"), I18N.getString("error.no-support-for-peruser-daemons.advice"));
            }
            List associations = (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(p);
            if (associations != null) {
                for (int i = 0; i < associations.size(); ++i) {
                    Map assoc = (Map)associations.get(i);
                    List mimes = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(assoc);
                    if (mimes == null || mimes.isEmpty()) {
                        throw new ConfigException(MessageFormat.format(I18N.getString("error.no-content-types-for-file-association"), i), I18N.getString("error.no-content-types-for-file-association.advice"));
                    }
                    if (mimes.size() <= 1) continue;
                    throw new ConfigException(MessageFormat.format(I18N.getString("error.too-many-content-types-for-file-association"), i), I18N.getString("error.too-many-content-types-for-file-association.advice"));
                }
            }
            BUNDLE_NAME.getStringConverter().apply(BUNDLE_NAME.fetchFrom(p), p);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    private boolean prepareProto(Map<String, ? super Object> p) {
        File appImageRoot = APP_IMAGE_ROOT.fetchFrom(p);
        File appDir = APP_BUNDLER.fetchFrom(p).doBundle(p, appImageRoot, true);
        return appDir != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> p, File outdir) {
        File imageDir;
        block31: {
            if (!outdir.isDirectory() && !outdir.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outdir.getAbsolutePath()));
            }
            if (!outdir.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outdir.getAbsolutePath()));
            }
            imageDir = DEB_IMAGE_DIR.fetchFrom(p);
            File configDir = CONFIG_DIR.fetchFrom(p);
            imageDir.mkdirs();
            configDir.mkdirs();
            if (!this.prepareProto(p) || !this.prepareProjectConfig(p)) break block31;
            File file = this.buildDeb(p, outdir);
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.saveConfigFiles(p);
                }
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            return file;
        }
        File file = null;
        try {
            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                this.saveConfigFiles(p);
            }
            if (imageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(imageDir);
            } else if (imageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return file;
        catch (IOException ex) {
            File file2;
            try {
                ex.printStackTrace();
                file2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                        this.saveConfigFiles(p);
                    }
                    if (imageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(imageDir);
                    } else if (imageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException ex2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.saveConfigFiles(p);
                }
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex3) {
                return null;
            }
            return file2;
        }
    }

    private void setPermissions(File file, String permissions) {
        Set<PosixFilePermission> filePermissions = PosixFilePermissions.fromString(permissions);
        try {
            if (file.exists()) {
                Files.setPosixFilePermissions(file.toPath(), filePermissions);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LinuxDebBundler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void saveConfigFiles(Map<String, ? super Object> params) {
        try {
            File configRoot = CONFIG_ROOT.fetchFrom(params);
            File rootDir = LinuxAppBundler.getRootDir(APP_IMAGE_ROOT.fetchFrom(params), params);
            if (this.getConfig_ControlFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_ControlFile(params), new File(configRoot, this.getConfig_ControlFile(params).getName()));
            }
            if (this.getConfig_CopyrightFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_CopyrightFile(params), new File(configRoot, this.getConfig_CopyrightFile(params).getName()));
            }
            if (this.getConfig_PreinstallFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_PreinstallFile(params), new File(configRoot, this.getConfig_PreinstallFile(params).getName()));
            }
            if (this.getConfig_PrermFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_PrermFile(params), new File(configRoot, this.getConfig_PrermFile(params).getName()));
            }
            if (this.getConfig_PostinstallFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_PostinstallFile(params), new File(configRoot, this.getConfig_PostinstallFile(params).getName()));
            }
            if (this.getConfig_PostrmFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_PostrmFile(params), new File(configRoot, this.getConfig_PostrmFile(params).getName()));
            }
            if (this.getConfig_DesktopShortcutFile(rootDir, params).exists()) {
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(rootDir, params), new File(configRoot, this.getConfig_DesktopShortcutFile(rootDir, params).getName()));
            }
            for (Map secondaryLauncher : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(params)) {
                if (!this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher).exists()) continue;
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher), new File(configRoot, this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher).getName()));
            }
            if (this.getConfig_IconFile(rootDir, params).exists()) {
                IOUtils.copyFile(this.getConfig_IconFile(rootDir, params), new File(configRoot, this.getConfig_IconFile(rootDir, params).getName()));
            }
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue() && this.getConfig_InitScriptFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_InitScriptFile(params), new File(configRoot, this.getConfig_InitScriptFile(params).getName()));
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), configRoot.getAbsolutePath()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String getArch() {
        String arch = System.getProperty("os.arch");
        if ("i386".equals(arch)) {
            return "i386";
        }
        return "amd64";
    }

    private long getInstalledSizeKB(Map<String, ? super Object> params) {
        return this.getInstalledSizeKB(APP_IMAGE_ROOT.fetchFrom(params)) >> 10;
    }

    private long getInstalledSizeKB(File dir) {
        long count = 0L;
        File[] children = dir.listFiles();
        if (children != null) {
            for (File file : children) {
                if (file.isFile()) {
                    count += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                count += this.getInstalledSizeKB(file);
            }
        }
        return count;
    }

    private boolean prepareProjectConfig(Map<String, ? super Object> params) throws IOException {
        Map<String, String> data = this.createReplacementData(params);
        File rootDir = LinuxAppBundler.getRootDir(APP_IMAGE_ROOT.fetchFrom(params), params);
        File iconTarget = this.getConfig_IconFile(rootDir, params);
        File icon = LinuxAppBundler.ICON_PNG.fetchFrom(params);
        if (icon == null || !icon.exists()) {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        } else {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), icon, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        }
        StringBuilder installScripts = new StringBuilder();
        StringBuilder removeScripts = new StringBuilder();
        for (Map secondaryLauncher : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(params)) {
            Map<String, String> secondaryLauncherData = this.createReplacementData(secondaryLauncher);
            secondaryLauncherData.put("APPLICATION_FS_NAME", data.get("APPLICATION_FS_NAME"));
            secondaryLauncherData.put("DESKTOP_MIMES", "");
            BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher)));
            String content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, secondaryLauncherData, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            w.write(content);
            ((Writer)w).close();
            iconTarget = this.getConfig_IconFile(rootDir, secondaryLauncher);
            icon = LinuxAppBundler.ICON_PNG.fetchFrom(secondaryLauncher);
            if (icon == null || !icon.exists()) {
                this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            } else {
                this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), icon, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            }
            installScripts.append("        xdg-desktop-menu install --novendor /opt/");
            installScripts.append(data.get("APPLICATION_FS_NAME"));
            installScripts.append("/");
            installScripts.append(secondaryLauncherData.get("APPLICATION_LAUNCHER_FILENAME"));
            installScripts.append(".desktop\n");
            removeScripts.append("        xdg-desktop-menu uninstall --novendor /opt/");
            removeScripts.append(data.get("APPLICATION_FS_NAME"));
            removeScripts.append("/");
            removeScripts.append(secondaryLauncherData.get("APPLICATION_LAUNCHER_FILENAME"));
            removeScripts.append(".desktop\n");
        }
        data.put("SECONDARY_LAUNCHERS_INSTALL", installScripts.toString());
        data.put("SECONDARY_LAUNCHERS_REMOVE", removeScripts.toString());
        StringBuilder cdsScript = new StringBuilder();
        if (((Boolean)StandardBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(params)).booleanValue() && ((Boolean)StandardBundlerParam.ENABLE_APP_CDS.fetchFrom(params)).booleanValue() && ("install".equals(StandardBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)) || "auto+install".equals(StandardBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)))) {
            cdsScript.append("/opt/");
            cdsScript.append(data.get("APPLICATION_FS_NAME"));
            cdsScript.append("/");
            cdsScript.append(data.get("APPLICATION_LAUNCHER_FILENAME"));
            cdsScript.append(" -Xappcds:generatecache\n");
        }
        data.put("APP_CDS_CACHE", cdsScript.toString());
        List associations = (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(params);
        data.put("FILE_ASSOCIATION_INSTALL", "");
        data.put("FILE_ASSOCIATION_REMOVE", "");
        data.put("DESKTOP_MIMES", "");
        if (associations != null) {
            String mimeInfoFile = XDG_FILE_PREFIX.fetchFrom(params) + "-MimeInfo.xml";
            StringBuilder mimeInfo = new StringBuilder("<?xml version=\"1.0\"?>\n<mime-info xmlns='http://www.freedesktop.org/standards/shared-mime-info'>\n");
            StringBuilder registrations = new StringBuilder();
            StringBuilder deregistrations = new StringBuilder();
            StringBuilder desktopMimes = new StringBuilder("MimeType=");
            boolean addedEntry = false;
            for (Map assoc : associations) {
                int size;
                List mimes;
                if (assoc == null) continue;
                String description = (String)StandardBundlerParam.FA_DESCRIPTION.fetchFrom(assoc);
                File faIcon = (File)StandardBundlerParam.FA_ICON.fetchFrom(assoc);
                List extensions = (List)StandardBundlerParam.FA_EXTENSIONS.fetchFrom(assoc);
                if (extensions == null) {
                    Log.info(I18N.getString("message.creating-association-with-null-extension"));
                }
                if ((mimes = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(assoc)) == null || mimes.isEmpty()) continue;
                String thisMime = (String)mimes.get(0);
                String dashMime = thisMime.replace('/', '-');
                mimeInfo.append("  <mime-type type='").append(thisMime).append("'>\n");
                if (description != null && !description.isEmpty()) {
                    mimeInfo.append("    <comment>").append(description).append("</comment>\n");
                }
                if (extensions != null) {
                    for (String ext : extensions) {
                        mimeInfo.append("    <glob pattern='*.").append(ext).append("'/>\n");
                    }
                }
                mimeInfo.append("  </mime-type>\n");
                if (!addedEntry) {
                    registrations.append("        xdg-mime install /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(mimeInfoFile).append("\n");
                    deregistrations.append("        xdg-mime uninstall /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(mimeInfoFile).append("\n");
                    addedEntry = true;
                } else {
                    desktopMimes.append(";");
                }
                desktopMimes.append(thisMime);
                if (faIcon == null || !faIcon.exists() || (size = this.getSquareSizeOfImage(faIcon)) <= 0) continue;
                File target = new File(rootDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + "_fa_" + faIcon.getName());
                IOUtils.copyFile(faIcon, target);
                registrations.append("        xdg-icon-resource install --context mimetypes --size ").append(size).append(" /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(target.getName()).append(" ").append(dashMime).append("\n");
                deregistrations.append("        xdg-icon-resource uninstall --context mimetypes --size ").append(size).append(" /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(target.getName()).append(" ").append(dashMime).append("\n");
            }
            mimeInfo.append("</mime-info>");
            if (addedEntry) {
                BufferedWriter w = new BufferedWriter(new FileWriter(new File(rootDir, mimeInfoFile)));
                w.write(mimeInfo.toString());
                ((Writer)w).close();
                data.put("FILE_ASSOCIATION_INSTALL", registrations.toString());
                data.put("FILE_ASSOCIATION_REMOVE", deregistrations.toString());
                data.put("DESKTOP_MIMES", desktopMimes.toString());
            }
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(rootDir, params)));
        String content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(rootDir, params).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        w = new BufferedWriter(new FileWriter(this.getConfig_ControlFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_ControlFile(params).getName(), I18N.getString("resource.deb-control-file"), DEFAULT_CONTROL_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        w = new BufferedWriter(new FileWriter(this.getConfig_PreinstallFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PreinstallFile(params).getName(), I18N.getString("resource.deb-preinstall-script"), DEFAULT_PREINSTALL_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        this.setPermissions(this.getConfig_PreinstallFile(params), "rwxr-xr-x");
        w = new BufferedWriter(new FileWriter(this.getConfig_PrermFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PrermFile(params).getName(), I18N.getString("resource.deb-prerm-script"), DEFAULT_PRERM_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        this.setPermissions(this.getConfig_PrermFile(params), "rwxr-xr-x");
        w = new BufferedWriter(new FileWriter(this.getConfig_PostinstallFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PostinstallFile(params).getName(), I18N.getString("resource.deb-postinstall-script"), DEFAULT_POSTINSTALL_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        this.setPermissions(this.getConfig_PostinstallFile(params), "rwxr-xr-x");
        w = new BufferedWriter(new FileWriter(this.getConfig_PostrmFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PostrmFile(params).getName(), I18N.getString("resource.deb-postrm-script"), DEFAULT_POSTRM_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        this.setPermissions(this.getConfig_PostrmFile(params), "rwxr-xr-x");
        w = new BufferedWriter(new FileWriter(this.getConfig_CopyrightFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_CopyrightFile(params).getName(), I18N.getString("resource.deb-copyright-file"), DEFAULT_COPYRIGHT_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
            w = new BufferedWriter(new FileWriter(this.getConfig_InitScriptFile(params)));
            content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_InitScriptFile(params).getName(), I18N.getString("resource.deb-init-script"), DEFAULT_INIT_SCRIPT_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            w.write(content);
            ((Writer)w).close();
            this.setPermissions(this.getConfig_InitScriptFile(params), "rwxr-xr-x");
        }
        return true;
    }

    private Map<String, String> createReplacementData(Map<String, ? super Object> params) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("APPLICATION_NAME", (String)StandardBundlerParam.APP_NAME.fetchFrom(params));
        data.put("APPLICATION_FS_NAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
        data.put("APPLICATION_PACKAGE", BUNDLE_NAME.fetchFrom(params));
        data.put("APPLICATION_VENDOR", (String)StandardBundlerParam.VENDOR.fetchFrom(params));
        data.put("APPLICATION_MAINTAINER", MAINTAINER.fetchFrom(params));
        data.put("APPLICATION_VERSION", (String)StandardBundlerParam.VERSION.fetchFrom(params));
        data.put("APPLICATION_LAUNCHER_FILENAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
        data.put("XDG_PREFIX", XDG_FILE_PREFIX.fetchFrom(params));
        data.put("DEPLOY_BUNDLE_CATEGORY", (String)StandardBundlerParam.CATEGORY.fetchFrom(params));
        data.put("APPLICATION_DESCRIPTION", (String)StandardBundlerParam.DESCRIPTION.fetchFrom(params));
        data.put("APPLICATION_SUMMARY", (String)StandardBundlerParam.TITLE.fetchFrom(params));
        data.put("APPLICATION_COPYRIGHT", (String)StandardBundlerParam.COPYRIGHT.fetchFrom(params));
        data.put("APPLICATION_LICENSE_TYPE", StandardBundlerParam.LICENSE_TYPE.fetchFrom(params));
        data.put("APPLICATION_LICENSE_TEXT", LICENSE_TEXT.fetchFrom(params));
        data.put("APPLICATION_ARCH", this.getArch());
        data.put("APPLICATION_INSTALLED_SIZE", Long.toString(this.getInstalledSizeKB(params)));
        data.put("SERVICE_HINT", String.valueOf(StandardBundlerParam.SERVICE_HINT.fetchFrom(params)));
        data.put("START_ON_INSTALL", String.valueOf(StandardBundlerParam.START_ON_INSTALL.fetchFrom(params)));
        data.put("STOP_ON_UNINSTALL", String.valueOf(StandardBundlerParam.STOP_ON_UNINSTALL.fetchFrom(params)));
        data.put("RUN_AT_STARTUP", String.valueOf(StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(params)));
        return data;
    }

    private File getConfig_DesktopShortcutFile(File rootDir, Map<String, ? super Object> params) {
        return new File(rootDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".desktop");
    }

    private File getConfig_IconFile(File rootDir, Map<String, ? super Object> params) {
        return new File(rootDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".png");
    }

    private File getConfig_InitScriptFile(Map<String, ? super Object> params) {
        return new File(LinuxAppBundler.getRootDir(APP_IMAGE_ROOT.fetchFrom(params), params), BUNDLE_NAME.fetchFrom(params) + ".init");
    }

    private File getConfig_ControlFile(Map<String, ? super Object> params) {
        return new File(CONFIG_DIR.fetchFrom(params), "control");
    }

    private File getConfig_PreinstallFile(Map<String, ? super Object> params) {
        return new File(CONFIG_DIR.fetchFrom(params), "preinst");
    }

    private File getConfig_PrermFile(Map<String, ? super Object> params) {
        return new File(CONFIG_DIR.fetchFrom(params), "prerm");
    }

    private File getConfig_PostinstallFile(Map<String, ? super Object> params) {
        return new File(CONFIG_DIR.fetchFrom(params), "postinst");
    }

    private File getConfig_PostrmFile(Map<String, ? super Object> params) {
        return new File(CONFIG_DIR.fetchFrom(params), "postrm");
    }

    private File getConfig_CopyrightFile(Map<String, ? super Object> params) {
        return new File(CONFIG_DIR.fetchFrom(params), "copyright");
    }

    private File buildDeb(Map<String, ? super Object> params, File outdir) throws IOException {
        File outFile = new File(outdir, FULL_PACKAGE_NAME.fetchFrom(params) + ".deb");
        Log.verbose(MessageFormat.format(I18N.getString("message.outputting-to-location"), outFile.getAbsolutePath()));
        outFile.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder("fakeroot", TOOL_DPKG, "-b", FULL_PACKAGE_NAME.fetchFrom(params), outFile.getAbsolutePath());
        pb = pb.directory(DEB_IMAGE_DIR.fetchFrom(params).getParentFile());
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
        Log.info(MessageFormat.format(I18N.getString("message.output-to-location"), outFile.getAbsolutePath()));
        return outFile;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "deb";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(LinuxAppBundler.getAppBundleParameters());
        results.addAll(LinuxDebBundler.getDebBundleParameters());
        return results;
    }

    public static Collection<BundlerParamInfo<?>> getDebBundleParameters() {
        return Arrays.asList(BUNDLE_NAME, StandardBundlerParam.COPYRIGHT, StandardBundlerParam.CATEGORY, StandardBundlerParam.DESCRIPTION, EMAIL, LinuxAppBundler.ICON_PNG, StandardBundlerParam.LICENSE_FILE, StandardBundlerParam.LICENSE_TYPE, StandardBundlerParam.TITLE, StandardBundlerParam.VENDOR);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }

    public int getSquareSizeOfImage(File f) {
        try {
            BufferedImage bi = ImageIO.read(f);
            if (bi.getWidth() == bi.getHeight()) {
                return bi.getWidth();
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

